/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.ClosePrjCommand;
import net.astah.jomt.jcontrol.CreateNewPrjCommand;
import net.astah.jomt.jcontrol.SavePrjSeqCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;

public class CreateNewPrjSeqCommand
extends Command {
    protected String templateFilePath = "";
    protected boolean setLanguageInfo = true;
    protected boolean createDefaultDiagram = true;
    protected boolean createDefaultModel = true;
    protected boolean isAPIUseDefinedTaggedValues = false;

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            if (project != null) {
                if (project.doc.isModified() && !JomtGlobal.isNoGUI()) {
                    int n2 = MessageManager.displayMessageYesNoDialog("app", "ask_save_file.message");
                    if (n2 == 0) {
                        SavePrjSeqCommand savePrjSeqCommand = new SavePrjSeqCommand();
                        savePrjSeqCommand.setShowProgress(false);
                        this.callCommand(savePrjSeqCommand);
                        if (!savePrjSeqCommand.getExitState()) {
                            return;
                        }
                    } else if (n2 == 2) {
                        return;
                    }
                }
                ClosePrjCommand closePrjCommand = this.createClosePrjCommand();
                closePrjCommand.setProject(project);
                this.callCommand(closePrjCommand);
            }
            this.callCommand(this.createCreateNewPrjCommand());
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected ClosePrjCommand createClosePrjCommand() {
        return new ClosePrjCommand();
    }

    protected Command createCreateNewPrjCommand() {
        CreateNewPrjCommand createNewPrjCommand = new CreateNewPrjCommand();
        createNewPrjCommand.setTemplateFilePath(this.templateFilePath);
        createNewPrjCommand.setAPIUseDefinedTaggedValues(this.isAPIUseDefinedTaggedValues);
        createNewPrjCommand.setCreateDefaultDiagram(this.createDefaultDiagram);
        createNewPrjCommand.setCreateDefaultModel(this.createDefaultModel);
        createNewPrjCommand.setLanguageInfo(this.setLanguageInfo);
        return createNewPrjCommand;
    }

    public void setLanguageInfo(boolean bl) {
        this.setLanguageInfo = bl;
    }

    public void setTemplateFilePath(String string) {
        this.templateFilePath = string;
    }

    public void setCreateDefaultDiagram(boolean bl) {
        this.createDefaultDiagram = bl;
    }

    public void setCreateDefaultModel(boolean bl) {
        this.createDefaultModel = bl;
    }

    public void setAPIUseDefinedTaggedValues(boolean bl) {
        this.isAPIUseDefinedTaggedValues = bl;
    }
}

