/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.ModelFactory;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class CreateModelFromPrjCommand
extends Command {
    protected Model newModel;

    public Model getNewModel() {
        return this.newModel;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        int n2 = 100;
        while (n2-- > 0) {
            try {
                Object t2 = JomtGlobal.commandSupport.getSelectedModelElementFromProjectView();
                if (t2 == null || !(t2 instanceof Model)) {
                    return;
                }
                Package package_ = (Package)t2;
                try {
                    iJomtEntityStore.beginTransaction();
                    this.createNewModel(iJomtEntityStore, package_, null);
                    iJomtEntityStore.commitTransaction();
                    JomtGlobal.commandSupport.startEditing(this.newModel);
                    break;
                }
                catch (UMLSemanticsException uMLSemanticsException) {
                    iJomtEntityStore.abortTransaction();
                }
                catch (BadTransactionException badTransactionException) {
                    MessageManager.requireBugReport(badTransactionException);
                    iJomtEntityStore.abortTransaction();
                    break;
                }
                catch (Exception exception) {
                    iJomtEntityStore.abortTransaction();
                    throw exception;
                }
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
            }
        }
    }

    public void createNewModel(IEntityStore iEntityStore, Package package_, String string) {
        this.newModel = string == null ? ModelFactory.createModel(package_) : ModelFactory.createModel(package_, string);
        Elements.compareStereotypeAndsetTagValue(this.newModel);
    }
}

