/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.base.Strings;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.CombinedFragmentPresentation;
import net.astah.jmodel.ExecutionSpecificationPresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.GatePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InteractionFragmentPresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.SequenceMessagePresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.impl.SequenceMessagePresentationImpl;
import net.astah.jomt.jcontrol.CreateReturnMessageCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.SequenceDiagramOperations;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.operations.InteractionPresentations;
import net.astah.uml2.operations.MessagePresentations;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.ExecutionSpecifications;
import net.astah.uml2.uml.Messages;
import net.astah.uml2.uml.OccurrenceSpecifications;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class CreateMessageCommand
extends Command {
    protected SequenceMessagePresentation messagePs = null;
    protected Presentation sourcePs;
    protected Presentation targetPs;
    protected UMLDiagram dgm;
    protected List points;
    protected boolean isShiftPressed = false;
    protected CombinedFragmentPresentation combinedFragmentPs = null;

    public void setPresentation(SequenceMessagePresentation sequenceMessagePresentation) {
        this.messagePs = sequenceMessagePresentation;
    }

    public void setSenderPresentation(Presentation presentation) {
        this.sourcePs = presentation;
    }

    public void setReceiverPresentation(Presentation presentation) {
        this.targetPs = presentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setPoint(List list) {
        this.points = list;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (!this.isValidMessage(iJomtEntityStore)) {
                    if (this.useTransaction) {
                        iJomtEntityStore.abortTransaction();
                    }
                    return;
                }
                UMLSequenceDiagram uMLSequenceDiagram = (UMLSequenceDiagram)this.dgm;
                Interaction interaction = uMLSequenceDiagram.getInteraction();
                Message message = interaction.createMessage(null);
                String string = this.getMessageName();
                if (Strings.isNullOrEmpty(string)) {
                    if (message.isSetName()) {
                        message.unsetName();
                    }
                } else {
                    message.setName(string);
                }
                message.setMessageSort(this.getMessageSort());
                this.adjustInteractionUseLocation();
                ElementPresentations.addPresentation(message, this.messagePs, uMLSequenceDiagram);
                SequenceMessageEndPresentation sequenceMessageEndPresentation = this.setSourcePsAndSender(message, this.sourcePs);
                SequenceMessageEndPresentation sequenceMessageEndPresentation2 = this.setTargetPsAndReceiver(message, sequenceMessageEndPresentation);
                if (sequenceMessageEndPresentation != null) {
                    sequenceMessageEndPresentation.resize();
                }
                if (this.needToMoveOtherActivation(sequenceMessageEndPresentation2)) {
                    this.moveOverlapActivation(this.dgm, sequenceMessageEndPresentation2);
                    ((LifelinePresentation)sequenceMessageEndPresentation2.getFather()).updateLifeline();
                }
                if (sequenceMessageEndPresentation != null) {
                    // empty if block
                }
                this.createRelatedPresentation(message, sequenceMessageEndPresentation2);
                if (message.getMessageSort() != MessageSort.REPLY_LITERAL) {
                    SequenceDiagramOperations.setAllMessageIndex((UMLSequenceDiagram)this.dgm);
                }
                this.setParameterVisibility(uMLSequenceDiagram);
                this.createRelationWithCombinedFragment();
                if (!(this.messagePs.isLostMsgPresentation() || this.messagePs.isFoundMsgPresentation() || this.messagePs.isDestroyMsgPresentation() || this.messagePs.isReturnMsgPresentation())) {
                    this.createReturnMsgAutomatic();
                }
                Elements.compareStereotypeAndsetTagValue(message);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (IllegalModelTypeException illegalModelTypeException) {
                MessageManager.requireBugReport(illegalModelTypeException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void setParameterVisibility(UMLSequenceDiagram uMLSequenceDiagram) {
        this.messagePs.setParameterVisibility(uMLSequenceDiagram.isMessageParamVisible());
        this.messagePs.setParameterTypeVisibility(uMLSequenceDiagram.isMessageParamTypeVisible());
        this.messagePs.setParameterDirectionKindVisibility(uMLSequenceDiagram.isMessageParamDirectionKindVisible());
        this.messagePs.setReturnValueVisibility(uMLSequenceDiagram.isMessageReturnValueVisible());
        this.messagePs.setReturnValueVariableVisibility(uMLSequenceDiagram.isMessageReturnValueVariableVisible());
    }

    protected void createRelatedPresentation(Message message, SequenceMessageEndPresentation sequenceMessageEndPresentation) {
    }

    protected String getMessageName() {
        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.message.label") + ModelGlobal.prjManager.getCurrentProject().messageNum++;
        return string;
    }

    protected boolean isValidMessage(IEntityStore iEntityStore) {
        if (this.messagePs == null || iEntityStore == null || !(this.dgm instanceof UMLSequenceDiagram) || this.sourcePs == null && this.targetPs == null) {
            return false;
        }
        this.adjustCreateLocation();
        if (this.hasBelowActivation()) {
            MessageManager.displayAlertMessageDialog("uml", "message_cannot_below_termination.message");
            return false;
        }
        return true;
    }

    protected boolean needToMoveOtherActivation(SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        return sequenceMessageEndPresentation != null && sequenceMessageEndPresentation.getFather() instanceof LifelinePresentation;
    }

    protected SequenceMessageEndPresentation setTargetPsAndReceiver(Message message, SequenceMessageEndPresentation sequenceMessageEndPresentation) throws IllegalModelTypeException {
        SequenceMessageEndPresentation sequenceMessageEndPresentation2 = null;
        sequenceMessageEndPresentation2 = this.isSelfMessage(sequenceMessageEndPresentation, this.targetPs) ? this.setSelfEndPsAndReceive(message, sequenceMessageEndPresentation) : this.setEndPsAndReceive(message, this.targetPs);
        return sequenceMessageEndPresentation2;
    }

    protected MessageSort getMessageSort() {
        return MessageSort.SYNCH_CALL_LITERAL;
    }

    protected void adjustInteractionUseLocation() {
        if (this.sourcePs instanceof InteractionUsePresentation && this.targetPs instanceof SequenceMessageEndPresentation) {
            SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)this.targetPs;
            InteractionUsePresentation interactionUsePresentation = (InteractionUsePresentation)this.sourcePs;
            if (interactionUsePresentation.getLocation().y >= sequenceMessageEndPresentation.getLocation().y) {
                interactionUsePresentation.setHeight(interactionUsePresentation.getLocation().y + interactionUsePresentation.getHeight() - sequenceMessageEndPresentation.getLocation().y);
                interactionUsePresentation.setLocation(new Pnt2d(interactionUsePresentation.getLocation().x, sequenceMessageEndPresentation.getLocation().y));
            }
        }
    }

    protected void createRelationWithCombinedFragment() {
        InteractionOperand interactionOperand = this.a();
        if (interactionOperand != null) {
            Message message = this.messagePs.getMessage();
            interactionOperand.getFragments().addAll(MessagePresentations.getRelatedFragments(message));
        }
    }

    protected SequenceMessageEndPresentation setSourcePsAndSender(Message message, Presentation presentation) throws IllegalModelTypeException {
        SequenceMessageEndPresentation sequenceMessageEndPresentation = null;
        Pnt2d pnt2d = (Pnt2d)this.points.get(0);
        Pnt2d pnt2d2 = (Pnt2d)this.points.get(1);
        if (presentation != null) {
            if (presentation instanceof LifelinePresentation) {
                ExecutionSpecificationPresentation executionSpecificationPresentation = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
                LifelinePresentation lifelinePresentation = (LifelinePresentation)presentation;
                executionSpecificationPresentation.setDoAutoResize(true);
                if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
                    executionSpecificationPresentation.setWidth(10.0);
                } else {
                    executionSpecificationPresentation.setWidth(0.0);
                }
                executionSpecificationPresentation.setHeight(25.0);
                double d2 = lifelinePresentation.getMinX() + lifelinePresentation.getWidth() / 2.0;
                executionSpecificationPresentation.setLocation(new Pnt2d(d2 - executionSpecificationPresentation.getWidth() / 2.0, pnt2d.y));
                executionSpecificationPresentation.setDepth(this.messagePs.getDepth());
                executionSpecificationPresentation.getCovereds().add(lifelinePresentation);
                Lifeline lifeline = lifelinePresentation.getClassifierRole();
                BehaviorExecutionSpecification behaviorExecutionSpecification = ExecutionSpecifications.createBehaviorExecutionSpecification(lifeline);
                ElementPresentations.addPresentation(behaviorExecutionSpecification, executionSpecificationPresentation, this.dgm);
                MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.createMessageOccurrenceSpecification(lifeline);
                Messages.setSendEvent(message, messageOccurrenceSpecification);
                this.messagePs.setSourcePresentation(executionSpecificationPresentation);
                sequenceMessageEndPresentation = executionSpecificationPresentation;
            } else if (presentation instanceof SequenceMessageEndPresentation) {
                SequenceMessageEndPresentation sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)presentation;
                if (sequenceMessageEndPresentation2.getFather() != null) {
                    NamedElement namedElement;
                    if (sequenceMessageEndPresentation2.getActivatorMp() != null) {
                        namedElement = sequenceMessageEndPresentation2.getActivatorMp().getMessage();
                        Messages.setActivator(message, namedElement);
                    }
                    namedElement = (Lifeline)sequenceMessageEndPresentation2.getFather().getModel();
                    MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.createMessageOccurrenceSpecification((Lifeline)namedElement);
                    Messages.setSendEvent(message, messageOccurrenceSpecification);
                    this.messagePs.setSourcePresentation((JomtPresentation)presentation);
                    double d3 = (pnt2d.y - sequenceMessageEndPresentation2.getLocation().getY()) / sequenceMessageEndPresentation2.getHeight();
                    this.messagePs.setSourceEnd(1.0, d3);
                    sequenceMessageEndPresentation = sequenceMessageEndPresentation2;
                }
            } else if (presentation instanceof FramePresentation || presentation instanceof InteractionUsePresentation) {
                PresentationContainer presentationContainer = (PresentationContainer)presentation;
                Gate gate = InteractionPresentations.createGate(presentationContainer);
                gate.setMessage(message);
                GatePresentation gatePresentation = JmodelFactory.eINSTANCE.createGatePresentation();
                gatePresentation.setDoAutoResize(true);
                gatePresentation.setWidth(0.0);
                gatePresentation.setHeight(0.0);
                if (pnt2d.x < pnt2d2.x && pnt2d2.x < presentationContainer.getLocation().x + presentationContainer.getWidth() || pnt2d.x > pnt2d2.x && pnt2d2.x < presentationContainer.getLocation().x) {
                    gatePresentation.setLocation(new Pnt2d(presentationContainer.getLocation().x, pnt2d.y));
                } else if (pnt2d.x > pnt2d2.x && pnt2d2.x > presentationContainer.getLocation().x || pnt2d.x < pnt2d2.x && pnt2d2.x >= presentationContainer.getLocation().x + presentationContainer.getWidth()) {
                    gatePresentation.setLocation(new Pnt2d(presentationContainer.getLocation().x + presentationContainer.getWidth(), pnt2d.y));
                } else {
                    gatePresentation.setLocation((Pnt2d)this.points.get(0));
                }
                gatePresentation.setDepth(this.messagePs.getDepth());
                ElementPresentations.addPresentation(gate, gatePresentation, this.dgm);
                gatePresentation.setContainer(presentationContainer);
                message.setSendEvent(gate);
                this.messagePs.setSourcePresentation(gatePresentation);
                sequenceMessageEndPresentation = gatePresentation;
            }
        } else {
            ExecutionSpecificationPresentation executionSpecificationPresentation = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
            executionSpecificationPresentation.setDoAutoResize(true);
            if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
                executionSpecificationPresentation.setWidth(10.0);
            } else {
                executionSpecificationPresentation.setWidth(0.0);
            }
            executionSpecificationPresentation.setHeight(10.0);
            executionSpecificationPresentation.setLocation((Pnt2d)this.points.get(0));
            executionSpecificationPresentation.setDepth(this.messagePs.getDepth());
            ElementPresentations.addPresentation(null, executionSpecificationPresentation, this.dgm);
            this.messagePs.setSourcePresentation(executionSpecificationPresentation);
            sequenceMessageEndPresentation = executionSpecificationPresentation;
            if (((Pnt2d)this.points.get((int)0)).x < ((Pnt2d)this.points.get((int)1)).x) {
                this.messagePs.setSourceEnd(1.0, 0.0);
            } else {
                this.messagePs.setSourceEnd(0.0, 0.0);
            }
        }
        return sequenceMessageEndPresentation;
    }

    protected SequenceMessageEndPresentation setEndPsAndReceive(Message message, Presentation presentation) throws IllegalModelTypeException {
        EModelElement eModelElement;
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        JomtPresentation jomtPresentation;
        SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)this.messagePs.getSourcePresentation();
        if (sequenceMessageEndPresentation == null) {
            return null;
        }
        Object object4 = null;
        if (presentation != null && this.isNeedNestActivation(sequenceMessageEndPresentation, presentation)) {
            jomtPresentation = sequenceMessageEndPresentation.getActivatorMp();
            object3 = null;
            while (jomtPresentation.isSelfMsgPresentation()) {
                object2 = (SequenceMessageEndPresentation)jomtPresentation.getSourcePresentation();
                jomtPresentation = object2.getActivatorMp();
            }
            object2 = sequenceMessageEndPresentation.getChainSourceAps().iterator();
            cloneable = this.getClassifierRolePresentation(presentation);
            while (object2.hasNext()) {
                object = (SequenceMessageEndPresentation)object2.next();
                if (!object.getFather().equals(cloneable)) continue;
                object3 = object;
                break;
            }
            if (!sequenceMessageEndPresentation.hasChainRelatedAsynActivator((SequenceMessageEndPresentation)object3)) {
                object = this.createLoopMessage(message, (SequenceMessageEndPresentation)object3);
                return object;
            }
            presentation = this.getClassifierRolePresentation(presentation);
        }
        jomtPresentation = sequenceMessageEndPresentation.getFather();
        if (presentation instanceof SequenceMessageEndPresentation) {
            object3 = (SequenceMessageEndPresentation)this.targetPs;
            if (object3.getActivatorMp() != null) {
                presentation = object3.getFather();
            } else if (jomtPresentation instanceof LifelinePresentation) {
                object2 = this.a(sequenceMessageEndPresentation);
                cloneable = new HashMap();
                object = object2.iterator();
                while (object.hasNext()) {
                    eModelElement = (SequenceMessageEndPresentation)object.next();
                    if (cloneable.get(eModelElement.getFather()) != null) continue;
                    cloneable.put(eModelElement.getFather(), eModelElement.getFather());
                    this.a((SequenceMessageEndPresentation)eModelElement, (SequenceMessageEndPresentation)object3);
                }
            }
        }
        object3 = (Pnt2d)this.points.get(0);
        object2 = (Pnt2d)this.points.get(1);
        if (presentation instanceof LifelinePresentation) {
            cloneable = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
            object = (LifelinePresentation)presentation;
            cloneable.setDoAutoResize(true);
            if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
                cloneable.setWidth(10.0);
            } else {
                cloneable.setWidth(0.0);
            }
            cloneable.setHeight(25.0);
            double d2 = object.getMinX() + object.getWidth() / 2.0;
            cloneable.setLocation(new Pnt2d(d2 - cloneable.getWidth() / 2.0, ((Pnt2d)object3).y));
            cloneable.setDepth(this.messagePs.getDepth());
            cloneable.getCovereds().add((LifelinePresentation)object);
            Lifeline lifeline = object.getClassifierRole();
            BehaviorExecutionSpecification behaviorExecutionSpecification = ExecutionSpecifications.createBehaviorExecutionSpecification(lifeline);
            ElementPresentations.addPresentation(behaviorExecutionSpecification, (Presentation)cloneable, this.dgm);
            MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.resetExecutionSpecificationStart(behaviorExecutionSpecification, message.getMessageSort());
            Messages.setReceiveEvent(message, messageOccurrenceSpecification);
            this.messagePs.setTargetPresentation((JomtPresentation)cloneable);
            object4 = cloneable;
        } else if (presentation instanceof SequenceMessageEndPresentation) {
            cloneable = (SequenceMessageEndPresentation)presentation;
            object = (BehaviorExecutionSpecification)cloneable.getModel();
            eModelElement = OccurrenceSpecifications.resetExecutionSpecificationStart((ExecutionSpecification)object, message.getMessageSort());
            object.setStart((OccurrenceSpecification)eModelElement);
            Messages.setReceiveEvent(message, (MessageEnd)eModelElement);
            if (cloneable.getActivatorMp() == null) {
                Vec2d vec2d = new Vec2d(0.0, ((Pnt2d)object3).y - cloneable.getMinY());
                if (cloneable.getIncomingMessages().size() >= 1) {
                    cloneable.move(vec2d);
                }
                for (SequenceMessagePresentation sequenceMessagePresentation : cloneable.getOutgoingMessages()) {
                    Messages.setActivator(sequenceMessagePresentation.getMessage(), message);
                }
                if (cloneable.getMinY() > ((Pnt2d)object3).y) {
                    cloneable.setHeight(cloneable.getMaxY() - ((Pnt2d)object3).y);
                    cloneable.setLocation(new Pnt2d(cloneable.getMinX(), ((Pnt2d)object3).y));
                } else {
                    double d3 = 10.0;
                    if (cloneable.getTopestOutMessage().getAllPoints().get((int)0).y - cloneable.getMinY() < d3) {
                        cloneable.setHeight(cloneable.getHeight() + d3);
                        cloneable.setLocation(new Pnt2d(cloneable.getMinX(), cloneable.getMinY() - d3));
                    }
                    if (jomtPresentation instanceof InteractionUsePresentation && cloneable.getMinY() < jomtPresentation.getMinY()) {
                        jomtPresentation.setHeight(jomtPresentation.getMaxY() - cloneable.getMinY());
                        jomtPresentation.setLocation(new Pnt2d(jomtPresentation.getMinX(), cloneable.getMinY()));
                    }
                }
            }
            double d4 = (((Pnt2d)object3).y - cloneable.getLocation().y) / cloneable.getHeight();
            this.messagePs.setTargetEnd(0.0, d4);
            this.messagePs.setTargetPresentation((JomtPresentation)presentation);
            object4 = cloneable;
        } else if (presentation instanceof FramePresentation || presentation instanceof InteractionUsePresentation) {
            cloneable = (PresentationContainer)presentation;
            object = InteractionPresentations.createGate((Presentation)cloneable);
            object.setMessage(message);
            eModelElement = JmodelFactory.eINSTANCE.createGatePresentation();
            eModelElement.setDoAutoResize(true);
            eModelElement.setWidth(0.0);
            eModelElement.setHeight(0.0);
            this.setGatePsLoc(sequenceMessageEndPresentation, (Pnt2d)object3, (Pnt2d)object2, (RectPresentation)cloneable, (SequenceMessageEndPresentation)eModelElement);
            eModelElement.setDepth(this.messagePs.getDepth());
            ElementPresentations.addPresentation((Element)object, (Presentation)eModelElement, this.dgm);
            eModelElement.setContainer((PresentationContainer)cloneable);
            message.setReceiveEvent((MessageEnd)object);
            this.messagePs.setTargetPresentation((JomtPresentation)eModelElement);
            object4 = eModelElement;
        } else {
            cloneable = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
            cloneable.setDoAutoResize(true);
            if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
                cloneable.setWidth(10.0);
            } else {
                cloneable.setWidth(0.0);
            }
            cloneable.setHeight(10.0);
            cloneable.setLocation(new Pnt2d(((Point2D.Double)object2).getX(), ((Point2D.Double)object3).getY()));
            cloneable.setDepth(this.messagePs.getDepth());
            ElementPresentations.addPresentation(null, (Presentation)cloneable, this.dgm);
            this.messagePs.setTargetPresentation((JomtPresentation)cloneable);
            object4 = cloneable;
        }
        this.setTargetEnd();
        return object4;
    }

    private List a(SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        ArrayList<SequenceMessageEndPresentation> arrayList = new ArrayList<SequenceMessageEndPresentation>();
        arrayList.add(sequenceMessageEndPresentation);
        SequenceMessageEndPresentation sequenceMessageEndPresentation2 = sequenceMessageEndPresentation;
        SequenceMessagePresentation sequenceMessagePresentation = null;
        while ((sequenceMessagePresentation = sequenceMessageEndPresentation2.getActivatorMp()) != null && sequenceMessagePresentation.getSourcePresentation() instanceof SequenceMessageEndPresentation) {
            sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)sequenceMessagePresentation.getSourcePresentation();
            if (arrayList.contains(sequenceMessageEndPresentation2)) continue;
            arrayList.add(sequenceMessageEndPresentation2);
        }
        return arrayList;
    }

    private void a(SequenceMessageEndPresentation sequenceMessageEndPresentation, SequenceMessageEndPresentation sequenceMessageEndPresentation2) {
        if (!(sequenceMessageEndPresentation.getFather() instanceof LifelinePresentation)) {
            return;
        }
        LifelinePresentation lifelinePresentation = (LifelinePresentation)sequenceMessageEndPresentation.getFather();
        List<LabelPresentation> list = lifelinePresentation.getChainCRpsOfRelatedActivator(new ArrayList<LabelPresentation>());
        if (list.contains(sequenceMessageEndPresentation2.getFather())) {
            ArrayList<InteractionFragmentPresentation> arrayList = new ArrayList<InteractionFragmentPresentation>();
            arrayList.addAll(lifelinePresentation.getCoveredBys());
            arrayList.retainAll(sequenceMessageEndPresentation2.getChainTargetAps());
            for (Object e2 : arrayList) {
                SequenceMessagePresentation sequenceMessagePresentation;
                SequenceMessageEndPresentation sequenceMessageEndPresentation3;
                if (e2 instanceof SequenceMessageEndPresentation && ((sequenceMessageEndPresentation3 = (SequenceMessageEndPresentation)e2).getIncomingMessages().isEmpty() || !(sequenceMessagePresentation = sequenceMessageEndPresentation3.getIncomingMessages().get(0)).isAsynchMsgPresentation()) && !sequenceMessageEndPresentation3.getAllLefts().contains(sequenceMessageEndPresentation)) continue;
            }
            sequenceMessageEndPresentation.moveRightActivationPs(new Vec2d(10.0, 0.0), false);
        }
    }

    protected void setGatePsLoc(SequenceMessageEndPresentation sequenceMessageEndPresentation, Pnt2d pnt2d, Pnt2d pnt2d2, RectPresentation rectPresentation, SequenceMessageEndPresentation sequenceMessageEndPresentation2) {
        if (pnt2d.x < pnt2d2.x && pnt2d.x < rectPresentation.getLocation().x || pnt2d.x > pnt2d2.x && pnt2d.x < rectPresentation.getLocation().x + rectPresentation.getWidth()) {
            if (pnt2d.y > rectPresentation.getLocation().y + rectPresentation.getHeight() || pnt2d.y < rectPresentation.getLocation().y) {
                sequenceMessageEndPresentation2.setLocation(new Pnt2d(rectPresentation.getLocation().x, pnt2d2.y));
                sequenceMessageEndPresentation.setLocation(new Pnt2d(sequenceMessageEndPresentation.getLocation().x, pnt2d2.y));
                this.updateFather(sequenceMessageEndPresentation, pnt2d, pnt2d2, rectPresentation);
            } else {
                sequenceMessageEndPresentation2.setLocation(new Pnt2d(rectPresentation.getLocation().x, pnt2d.y));
            }
        } else if (pnt2d.x > pnt2d2.x && pnt2d.x > rectPresentation.getLocation().x + rectPresentation.getWidth() || pnt2d.x < pnt2d2.x && pnt2d.x > rectPresentation.getLocation().x) {
            if (pnt2d.y > rectPresentation.getLocation().y + rectPresentation.getHeight() || pnt2d.y < rectPresentation.getLocation().y) {
                sequenceMessageEndPresentation2.setLocation(new Pnt2d(rectPresentation.getLocation().x + rectPresentation.getWidth(), pnt2d2.y));
                sequenceMessageEndPresentation.setLocation(new Pnt2d(sequenceMessageEndPresentation.getLocation().x, pnt2d2.y));
                this.updateFather(sequenceMessageEndPresentation, pnt2d, pnt2d2, rectPresentation);
            } else {
                sequenceMessageEndPresentation2.setLocation(new Pnt2d(rectPresentation.getLocation().x + rectPresentation.getWidth(), pnt2d.y));
            }
        } else {
            sequenceMessageEndPresentation2.setLocation((Pnt2d)this.points.get(1));
        }
    }

    protected void updateFather(SequenceMessageEndPresentation sequenceMessageEndPresentation, Pnt2d pnt2d, Pnt2d pnt2d2, RectPresentation rectPresentation) {
        if (pnt2d.y < rectPresentation.getLocation().y) {
            if (sequenceMessageEndPresentation.getFather() instanceof InteractionUsePresentation) {
                InteractionUsePresentation interactionUsePresentation = (InteractionUsePresentation)sequenceMessageEndPresentation.getFather();
                interactionUsePresentation.setHeight(pnt2d2.y - interactionUsePresentation.getLocation().y);
            }
        } else if (pnt2d.y > rectPresentation.getLocation().y + rectPresentation.getHeight() && sequenceMessageEndPresentation.getFather() instanceof InteractionUsePresentation) {
            InteractionUsePresentation interactionUsePresentation = (InteractionUsePresentation)sequenceMessageEndPresentation.getFather();
            interactionUsePresentation.setHeight(interactionUsePresentation.getLocation().y + interactionUsePresentation.getHeight() - pnt2d2.y);
            interactionUsePresentation.setLocation(new Pnt2d(interactionUsePresentation.getLocation().x, pnt2d2.y));
        }
    }

    protected void setTargetEnd() {
        SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)this.messagePs.getSourcePresentation();
        SequenceMessageEndPresentation sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)this.messagePs.getTargetPresentation();
        if (sequenceMessageEndPresentation.getMinX() < sequenceMessageEndPresentation2.getMinX()) {
            this.messagePs.setTargetEnd(0.0, 0.0);
        } else {
            this.messagePs.setTargetEnd(1.0, 0.0);
        }
    }

    protected SequenceMessageEndPresentation setSelfEndPsAndReceive(Message message, SequenceMessageEndPresentation sequenceMessageEndPresentation) throws IllegalModelTypeException {
        boolean bl = true;
        SequenceMessageEndPresentation sequenceMessageEndPresentation2 = null;
        if (this.targetPs instanceof SequenceMessageEndPresentation) {
            sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)this.targetPs;
            if (!sequenceMessageEndPresentation.getAllLefts().contains(sequenceMessageEndPresentation2) && sequenceMessageEndPresentation2.getActivatorMp() == null && sequenceMessageEndPresentation2 != sequenceMessageEndPresentation) {
                bl = false;
            }
        }
        Pnt2d pnt2d = (Pnt2d)this.points.get(0);
        if (!bl) {
            this.setMessageNodes(sequenceMessageEndPresentation2, pnt2d);
            this.setSourceTargetEnd(sequenceMessageEndPresentation);
            BehaviorExecutionSpecification behaviorExecutionSpecification = (BehaviorExecutionSpecification)sequenceMessageEndPresentation2.getModel();
            MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.resetExecutionSpecificationStart(behaviorExecutionSpecification, message.getMessageSort());
            behaviorExecutionSpecification.setStart(messageOccurrenceSpecification);
            Messages.setReceiveEvent(message, messageOccurrenceSpecification);
            this.messagePs.setTargetPresentation(sequenceMessageEndPresentation2);
            Vec2d vec2d = new Vec2d(((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible() ? 10.0 : 0.0, 0.0);
            sequenceMessageEndPresentation2.moveRightActivationPs(vec2d);
            for (SequenceMessagePresentation sequenceMessagePresentation : sequenceMessageEndPresentation2.getOutgoingMessages()) {
                Messages.setActivator(sequenceMessagePresentation.getMessage(), message);
            }
        } else {
            ExecutionSpecificationPresentation executionSpecificationPresentation = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
            this.setSelfTargetPs(sequenceMessageEndPresentation, executionSpecificationPresentation);
            LifelinePresentation lifelinePresentation = (LifelinePresentation)sequenceMessageEndPresentation.getFather();
            executionSpecificationPresentation.getCovereds().add(lifelinePresentation);
            Lifeline lifeline = lifelinePresentation.getClassifierRole();
            BehaviorExecutionSpecification behaviorExecutionSpecification = ExecutionSpecifications.createBehaviorExecutionSpecification(lifeline);
            MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.resetExecutionSpecificationStart(behaviorExecutionSpecification, message.getMessageSort());
            Messages.setReceiveEvent(message, messageOccurrenceSpecification);
            ElementPresentations.addPresentation(behaviorExecutionSpecification, executionSpecificationPresentation, this.dgm);
            this.resetSelfSourceApHeight(sequenceMessageEndPresentation, executionSpecificationPresentation);
            this.setMessageNodes(executionSpecificationPresentation, pnt2d);
            this.setSourceTargetEnd(sequenceMessageEndPresentation);
            this.messagePs.setTargetPresentation(executionSpecificationPresentation);
            sequenceMessageEndPresentation2 = executionSpecificationPresentation;
        }
        return sequenceMessageEndPresentation2;
    }

    protected void resetSelfSourceApHeight(SequenceMessageEndPresentation sequenceMessageEndPresentation, SequenceMessageEndPresentation sequenceMessageEndPresentation2) {
        if (sequenceMessageEndPresentation.getLocation().y + sequenceMessageEndPresentation.getHeight() + 10.0 < sequenceMessageEndPresentation2.getLocation().y + sequenceMessageEndPresentation2.getHeight()) {
            sequenceMessageEndPresentation.setHeight(sequenceMessageEndPresentation2.getLocation().y + sequenceMessageEndPresentation2.getHeight() - sequenceMessageEndPresentation.getLocation().y + 10.0);
        }
    }

    protected void setSelfTargetPs(SequenceMessageEndPresentation sequenceMessageEndPresentation, SequenceMessageEndPresentation sequenceMessageEndPresentation2) {
        Pnt2d pnt2d = (Pnt2d)this.points.get(0);
        sequenceMessageEndPresentation2.setDoAutoResize(true);
        if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
            sequenceMessageEndPresentation2.setWidth(10.0);
        } else {
            sequenceMessageEndPresentation2.setWidth(0.0);
        }
        sequenceMessageEndPresentation2.setHeight(25.0);
        double d2 = this.getSelfTargetLocX(sequenceMessageEndPresentation);
        double d3 = pnt2d.y + SequenceMessagePresentationImpl.getSelfMessageDefaultHeight();
        sequenceMessageEndPresentation2.setLocation(new Pnt2d(d2, d3));
        sequenceMessageEndPresentation2.setDepth(sequenceMessageEndPresentation.getDepth());
    }

    protected double getSelfTargetLocX(SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        return sequenceMessageEndPresentation.getMaxX();
    }

    protected void setSourceTargetEnd(SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        double d2 = (this.messagePs.getPoints().get((int)0).y - sequenceMessageEndPresentation.getMinY()) / sequenceMessageEndPresentation.getHeight();
        this.messagePs.setSourceEnd(0.0, d2);
        this.messagePs.setTargetEnd(1.0, 0.0);
    }

    protected void setMessageNodes(SequenceMessageEndPresentation sequenceMessageEndPresentation, Pnt2d pnt2d) {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(), new Pnt2d()};
        pnt2dArray[0].x = sequenceMessageEndPresentation.getMinX() + SequenceMessagePresentationImpl.getSelfMessageDefaultWidth();
        pnt2dArray[0].y = pnt2d.y;
        pnt2dArray[1].x = pnt2dArray[0].x;
        pnt2dArray[1].y = pnt2dArray[0].y + SequenceMessagePresentationImpl.getSelfMessageDefaultHeight();
        this.messagePs.getPoints().clear();
        this.messagePs.getPoints().addAll(Arrays.asList(pnt2dArray));
    }

    protected SequenceMessageEndPresentation createLoopMessage(Message message, SequenceMessageEndPresentation sequenceMessageEndPresentation) throws IllegalModelTypeException {
        LifelinePresentation lifelinePresentation = (LifelinePresentation)sequenceMessageEndPresentation.getFather();
        Pnt2d pnt2d = (Pnt2d)this.points.get(0);
        ExecutionSpecificationPresentation executionSpecificationPresentation = JmodelFactory.eINSTANCE.createExecutionSpecificationPresentation();
        executionSpecificationPresentation.setDoAutoResize(true);
        if (((UMLSequenceDiagram)UMLSequenceDiagram.class.cast(this.dgm)).isExecutionSpecificationVisible()) {
            executionSpecificationPresentation.setWidth(10.0);
        } else {
            executionSpecificationPresentation.setWidth(0.0);
        }
        executionSpecificationPresentation.setHeight(25.0);
        executionSpecificationPresentation.setLocation(new Pnt2d(sequenceMessageEndPresentation.getMaxX(), pnt2d.y));
        executionSpecificationPresentation.setDepth(this.messagePs.getDepth());
        executionSpecificationPresentation.getCovereds().add(lifelinePresentation);
        double d2 = executionSpecificationPresentation.getMaxY();
        if (sequenceMessageEndPresentation.getMaxY() + 10.0 < d2) {
            sequenceMessageEndPresentation.setHeight(d2 + 10.0 - sequenceMessageEndPresentation.getMinY());
        }
        this.messagePs.setTargetEnd(1.0, 0.0);
        Lifeline lifeline = lifelinePresentation.getClassifierRole();
        BehaviorExecutionSpecification behaviorExecutionSpecification = ExecutionSpecifications.createBehaviorExecutionSpecification(lifeline);
        MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.resetExecutionSpecificationStart(behaviorExecutionSpecification, message.getMessageSort());
        Messages.setReceiveEvent(message, messageOccurrenceSpecification);
        ElementPresentations.addPresentation(behaviorExecutionSpecification, executionSpecificationPresentation, this.dgm);
        this.messagePs.setTargetPresentation(executionSpecificationPresentation);
        return executionSpecificationPresentation;
    }

    protected boolean isSelfMessage(SequenceMessageEndPresentation sequenceMessageEndPresentation, Presentation presentation) {
        boolean bl = false;
        LabelPresentation labelPresentation = null;
        if (sequenceMessageEndPresentation != null) {
            labelPresentation = sequenceMessageEndPresentation.getFather();
        }
        if (presentation != null) {
            if (presentation instanceof SequenceMessageEndPresentation) {
                if (((SequenceMessageEndPresentation)presentation).getFather().equals(labelPresentation)) {
                    bl = true;
                }
            } else if (presentation.equals(labelPresentation)) {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean isNeedNestActivation(SequenceMessageEndPresentation sequenceMessageEndPresentation, Presentation presentation) {
        boolean bl = false;
        List<LabelPresentation> list = new ArrayList<LabelPresentation>();
        if ((list = sequenceMessageEndPresentation.getChainCRpsOfRelatedActivator(list)).contains(this.getClassifierRolePresentation(presentation))) {
            bl = true;
        }
        return bl;
    }

    protected void adjustCreateLocation() {
        if (this.sourcePs == null && !(this.targetPs instanceof FramePresentation) || this.sourcePs instanceof LifelinePresentation) {
            Cloneable cloneable;
            double d2;
            LifelinePresentation lifelinePresentation = (LifelinePresentation)this.sourcePs;
            double d3 = d2 = lifelinePresentation == null ? 0.0 : lifelinePresentation.getLifelineLocation().y;
            if (this.targetPs instanceof LifelinePresentation) {
                cloneable = (LifelinePresentation)this.targetPs;
                d2 = Math.max(cloneable.getLifelineLocation().y, d2);
            } else if (this.targetPs instanceof SequenceMessageEndPresentation && ((SequenceMessageEndPresentation)this.targetPs).getFather() instanceof LifelinePresentation) {
                cloneable = (SequenceMessageEndPresentation)this.targetPs;
                d2 = Math.max(((LifelinePresentation)cloneable.getFather()).getLifelineLocY(), d2);
            }
            cloneable = (Pnt2d)this.points.get(0);
            if (d2 > ((Pnt2d)cloneable).y) {
                ((Pnt2d)this.points.get(0)).set(((Pnt2d)cloneable).x, d2);
            }
        }
    }

    protected boolean hasBelowActivation() {
        RectPresentation rectPresentation;
        boolean bl = false;
        double d2 = ((Pnt2d)this.points.get((int)0)).y;
        LifelinePresentation lifelinePresentation = null;
        LifelinePresentation lifelinePresentation2 = null;
        lifelinePresentation = this.getClassifierRolePresentation(this.sourcePs);
        lifelinePresentation2 = this.getClassifierRolePresentation(this.targetPs);
        if (lifelinePresentation != null && lifelinePresentation.hasTermination()) {
            rectPresentation = lifelinePresentation.getTermination();
            SequenceMessageEndPresentation sequenceMessageEndPresentation = rectPresentation.getRelatedAp();
            if (sequenceMessageEndPresentation != null && sequenceMessageEndPresentation.getMaxY() < d2) {
                bl = true;
                return bl;
            }
            if (rectPresentation.getMinY() <= d2) {
                bl = true;
                return bl;
            }
            if (sequenceMessageEndPresentation != null && this.isSelfMessage(sequenceMessageEndPresentation, this.targetPs)) {
                return bl;
            }
        }
        if (lifelinePresentation2 != null && lifelinePresentation2.hasTermination() && (rectPresentation = lifelinePresentation2.getTermination().getRelatedAp()) != null && rectPresentation.getMinY() < d2) {
            bl = true;
            return bl;
        }
        return bl;
    }

    protected LifelinePresentation getClassifierRolePresentation(Presentation presentation) {
        LifelinePresentation lifelinePresentation = null;
        if (presentation instanceof LifelinePresentation) {
            lifelinePresentation = (LifelinePresentation)presentation;
        } else if (presentation instanceof SequenceMessageEndPresentation) {
            lifelinePresentation = (LifelinePresentation)((SequenceMessageEndPresentation)presentation).getFather();
        }
        return lifelinePresentation;
    }

    public void moveOverlapActivation(UMLDiagram uMLDiagram, SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        this.moveOverlapActivationOnCreateDestroy(sequenceMessageEndPresentation);
        this.moveAllClassifier(uMLDiagram);
    }

    public void moveOverlapActivationOnCreateDestroy(SequenceMessageEndPresentation sequenceMessageEndPresentation) {
        double d2 = sequenceMessageEndPresentation.getLocation().y;
        SequenceMessageEndPresentation sequenceMessageEndPresentation2 = ((LifelinePresentation)sequenceMessageEndPresentation.getFather()).getDestroyActivation();
        if (sequenceMessageEndPresentation2 != null) {
            double d3 = sequenceMessageEndPresentation2.getLocation().y;
            double d4 = d2 + sequenceMessageEndPresentation.getHeight();
            if (d4 > d3) {
                Vec2d vec2d = new Vec2d(0.0, d4 - d3);
                this.moveActivationPs(sequenceMessageEndPresentation2, vec2d);
            }
        }
    }

    public void moveActivationPs(SequenceMessageEndPresentation sequenceMessageEndPresentation, Vec2d vec2d) {
        if (sequenceMessageEndPresentation.getActivatorMp() != null) {
            SequenceMessageEndPresentation sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)sequenceMessageEndPresentation.getActivatorMp().getSourcePresentation();
            if (sequenceMessageEndPresentation2 != null && !sequenceMessageEndPresentation2.isNormalActivationPresentation()) {
                sequenceMessageEndPresentation2.move(vec2d);
            } else {
                sequenceMessageEndPresentation.moveAll(vec2d, sequenceMessageEndPresentation.getChainSourceAps());
            }
        } else {
            sequenceMessageEndPresentation.moveAll(vec2d, sequenceMessageEndPresentation.getChainSourceAps());
        }
    }

    protected void moveAllClassifier(UMLDiagram uMLDiagram) {
        if (!(uMLDiagram instanceof UMLSequenceDiagram)) {
            return;
        }
        UMLSequenceDiagram uMLSequenceDiagram = (UMLSequenceDiagram)uMLDiagram;
        List<Presentation> list = uMLSequenceDiagram.getPresentations();
        for (Presentation presentation : list) {
            if (!(presentation instanceof LifelinePresentation)) continue;
            LifelinePresentation lifelinePresentation = (LifelinePresentation)presentation;
            lifelinePresentation.moveNormalMsgBlowCreateAboveDestroy();
        }
    }

    private InteractionOperand a() {
        int n2;
        if (this.combinedFragmentPs != null && (n2 = this.b()) >= 0) {
            CombinedFragment combinedFragment = (CombinedFragment)this.combinedFragmentPs.getModel();
            return (InteractionOperand)combinedFragment.getOperands().get(n2);
        }
        return null;
    }

    private int b() {
        boolean bl;
        Pnt2d pnt2d = this.combinedFragmentPs.getLocation();
        double d2 = this.combinedFragmentPs.getWidth();
        double d3 = this.combinedFragmentPs.getHeight();
        Pnt2d[] pnt2dArray = this.messagePs.getPointsForJudge();
        boolean bl2 = bl = pnt2dArray[0].getX() >= pnt2d.getX() && pnt2dArray[0].getX() <= pnt2d.getX() + d2 && pnt2dArray[0].getY() >= pnt2d.y && pnt2dArray[0].getY() <= pnt2d.y + d3 && pnt2dArray[1].getX() >= pnt2d.getX() && pnt2dArray[1].getX() <= pnt2d.getX() + d2;
        if (bl) {
            int n2 = this.combinedFragmentPs.getOperandOffsets().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4 = this.combinedFragmentPs.getOperandOffset(i2 + 1);
                double d5 = this.combinedFragmentPs.getOperandOffset(i2 + 2);
                if (!(pnt2dArray[0].getY() > pnt2d.y + d4) || d5 != 0.0 && !(pnt2dArray[0].getY() < pnt2d.y + d5)) continue;
                return i2 + 1;
            }
            return 0;
        }
        return -1;
    }

    public void setCombinedFragment(CombinedFragmentPresentation combinedFragmentPresentation) {
        this.combinedFragmentPs = combinedFragmentPresentation;
    }

    protected void createReturnMsgAutomatic() {
        if (JomtGlobal.modeManager == null || !JomtGlobal.modeManager.getReturnMsgAutomaticButtonMode()) {
            return;
        }
        CreateReturnMessageCommand createReturnMessageCommand = new CreateReturnMessageCommand();
        createReturnMessageCommand.setSenderPresentation(this.messagePs.getTargetPresentation());
        createReturnMessageCommand.setReceiverPresentation(this.messagePs.getSourcePresentation());
        createReturnMessageCommand.setPresentation(JmodelFactory.eINSTANCE.createSequenceMessagePresentation());
        createReturnMessageCommand.setDiagram(this.dgm);
        createReturnMessageCommand.setUseTransaction(false);
        createReturnMessageCommand.setShiftPressedState(this.isShiftPressed);
        this.callCommand(createReturnMessageCommand);
    }
}

