/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.CommunicationMessagePresentation;
import net.astah.jmodel.ConnectorPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.ObjectPresentation;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.CommunicationDiagramOperations;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Messages;
import net.astah.uml2.uml.OccurrenceSpecifications;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class CreateMessageCLCommand
extends Command {
    protected CommunicationMessagePresentation messagePs = null;
    protected ConnectorPresentation linkPs = null;
    protected UMLDiagram dgm;
    protected boolean isShiftPressed = false;
    protected boolean direction = true;

    public void setPresentation(CommunicationMessagePresentation communicationMessagePresentation) {
        this.messagePs = communicationMessagePresentation;
    }

    public void setLinkPresentation(ConnectorPresentation connectorPresentation) {
        this.linkPs = connectorPresentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setDirection(boolean bl) {
        this.direction = bl;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (this.messagePs == null || iJomtEntityStore == null || !(this.dgm instanceof UMLCommunicationDiagram)) {
                return;
            }
            UMLCommunicationDiagram uMLCommunicationDiagram = (UMLCommunicationDiagram)this.dgm;
            try {
                iJomtEntityStore.beginTransaction();
                String string = PropertyManager.getProjectViewResourceBundle().getString("uml.message.label") + ModelGlobal.prjManager.getCurrentProject().messageNum++;
                Interaction interaction = uMLCommunicationDiagram.getInteraction();
                Message message = interaction.createMessage(string);
                Messages.setActivator(message, null);
                message.setConnector((Connector)this.linkPs.getModel());
                ObjectPresentation objectPresentation = (ObjectPresentation)this.linkPs.getSourcePresentation();
                ObjectPresentation objectPresentation2 = (ObjectPresentation)this.linkPs.getTargetPresentation();
                Lifeline lifeline = this.direction ? objectPresentation.getClassifierRole() : objectPresentation2.getClassifierRole();
                Lifeline lifeline2 = this.direction ? objectPresentation2.getClassifierRole() : objectPresentation.getClassifierRole();
                MessageOccurrenceSpecification messageOccurrenceSpecification = OccurrenceSpecifications.createMessageOccurrenceSpecification(lifeline);
                MessageOccurrenceSpecification messageOccurrenceSpecification2 = OccurrenceSpecifications.createMessageOccurrenceSpecification(lifeline2);
                Messages.setSendEvent(message, messageOccurrenceSpecification);
                Messages.setReceiveEvent(message, messageOccurrenceSpecification2);
                iJomtEntityStore.addEntity(this.messagePs);
                this.messagePs.setDirection(this.direction);
                this.messagePs.setConnectorPresentation(this.linkPs);
                ElementPresentations.addPresentation(message, this.messagePs, uMLCommunicationDiagram);
                CommunicationDiagramOperations.setAllMessageIndex(uMLCommunicationDiagram);
                this.messagePs.setParameterVisibility(uMLCommunicationDiagram.isMessageParamVisible());
                this.messagePs.setParameterTypeVisibility(uMLCommunicationDiagram.isMessageParamTypeVisible());
                this.messagePs.setParameterDirectionKindVisibility(uMLCommunicationDiagram.isMessageParamDirectionKindVisible());
                this.messagePs.setReturnValueVisibility(uMLCommunicationDiagram.isMessageReturnValueVisible());
                this.messagePs.setReturnValueVariableVisibility(uMLCommunicationDiagram.isMessageReturnValueVariableVisible());
                iJomtEntityStore.commitTransaction();
                JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

