/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.widget.CColor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.MoveMMtopicCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.AutoScroller;
import net.astah.jomt.jview.CJomtTree;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMNotationFactory;
import net.astah.notation.mindmap.MMOrientationKind;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.edit.layout.MMTopicSymmetryRelocater;
import net.astah.notation.mindmap.editor.MMDiagramViewElement;
import org.eclipse.emf.common.util.EList;

public class CreateMMParentTopicCommand
extends Command {
    private DiagramEditor a;
    private MMTopicShape b = null;

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            this.a = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Diagram diagram = this.a.getDiagram();
            if (!(diagram instanceof MMDiagram)) {
                return;
            }
            MMDiagram mMDiagram = (MMDiagram)diagram;
            DiagramElement[] diagramElementArray = this.a.getSelectedPresentations();
            MMTopicShape[] mMTopicShapeArray = this.a(diagramElementArray);
            if (mMTopicShapeArray == null) {
                return;
            }
            this.a.unselect();
            try {
                CColor cColor;
                iJomtEntityStore.beginTransaction();
                int n2 = this.b.getChildren().indexOf(mMTopicShapeArray[0]);
                MMTopicShape mMTopicShape = MMNotationFactory.eINSTANCE.createMMTopicShape();
                String string = PropertyManager.getProjectViewResourceBundle().getString("uml.mmtopic_presentation.label") + project.mmTopicNum++;
                mMDiagram.getMMOwnedElements().add(mMTopicShape);
                mMTopicShape.setText(string);
                mMDiagram.getFloatingTopics().add(mMTopicShape);
                MoveMMtopicCommand moveMMtopicCommand = new MoveMMtopicCommand();
                moveMMtopicCommand.setMovedIndex(n2);
                moveMMtopicCommand.setOnLeft(this.a(mMTopicShapeArray[0]));
                moveMMtopicCommand.setNewContainer(this.b);
                moveMMtopicCommand.moveTo(mMDiagram, mMTopicShape, this.b);
                if (mMTopicShapeArray[0].isManualLayout()) {
                    mMTopicShape.setManualLayout(true);
                    double d2 = this.a(mMTopicShapeArray[0]) ? mMTopicShapeArray[0].getMaxX() : mMTopicShapeArray[0].getMinX();
                    double d3 = this.a(mMTopicShape) ? mMTopicShape.getMaxX() : mMTopicShape.getMinX();
                    Vec2d vec2d = new Vec2d(d2 - d3, 0.0);
                    new MMTopicSymmetryRelocater(mMDiagram).move(mMTopicShape, vec2d);
                }
                if ((cColor = MMStyleSupport.getLineColor(mMTopicShapeArray[0].getBranch())) != null) {
                    MMStyleSupport.setLineColor(mMTopicShape.getBranch(), cColor);
                }
                for (int i2 = 0; i2 < mMTopicShapeArray.length; ++i2) {
                    moveMMtopicCommand.setMovedIndex(-1);
                    moveMMtopicCommand.setOnLeft(this.a(mMTopicShapeArray[i2]));
                    moveMMtopicCommand.moveTo(mMDiagram, mMTopicShapeArray[i2], mMTopicShape, true);
                }
                CJomtTree cJomtTree = JomtGlobal.viewManager.getProjectView().getStructureTree();
                int n3 = cJomtTree.getExpandMode();
                cJomtTree.setExpandMode(2);
                iJomtEntityStore.commitTransaction();
                cJomtTree.setExpandMode(n3);
                this.a(this.a);
                SwingInvoker.runLaterInEDT(() -> this.selectTopic(mMTopicShape));
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void selectTopic(MMTopicShape mMTopicShape) {
        this.a.select(mMTopicShape);
        this.a.setSelected(true);
        DiagramViewElement diagramViewElement = this.a.getDiagramScene().getDiagramViewElement();
        if (diagramViewElement != null && diagramViewElement instanceof MMDiagramViewElement) {
            ((MMDiagramViewElement)diagramViewElement).startEditing(mMTopicShape);
        }
        this.a.repaintCanvas();
        this.a.setNeedInitializeSearchToolBar(true);
    }

    private MMTopicShape[] a(DiagramElement[] diagramElementArray) {
        MMTopicShape[] mMTopicShapeArray = null;
        Iterable<MMTopicShape> iterable = Iterables.filter(Arrays.asList(diagramElementArray), MMTopicShape.class);
        if (!Iterables.isEmpty(iterable) && this.b(iterable)) {
            mMTopicShapeArray = this.a(iterable);
        }
        return mMTopicShapeArray;
    }

    private MMTopicShape[] a(Iterable<MMTopicShape> iterable) {
        MMTopicShape[] mMTopicShapeArray = Iterables.toArray(iterable, MMTopicShape.class);
        EList<MMTopicShape> eList = this.b.getChildren();
        for (int i2 = 0; i2 < mMTopicShapeArray.length - 1; ++i2) {
            for (int i3 = i2 + 1; i3 < mMTopicShapeArray.length; ++i3) {
                if (eList.indexOf(mMTopicShapeArray[i2]) <= eList.indexOf(mMTopicShapeArray[i3])) continue;
                MMTopicShape mMTopicShape = mMTopicShapeArray[i2];
                mMTopicShapeArray[i2] = mMTopicShapeArray[i3];
                mMTopicShapeArray[i3] = mMTopicShape;
            }
        }
        return mMTopicShapeArray;
    }

    private boolean b(Iterable<MMTopicShape> iterable) {
        for (MMTopicShape mMTopicShape : iterable) {
            if (mMTopicShape.isTop()) {
                return false;
            }
            if (this.b == null) {
                this.b = mMTopicShape.getParent();
                continue;
            }
            if (mMTopicShape.getParent() == this.b) continue;
            return false;
        }
        return true;
    }

    private void a(DiagramEditor diagramEditor) {
        if (diagramEditor == null) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        DiagramElement[] diagramElementArray = diagramEditor.getSelectedPresentations();
        for (DiagramElement diagramElement : diagramElementArray) {
            if (!(diagramElement instanceof MMTopicShape)) continue;
            MMTopicShape mMTopicShape = (MMTopicShape)diagramElement;
            d2 = mMTopicShape.getCenterX();
            d3 = mMTopicShape.getCenterY();
        }
        GCamera gCamera = diagramEditor.getCamera();
        d2 = gCamera.toDeviceCoordX(d2);
        d3 = gCamera.toDeviceCoordY(d3);
        AutoScroller autoScroller = new AutoScroller(diagramEditor);
        autoScroller.autoPanToShow(diagramElementArray, d2, d3);
    }

    private boolean a(MMTopicShape mMTopicShape) {
        return mMTopicShape.getOrientation() == MMOrientationKind.LEFT;
    }
}

