/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.Diagram;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.uml.exception.UMLSemanticsException;

public class CreateMMLinkCommand
extends Command {
    protected MMLinkEdge relationPs = null;
    protected MMTopicShape startPs;
    protected MMTopicShape endPs;
    protected Diagram dgm;
    protected boolean needTran = true;
    protected boolean isShiftPressed = false;

    public void setDiagram(Diagram diagram) {
        this.dgm = diagram;
    }

    public void setPresentation(MMLinkEdge mMLinkEdge) {
        this.relationPs = mMLinkEdge;
    }

    public void setStartPresentation(MMTopicShape mMTopicShape) {
        this.startPs = mMTopicShape;
    }

    public void setEndPresentation(MMTopicShape mMTopicShape) {
        this.endPs = mMTopicShape;
    }

    public void setTransaction(boolean bl) {
        this.needTran = bl;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    @Override
    public void execute() {
        if (this.startPs == this.endPs) {
            MessageManager.displayAlertMessageDialog("app", "self_mindmap_link_detected.message");
            return;
        }
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            try {
                if (this.needTran) {
                    iJomtEntityStore.beginTransaction();
                }
                this.a(iJomtEntityStore);
                if (this.needTran) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.needTran) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.needTran) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.needTran) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
            finally {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(IEntityStore iEntityStore) {
        if (this.relationPs != null && iEntityStore != null && this.startPs != null && this.endPs != null) {
            this.dgm.getOwnedElements().add(this.relationPs);
            this.relationPs.getWaypoints().clear();
            this.relationPs.setSourceTopic(this.startPs);
            this.relationPs.setTargetTopic(this.endPs);
        }
    }
}

