/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.Lifelines;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Namespace;

public class CreateLifelineCommand
extends Command {
    protected Presentation p;
    protected UMLDiagram dgm;
    protected boolean isShiftPressed = false;
    private boolean a = true;
    private boolean b = true;
    protected String lifelineName = null;
    protected Lifeline lifeline;
    private List<LabelPresentation> c = new ArrayList<LabelPresentation>(0);

    public void setPresentation(Presentation presentation) {
        this.p = presentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setIsTransaction(boolean bl) {
        this.a = bl;
    }

    public void setCommitTransaction(boolean bl) {
        this.b = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (this.p == null || iJomtEntityStore == null || this.dgm == null) {
            return;
        }
        int n2 = 100;
        while (n2-- > 0) {
            try {
                if (this.a) {
                    iJomtEntityStore.beginTransaction();
                }
                Interaction interaction = this.a();
                Lifeline lifeline = this.getLifeline();
                if (lifeline == null) {
                    lifeline = this.createNewLifeline(interaction);
                }
                ElementPresentations.addPresentation(lifeline, this.p, this.dgm);
                ((RectPresentation)this.p).setBodyColorWithDefault();
                this.modifyDepth();
                this.setSize((LabelPresentation)this.p);
                Elements.compareStereotypeAndsetTagValue(lifeline);
                if (!this.a || !this.b) break;
                iJomtEntityStore.commitTransaction();
                break;
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                iJomtEntityStore.abortTransaction();
                if (this.a) continue;
                iJomtEntityStore.beginTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
                break;
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(exception);
                break;
            }
        }
        this.postOperation();
    }

    private Interaction a() {
        if (this.dgm instanceof UMLInteractionDiagram) {
            UMLInteractionDiagram uMLInteractionDiagram = (UMLInteractionDiagram)this.dgm;
            return uMLInteractionDiagram.getInteraction();
        }
        return null;
    }

    protected void postOperation() {
        if (JomtGlobal.modeManager != null) {
            JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
        }
    }

    protected Lifeline createNewLifeline(Interaction interaction) {
        if (this.lifelineName == null) {
            this.lifelineName = PropertyManager.getProjectViewResourceBundle().getString("uml.classifier_role.label") + ModelGlobal.prjManager.getCurrentProject().classifierRoleNum++;
        }
        Lifeline lifeline = Lifelines.createLifeline(interaction, null, this.lifelineName);
        return lifeline;
    }

    public void setLifelineName(String string) {
        this.lifelineName = string;
    }

    protected void setSize(LabelPresentation labelPresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = this.createDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.resize();
        }
    }

    protected JomtDefaultSizeUtilities createDefaultSizeUtilities(LabelPresentation labelPresentation) {
        return ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
    }

    public Lifeline getLifeline() {
        return this.lifeline;
    }

    public void setLifeline(Lifeline lifeline) {
        this.lifeline = lifeline;
    }

    protected Classifier createNewBaseClass(IEntityStore iEntityStore, Namespace namespace) {
        return null;
    }

    public void setCoveredBys(List<LabelPresentation> list) {
        this.c = list;
    }

    protected void modifyDepth() {
        Lifeline lifeline = (Lifeline)this.p.getModel();
        EList<InteractionFragment> eList = lifeline.getCoveredBys();
        ArrayList<InteractionUsePresentation> arrayList = new ArrayList<InteractionUsePresentation>();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            Object e2 = eList.get(i2);
            if (!(e2 instanceof InteractionUse)) continue;
            InteractionUse interactionUse = (InteractionUse)e2;
            InteractionUsePresentation interactionUsePresentation = (InteractionUsePresentation)Presentations.getPresentations(interactionUse).get(0);
            arrayList.add(interactionUsePresentation);
        }
        ((RectPresentation)this.p).setDepth(this.a(arrayList) + 1);
    }

    private int a(List<InteractionUsePresentation> list) {
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            InteractionUsePresentation interactionUsePresentation = list.get(i2);
            int n3 = interactionUsePresentation.getDepth();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }
}

