/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jomt.jcontrol.CreateInteractionFragmentCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateInteractionUseCommand
extends CreateInteractionFragmentCommand {
    private InteractionUsePresentation a;

    public void setPresentation(InteractionUsePresentation interactionUsePresentation) {
        super.setPresentation(interactionUsePresentation);
        this.a = interactionUsePresentation;
    }

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (this.a == null || iJomtEntityStore == null || this.dgm == null) {
                return;
            }
            if (this.isBelowTermination()) {
                MessageManager.displayAlertMessageDialog("uml", "interactionuse_cannot_below_termination.message");
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                UMLInteractionDiagram uMLInteractionDiagram = (UMLInteractionDiagram)this.dgm;
                Interaction interaction = uMLInteractionDiagram.getInteraction();
                InteractionUse interactionUse = this.a(interaction);
                ElementPresentations.addPresentation(interactionUse, this.a, this.dgm);
                this.a(interactionUse);
                this.setRelationWithParent();
                this.a.setBodyColorWithDefault();
                Elements.compareStereotypeAndsetTagValue(interactionUse);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(InteractionUse interactionUse) {
        for (Presentation presentation : this.coveredLifelines) {
            if (!(presentation instanceof LifelinePresentation)) continue;
            LifelinePresentation lifelinePresentation = (LifelinePresentation)presentation;
            Lifeline lifeline = lifelinePresentation.getClassifierRole();
            interactionUse.getCovereds().add(lifeline);
        }
    }

    private InteractionUse a(Interaction interaction) {
        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.interaction_use.label");
        InteractionUse interactionUse = (InteractionUse)interaction.createFragment(string, UMLFactory.eINSTANCE.createInteractionUse().eClass());
        return interactionUse;
    }
}

