/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ComponentInstancePresentation;
import net.astah.jmodel.ComponentPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InstancePresentation;
import net.astah.jmodel.InstanceSpecificationPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.NodeInstancePresentation;
import net.astah.jmodel.NodePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLObjectDiagram;
import net.astah.jmodel.impl.LabelPresentationImpl;
import net.astah.jomt.jcontrol.InstanceFactory;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.UseCase;

public abstract class CreateInstanceCommand
extends Command {
    protected Presentation p;
    protected UMLDiagram dgm;
    protected boolean isShiftPressed = false;
    protected JomtPresentation parent;
    protected InstanceSpecification newInstance;
    protected String modelName = null;

    public void setModelName(String string) {
        this.modelName = string;
    }

    public void setPresentation(Presentation presentation) {
        this.p = presentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setParent(JomtPresentation jomtPresentation) {
        this.parent = jomtPresentation;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public InstanceSpecification getModel() {
        return this.newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (!this.isConditionsPrepared(iJomtEntityStore)) {
            return;
        }
        while (true) {
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                Namespace namespace = this.a(iJomtEntityStore);
                this.newInstance = this.createNewInstance(iJomtEntityStore, namespace);
                if (this.p != null) {
                    iJomtEntityStore.addEntity(this.p);
                    ElementPresentations.addPresentation(this.newInstance, this.p, this.dgm);
                    if (this.p instanceof InstanceSpecificationPresentation) {
                        if (this.dgm instanceof UMLObjectDiagram) {
                            InstanceFactory.setObjectDiagramInstanceVisibilities((InstanceSpecificationPresentation)this.p);
                        } else {
                            InstanceFactory.setClassDiagramInstanceVisibilities((InstanceSpecificationPresentation)this.p);
                        }
                    }
                    ((RectPresentation)this.p).setBodyColorWithDefault();
                    this.setSize((LabelPresentation)this.p);
                    if (this.parent != null && this.p instanceof InstancePresentation) {
                        InstancePresentation instancePresentation = (InstancePresentation)this.p;
                        if (this.parent instanceof ComponentPresentation) {
                            ComponentPresentation componentPresentation = (ComponentPresentation)this.parent;
                            instancePresentation.setContainer(componentPresentation);
                        } else if (this.parent instanceof NodePresentation) {
                            NodePresentation nodePresentation = (NodePresentation)this.parent;
                            instancePresentation.setContainer(nodePresentation);
                        } else if (this.parent instanceof ComponentInstancePresentation) {
                            ComponentInstancePresentation componentInstancePresentation = (ComponentInstancePresentation)this.parent;
                            instancePresentation.setContainer(componentInstancePresentation);
                        } else if (this.parent instanceof NodeInstancePresentation) {
                            NodeInstancePresentation nodeInstancePresentation = (NodeInstancePresentation)this.parent;
                            instancePresentation.setContainer(nodeInstancePresentation);
                            if (instancePresentation instanceof ComponentInstancePresentation) {
                                // empty if block
                            }
                        }
                    }
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                if (!this.useTransaction) continue;
                iJomtEntityStore.abortTransaction();
                continue;
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                MessageManager.requireBugReport(exception);
            }
            break;
        }
        this.postOperation();
    }

    private Namespace a(IEntityStore iEntityStore) {
        Namespace namespace = this.getNamespace();
        if (namespace instanceof UseCase || namespace instanceof Node || namespace instanceof Component) {
            // empty if block
        }
        return namespace;
    }

    protected boolean isConditionsPrepared(IEntityStore iEntityStore) {
        return this.p != null && iEntityStore != null && this.dgm != null;
    }

    protected Namespace getNamespace() {
        return (Namespace)this.dgm.getParent();
    }

    protected void postOperation() {
        if (JomtGlobal.modeManager != null) {
            JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
        }
    }

    protected abstract InstanceSpecification createNewInstance(IEntityStore var1, Namespace var2);

    protected void setSize(LabelPresentation labelPresentation) {
        if (JomtGlobal.viewManager == null) {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.setWidth(Math.max(((LabelPresentationImpl)labelPresentation).getDefaultLabelWidth(), labelPresentation.getMinWidth()) + 20.0);
            labelPresentation.resize();
            return;
        }
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.setWidth(Math.max(((LabelPresentationImpl)labelPresentation).getDefaultLabelWidth(), labelPresentation.getMinWidth()) + 20.0);
            labelPresentation.resize();
        }
    }
}

