/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Image;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.Shape;
import net.astah.emf.common.resource.ResourceStorage;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadEntityException;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.SwingResourceStorages;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.ImagePresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.l;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.MacFilenameFilter;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DiagramEditors;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.DiagramOperations;
import net.astah.notation.GraphicalShape;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateImageCommand
extends net.astah.golf.control.Command {
    private static final Logger a = LoggerFactory.getLogger(CreateImageCommand.class);
    private Shape b;
    private Diagram c;
    private boolean d = false;
    private File e = null;
    private boolean f = true;
    private URI g = null;
    private CImageIcon h;
    private boolean i = false;
    private boolean j = false;
    private static final double k = 100.0;
    private static final double l = 100.0;

    public void setPresentation(Shape shape) {
        this.b = shape;
    }

    public void setDiagram(Diagram diagram) {
        this.c = diagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.d = bl;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        if (iJomtEntityStore == null) {
            return;
        }
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        try {
            block24: {
                this.setPresentation(this.getShape(diagramEditor));
                if (this.b == null) {
                    return;
                }
                this.setDiagram(this.getDiagram(diagramEditor));
                if (this.c == null) {
                    return;
                }
                if (this.h == null) {
                    if (this.e == null) {
                        this.e = this.getImageFileFromFileChooser();
                        if (this.e == null) {
                            return;
                        }
                    }
                    if (!this.e.canRead()) {
                        MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                        return;
                    }
                    try {
                        this.setImageIcon(this.getImage(this.e));
                    }
                    catch (IOException iOException) {
                        a.warn("Failed to load image: {}", (Object)iOException.getMessage());
                        MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                        return;
                    }
                }
                if (this.h == null) {
                    MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                    return;
                }
                this.pretreatment();
                if (this.b instanceof ImagePresentation) {
                    try {
                        if (this.f) {
                            iJomtEntityStore.beginTransaction();
                        }
                        ImagePresentation imagePresentation = (ImagePresentation)this.b;
                        this.setImage(imagePresentation, this.g, iJomtEntityStore, this.c);
                        if (this.f) {
                            iJomtEntityStore.commitTransaction();
                        }
                        break block24;
                    }
                    catch (BadEntityException badEntityException) {
                        MessageManager.requireBugReport(badEntityException);
                        if (this.f) {
                            iJomtEntityStore.abortTransaction();
                        }
                        break block24;
                    }
                    catch (BadTransactionException badTransactionException) {
                        MessageManager.requireBugReport(badTransactionException);
                        if (this.f) {
                            iJomtEntityStore.abortTransaction();
                        }
                        this.i = true;
                    }
                    catch (Exception exception) {
                        MessageManager.requireBugReport(exception);
                        if (this.f) {
                            iJomtEntityStore.abortTransaction();
                        }
                        this.j = true;
                    }
                    catch (Error error) {
                        MessageManager.requireBugReport(error);
                        if (this.f) {
                            iJomtEntityStore.abortTransaction();
                        }
                        break block24;
                    }
                }
                GraphicalShape graphicalShape = (GraphicalShape)this.b;
                this.setImage(graphicalShape, this.c);
            }
            this.postProcessing();
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
            this.j = true;
        }
    }

    protected void pretreatment() {
    }

    protected void postProcessing() {
        JomtGlobal.modeManager.changeButtonsState(this.d);
    }

    protected void setImage(ImagePresentation imagePresentation, URI uRI, IEntityStore iEntityStore, Diagram diagram) throws IllegalModelTypeException {
        this.setImage(imagePresentation, uRI);
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(imagePresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            imagePresentation.setDoAutoResize(false);
            imagePresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            imagePresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        }
        iEntityStore.addEntity(imagePresentation);
        DiagramOperations.addPresentation(diagram, imagePresentation, null);
    }

    protected void setImage(ImagePresentation imagePresentation, URI uRI) {
        double d2;
        double d3;
        imagePresentation.setSource(uRI.toString());
        double d4 = this.h.getWidth(null);
        double d5 = this.h.getHeight(null);
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("default_size.max_image.default_use");
        if (bl) {
            d3 = this.a(d4, "default_size.max_image.default_width", 100.0);
            d2 = this.a(d5, "default_size.max_image.default_height", 100.0);
        } else {
            d3 = 1.0;
            d2 = 1.0;
        }
        double d6 = this.a(d4, d3, d2);
        double d7 = this.a(d5, d3, d2);
        imagePresentation.setWidth(d6);
        imagePresentation.setHeight(d7);
    }

    protected void setImage(GraphicalShape graphicalShape, Diagram diagram) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(diagram);
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.append(this.a((Image)graphicalShape.getFigure()));
        compoundCommand.appendIfCanExecute(AddCommand.create((EditingDomain)transactionalEditingDomain, (Object)diagram, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, graphicalShape, 0));
        compoundCommand.append(new l(this, graphicalShape));
        CommandJob commandJob = new CommandJob(transactionalEditingDomain, compoundCommand);
        Jobs.toCompletableFuture(commandJob, true).thenRun(() -> DiagramEditors.selectOnCurrentEditor(graphicalShape));
        commandJob.schedule();
    }

    protected Diagram getDiagram(DiagramEditor diagramEditor) {
        Diagram diagram = this.c;
        if (diagram == null) {
            diagram = diagramEditor.getDiagram();
        }
        return diagram;
    }

    protected Shape getShape(DiagramEditor diagramEditor) {
        Shape shape = this.b;
        if (shape == null) {
            ImagePresentation imagePresentation = JmodelFactory.eINSTANCE.createImagePresentation();
            imagePresentation.setDoAutoResize(false);
            imagePresentation.setLocation(new Pnt2d(this.getPoint().x, this.getPoint().y));
            int n2 = PresentationUtil.getMinDepth(diagramEditor.getDiagram());
            imagePresentation.setDepth(n2 - 1);
            shape = imagePresentation;
        }
        return shape;
    }

    protected File getImageFileFromFileChooser() {
        if (PropertyManager.isMacOS()) {
            Frame frame = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setMode(0);
            MacFilenameFilter macFilenameFilter = new MacFilenameFilter();
            macFilenameFilter.setJPG(true);
            macFilenameFilter.setGIF(true);
            macFilenameFilter.setPNG(true);
            fileDialog.setFilenameFilter(macFilenameFilter);
            fileDialog.setDirectory(JomtGlobal.getFileDir());
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            JomtGlobal.setFileDir(file.getParent());
            return file;
        }
        CFileChooser cFileChooser = this.createImageFileChooser();
        if (!cFileChooser.isApproveOpenDialog()) {
            return null;
        }
        File file = cFileChooser.getSelectedFile();
        JomtGlobal.setFileDir(file.getParent());
        return file;
    }

    protected CFileChooser createImageFileChooser() {
        String string = JomtGlobal.getFileDir();
        CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Open Dialog");
        cFileChooser.addChoosableFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Compressed Image Files");
        cFileChooser.addChoosableFileFilter("gif", "GIF Image Files");
        cFileChooser.addChoosableFileFilter("png", "PNG Image Files");
        cFileChooser.setFileFilter(new String[]{"jpg", "jpeg", "gif", "png"}, "Supported Image Files");
        return cFileChooser;
    }

    protected CImageIcon getImage(File file) throws IOException {
        String string = file.getName().toLowerCase();
        if (string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".gif") || string.endsWith(".png")) {
            ResourceStorage resourceStorage = ResourceStorage.getResourceStorage(this.c);
            this.g = resourceStorage.store(file);
            return SwingResourceStorages.getImage(resourceStorage, this.g);
        }
        return null;
    }

    private double a(double d2, String string, double d3) {
        double d4 = RuntimeGlobal.sysProp.getIntWithDefault(string);
        if (d4 == -1.0) {
            d4 = d3;
        }
        return d4 / d2;
    }

    private double a(double d2, double d3, double d4) {
        if (d3 >= 1.0 && d4 >= 1.0) {
            return d2;
        }
        return d2 * Math.min(d3, d4);
    }

    private Command a(Image image) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(this.c);
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.append(SetCommand.create(transactionalEditingDomain, image, DGPackage.Literals.IMAGE__SOURCE, this.g.toString()));
        Bounds bounds = image.getBounds();
        if (bounds != null) {
            double d2 = bounds.getX();
            double d3 = bounds.getY();
            double d4 = this.h.getWidth(null);
            double d5 = this.h.getHeight(null);
            if (RuntimeGlobal.sysProp.getBooleanWithDefault("default_size.max_image.default_use")) {
                double d6 = this.a(d4, "default_size.max_image.default_width", 100.0);
                double d7 = this.a(d5, "default_size.max_image.default_height", 100.0);
                d4 = this.a(d4, d6, d7);
                d5 = this.a(d5, d6, d7);
            }
            compoundCommand.append(SetCommand.create(transactionalEditingDomain, image, DGPackage.Literals.IMAGE__BOUNDS, DCFactory.eINSTANCE.createBounds(d2, d3, d4, d5)));
        }
        return compoundCommand.unwrap();
    }

    public void setFile(File file) {
        this.e = file;
    }

    public void setDoTransaction(boolean bl) {
        this.f = bl;
    }

    public void setImageIcon(CImageIcon cImageIcon) {
        this.h = cImageIcon;
    }

    public boolean isBadTransactionException() {
        return this.i;
    }

    public boolean isException() {
        return this.j;
    }

    public void setImageURI(URI uRI) {
        this.g = uRI;
    }
}

