/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.GeneralizationGroupPresentation;
import net.astah.jmodel.GeneralizationPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreateRelationCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import proguard.annotation.Keep;

@Keep
public class CreateGeneralizationCommand
extends Command {
    protected GeneralizationPresentation gp;
    protected LabelPresentation generalPresentation;
    protected LabelPresentation specificPresentation;
    protected UMLDiagram dgm;
    protected GeneralizationPresentation shared;
    protected boolean isShiftPressed = false;
    Generalization a;
    private String b;
    private Element c;
    protected int direction = 0;

    public void setPresentation(GeneralizationPresentation generalizationPresentation) {
        this.gp = generalizationPresentation;
    }

    public void setGeneralPresentation(LabelPresentation labelPresentation) {
        this.generalPresentation = labelPresentation;
    }

    public void setSpecificPresentation(LabelPresentation labelPresentation) {
        this.specificPresentation = labelPresentation;
    }

    public void setSharedPresentation(GeneralizationPresentation generalizationPresentation) {
        this.shared = generalizationPresentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setModelName(String string) {
        this.b = string;
    }

    public void setDirection(String string) {
        if (string == null) {
            return;
        }
        this.direction = string.equals("horizontal") ? 1 : 0;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            if (this.gp == null || iJomtEntityStore == null || this.generalPresentation == null || this.specificPresentation == null) {
                return;
            }
            Classifier classifier = (Classifier)this.generalPresentation.getModel();
            Classifier classifier2 = (Classifier)this.specificPresentation.getModel();
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.a = Classifiers.getGeneralizableRelation(classifier, classifier2);
                if (this.a != null) {
                    if (this.a.getGeneral().equals(this.specificPresentation.getModel()) && this.a.getSpecific().equals(this.generalPresentation.getModel())) {
                        this.showLoopAlertMessage();
                    } else if (this.a(this.generalPresentation, this.specificPresentation)) {
                        this.showDuplicatedAlertMessage();
                    } else {
                        iJomtEntityStore.addEntity(this.gp);
                        this.gp.setSuperPresentation(this.generalPresentation);
                        this.gp.setSubPresentation(this.specificPresentation);
                        iJomtEntityStore.addEntity(this.gp);
                        ElementPresentations.addPresentation(this.a, this.gp, this.dgm);
                        CreateRelationCommand.setRightAngle(this.gp);
                        this.setPresentationShape();
                    }
                } else {
                    this.createRelationAndEnsureWellFormed(iJomtEntityStore, classifier, classifier2);
                    iJomtEntityStore.addEntity(this.gp);
                    this.gp.setSuperPresentation(this.generalPresentation);
                    this.gp.setSubPresentation(this.specificPresentation);
                    iJomtEntityStore.addEntity(this.gp);
                    ElementPresentations.addPresentation(this.a, this.gp, this.dgm);
                    CreateRelationCommand.setRightAngle(this.gp);
                    this.setPresentationShape();
                    if (this.shared != null) {
                        GeneralizationGroupPresentation generalizationGroupPresentation = null;
                        if (this.shared.isShared()) {
                            generalizationGroupPresentation = this.shared.getSharedGroup();
                            this.gp.setSharedGroup(generalizationGroupPresentation);
                        } else {
                            generalizationGroupPresentation = this.getGroupPresentation();
                            iJomtEntityStore.addEntity(generalizationGroupPresentation);
                            ElementPresentations.addPresentation(null, generalizationGroupPresentation, this.dgm);
                            ArrayList<GeneralizationPresentation> arrayList = new ArrayList<GeneralizationPresentation>();
                            arrayList.add(this.gp);
                            arrayList.add(this.shared);
                            this.gp.setSharedGroup(generalizationGroupPresentation);
                            this.shared.setSharedGroup(generalizationGroupPresentation);
                            generalizationGroupPresentation.setBundledDirection(this.a(this.generalPresentation, this.specificPresentation, (LabelPresentation)this.shared.getSubPresentation()));
                            generalizationGroupPresentation.setBundledPoint(this.getCenterPoint(arrayList, generalizationGroupPresentation.getBundledDirection()));
                        }
                    }
                }
                this.postCreation(this.a);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
            finally {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void createRelationAndEnsureWellFormed(IEntityStore iEntityStore, Classifier classifier, Classifier classifier2) {
        this.a = this.createNewGeneralization(iEntityStore, classifier, classifier2);
        Elements.compareStereotypeAndsetTagValue(this.a);
    }

    protected void showDuplicatedAlertMessage() {
        MessageManager.displayAlertMessageDialog("uml", "duplicated_generalization.message");
    }

    protected void showLoopAlertMessage() {
        MessageManager.displayAlertMessageDialog("uml", "generalization_loop_detected.message");
    }

    protected Generalization createNewGeneralization(IEntityStore iEntityStore, Classifier classifier, Classifier classifier2) {
        Element element = this.getRelationModelForAPI();
        if (element instanceof Generalization) {
            return (Generalization)element;
        }
        Generalization generalization = classifier2.createGeneralization(classifier);
        return generalization;
    }

    protected void postCreation(Generalization generalization) {
    }

    private boolean a(LabelPresentation labelPresentation, LabelPresentation labelPresentation2) {
        List<Presentation> list = labelPresentation.getAllClients();
        List<Presentation> list2 = labelPresentation2.getAllClients();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Presentation presentation = list.get(i2);
            if (!(presentation instanceof GeneralizationPresentation)) continue;
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                if (!list2.get(i3).equals(presentation)) continue;
                return true;
            }
        }
        return false;
    }

    protected Pnt2d getCenterPoint(List<GeneralizationPresentation> list, int n2) {
        GeneralizationPresentation generalizationPresentation = list.get(0);
        LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation.getSuperPresentation();
        Pnt2d pnt2d = labelPresentation.getLocation();
        double d2 = labelPresentation.getWidth();
        double d3 = labelPresentation.getHeight();
        double d4 = pnt2d.x + d2;
        double d5 = pnt2d.y + d3;
        double d6 = 0.0;
        if (n2 == 1) {
            d6 = this.getHorizontalCenterLength(list, d4, d2);
            return new Pnt2d(d4 + d6, pnt2d.y + d3 / 2.0);
        }
        d6 = this.getVerticalCenterLength(list, d5, d3);
        return new Pnt2d(pnt2d.x + d2 / 2.0, d5 + d6);
    }

    protected double getHorizontalCenterLength(List<GeneralizationPresentation> list, double d2, double d3) {
        double d4 = 0.0;
        if (this.hasSubPresentationsRightSuper(list, d2, d3)) {
            double d5 = this.getMinXOfSubPresentations(list, d2);
            d4 = (d5 - d2) / 2.0;
            if (d4 < 15.0) {
                d4 = 15.0;
            }
        } else {
            double d6 = this.getMaxXOfSubPresentationsLeftSuper(list, d2);
            d4 = (d6 - d2 + d3) / 2.0;
            if (d4 > -15.0) {
                d4 = -15.0;
            }
            d4 -= d3;
        }
        return d4;
    }

    protected double getVerticalCenterLength(List<GeneralizationPresentation> list, double d2, double d3) {
        double d4 = 0.0;
        if (this.hasSubPresentationsUnderSuper(list, d2, d3)) {
            double d5 = this.getMinYOfSubPresentations(list, d2);
            d4 = (d5 - d2) / 2.0;
            if (d4 < 15.0) {
                d4 = 15.0;
            }
        } else {
            double d6 = this.getMaxYOfSubPresentationsAboveSuper(list, d2);
            d4 = (d6 - d2 + d3) / 2.0;
            if (d4 > -15.0) {
                d4 = -15.0;
            }
            d4 -= d3;
        }
        return d4;
    }

    protected boolean hasSubPresentationsRightSuper(List<GeneralizationPresentation> list, double d2, double d3) {
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d5 = pnt2d.x;
            if (!(d5 >= d4)) continue;
            return true;
        }
        return false;
    }

    protected double getMinXOfSubPresentations(List<GeneralizationPresentation> list, double d2) {
        double d3 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.x;
            if (!(d4 < d3) || !(d4 >= d2)) continue;
            d3 = d4;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = 0.0;
        }
        return d3;
    }

    protected double getMaxXOfSubPresentationsLeftSuper(List<GeneralizationPresentation> list, double d2) {
        double d3 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.x;
            double d5 = labelPresentation.getWidth();
            double d6 = d4 + d5;
            if (!(d6 <= d2) || !(d6 > d3)) continue;
            d3 = d6;
        }
        return d3;
    }

    protected boolean hasSubPresentationsUnderSuper(List<GeneralizationPresentation> list, double d2, double d3) {
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d5 = pnt2d.y;
            if (!(d5 >= d4)) continue;
            return true;
        }
        return false;
    }

    protected double getMinYOfSubPresentations(List<GeneralizationPresentation> list, double d2) {
        double d3 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.y;
            if (!(d4 < d3) || !(d4 >= d2)) continue;
            d3 = d4;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = 0.0;
        }
        return d3;
    }

    protected double getMaxYOfSubPresentationsAboveSuper(List<GeneralizationPresentation> list, double d2) {
        double d3 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneralizationPresentation generalizationPresentation = list.get(i2);
            if (!(generalizationPresentation instanceof GeneralizationPresentation)) continue;
            GeneralizationPresentation generalizationPresentation2 = generalizationPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)generalizationPresentation2.getSubPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.y;
            double d5 = labelPresentation.getHeight();
            double d6 = d4 + d5;
            if (!(d6 <= d2) || !(d6 > d3)) continue;
            d3 = d6;
        }
        return d3;
    }

    protected void setPresentationShape() {
    }

    protected GeneralizationGroupPresentation getGroupPresentation() {
        return JmodelFactory.eINSTANCE.createGeneralizationGroupPresentation();
    }

    public Generalization getNewGeneral() {
        return this.a;
    }

    public Element getRelationModelForAPI() {
        return this.c;
    }

    public void setRelationModelForAPI(Element element) {
        this.c = element;
    }

    private int a(LabelPresentation labelPresentation, LabelPresentation labelPresentation2, LabelPresentation labelPresentation3) {
        Pnt2d pnt2d = new Pnt2d((labelPresentation2.getCenterX() + labelPresentation3.getCenterX()) / 2.0, (labelPresentation2.getCenterY() + labelPresentation3.getCenterY()) / 2.0);
        Line2d line2d = new Line2d(labelPresentation.getLocation().x, labelPresentation.getLocation().y, labelPresentation.getLocation().x + labelPresentation.getWidth(), labelPresentation.getLocation().y + labelPresentation.getHeight());
        Line2d line2d2 = new Line2d(labelPresentation.getLocation().x + labelPresentation.getWidth(), labelPresentation.getLocation().y, labelPresentation.getLocation().x, labelPresentation.getLocation().y + labelPresentation.getHeight());
        if (line2d.relativeCCW(pnt2d) >= 1) {
            if (line2d2.relativeCCW(pnt2d) >= 1) {
                return 1;
            }
            return 0;
        }
        if (line2d2.relativeCCW(pnt2d) >= 1) {
            return 0;
        }
        return 1;
    }
}

