/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.change_vision.judebiz.model.FlowChartUtil;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.FinalStatePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.StateChartDiagramOperations;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateFinalStateCommand
extends Command {
    protected FinalStatePresentation p;
    protected Region container = null;
    protected UMLDiagram dgm;
    protected boolean isShiftPressed = false;
    private FinalState a;
    private boolean b = false;
    private String c = null;

    public FinalState getModel() {
        return this.a;
    }

    public void setPresentation(FinalStatePresentation finalStatePresentation) {
        this.p = finalStatePresentation;
    }

    public void setName(String string) {
        this.c = string;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setContainer(Region region) {
        this.container = region;
    }

    public void setAnchor(boolean bl) {
        this.b = bl;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            if (this.p == null || iJomtEntityStore == null || this.dgm == null) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (this.container == null) {
                    Namespace namespace = StateChartDiagramOperations.getFrontOverlapState((UMLStateChartDiagram)this.dgm, this.p.getLocation());
                    if (namespace instanceof State) {
                        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.region.label");
                        this.container = ((State)namespace).createRegion(String.format("%s0", string));
                    } else {
                        this.container = (Region)namespace;
                    }
                }
                this.createNewFinalState(iJomtEntityStore);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (IllegalModelTypeException illegalModelTypeException) {
                MessageManager.requireBugReport(illegalModelTypeException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void createNewFinalState(IEntityStore iEntityStore) throws IllegalModelTypeException {
        Object object;
        this.a = UMLFactory.eINSTANCE.createFinalState();
        this.a.setContainer(this.container);
        if (this.dgm instanceof UMLActivityDiagram) {
            // empty if block
        }
        if (this.c != null) {
            this.a.setName(this.c);
        } else {
            object = "";
            object = this.dgm instanceof UMLActivityDiagram ? (FlowChartUtil.isFlowChartDiagram(this.dgm) ? PropertyManager.getProjectViewResourceBundle().getString("uml.final_state_flowchart.label") + ModelGlobal.prjManager.getCurrentProject().finalStateNum++ : PropertyManager.getProjectViewResourceBundle().getString("uml.final_state.label") + ModelGlobal.prjManager.getCurrentProject().finalStateNum++) : PropertyManager.getProjectViewResourceBundle().getString("uml.final_pseudo_state.label") + ModelGlobal.prjManager.getCurrentProject().finalStateNum++;
            this.a.setName((String)object);
        }
        iEntityStore.addEntity(this.p);
        ElementPresentations.addPresentation(this.a, this.p, this.dgm);
        object = ReflectionUtil.getJomtDefaultSizeUtilities(this.p);
        if (((JomtDefaultSizeUtilities)object).getDefaultUse()) {
            this.p.setDoAutoResize(false);
            this.p.setWidth(((JomtDefaultSizeUtilities)object).getDefaultWidth());
            this.p.setHeight(((JomtDefaultSizeUtilities)object).getDefaultHeight());
        }
        this.p.resizeContainer();
    }
}

