/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.UseCasePresentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.uml2.uml.UseCase;

public class CreateExtensionPointCommand
extends Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            if (!(objectArray[0] instanceof UserObject)) {
                return;
            }
            Presentation presentation = ((UserObject)objectArray[0]).getPresentation();
            if (!(presentation instanceof UseCasePresentation)) {
                return;
            }
            UseCase useCase = (UseCase)((UseCasePresentation)presentation).getModel();
            try {
                iJomtEntityStore.beginTransaction();
                String string = PropertyManager.getProjectViewResourceBundle().getString("uml.extension_point.label") + project.extensionPointNum++;
                useCase.createExtensionPoint(string);
                iJomtEntityStore.commitTransaction();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

