/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.astah.dd.di.Diagram;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.CommandSupport;
import net.astah.jomt.jcontrol.CreateNewPrjCommand;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.DiagramOperations;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateDiagramFromPrjCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(CreateDiagramFromPrjCommand.class);
    private EObject b;
    private String c;
    private Diagram d;
    private boolean e = true;
    private boolean f = true;
    protected String invalidParentMessage;
    protected String diagramType;

    protected boolean isValidModel() {
        return this.f;
    }

    @Override
    public void setArgumentString(String string) {
        if (string != null && string.equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.setOpenEditorAfterCreate(false);
        }
    }

    public void setOpenEditorAfterCreate(boolean bl) {
        this.e = bl;
    }

    public boolean isOpenEditorAfterCreate() {
        return this.e;
    }

    public void setParent(EObject eObject) {
        this.b = eObject;
    }

    public EObject getParent() {
        return this.b;
    }

    public Diagram getDiagram() {
        return this.d;
    }

    @Override
    public void execute() {
        try {
            Object object;
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = null;
            if (project == null) {
                object = this.createNewProject();
                this.callCommand((Command)object);
                project = ModelGlobal.prjManager.getCurrentProject();
            }
            iJomtEntityStore = project.doc;
            this.callCommand(BaseCommandSetting.getModelUpdateCommandName());
            if (this.b == null) {
                object = CommandSupport.instance().getSelectedModelElementFromProjectView();
                this.b = this.getOwnerModel(iJomtEntityStore, (EObject)object);
            }
            if ((object = this.findSingletonDiagram(this.b)) != null) {
                this.a((Diagram)object);
                return;
            }
            if (this.isReadOnlyTargetModel(this.b)) {
                MessageManager.displayAlertMessageDialog("app", "read_only_error.message");
                return;
            }
            if (!this.isValidParentModel(this.b)) {
                if (this.invalidParentMessage != null) {
                    MessageManager.displayAlertMessageDialog("app", this.invalidParentMessage);
                }
                return;
            }
            this.updateEditingNode();
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (!this.isCorrectModel(this.b) || this.a(this.b)) {
                    this.f = false;
                    this.b = this.selectCorrectModel(this.b);
                }
                this.addDiagramAndCompareStereotypeAndSetTagValue(iJomtEntityStore);
                if (this.useTransaction) {
                    if (this.d != null) {
                        iJomtEntityStore.commitTransaction();
                    } else {
                        iJomtEntityStore.abortTransaction();
                    }
                }
                this.postOpenEditor();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
            this.doOthersPost(this.d);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected EObject getOwnerModel(IEntityStore iEntityStore, EObject eObject) {
        return eObject;
    }

    protected Diagram findSingletonDiagram(EObject eObject) {
        return null;
    }

    protected void doSpecialLogic(IEntityStore iEntityStore) {
    }

    protected boolean isReadOnlyTargetModel(EObject eObject) {
        return false;
    }

    protected abstract CreateNewPrjCommand createNewProject();

    public void addDiagramAndCompareStereotypeAndSetTagValue(IEntityStore iEntityStore) throws IllegalModelTypeException {
        this.d = this.addDiagram(iEntityStore, this.b);
        if (this.d != null) {
            this.preOpenEditor();
            this.doPostProcessing();
        }
        this.doSpecialLogic(iEntityStore);
    }

    protected boolean isValidParentModel(EObject eObject) {
        return true;
    }

    protected void doOthersPost(Diagram diagram) {
    }

    protected boolean doOpenEditorBeforeCommit() {
        return true;
    }

    protected void preOpenEditor() {
        if (this.d != null && this.e && this.doOpenEditorBeforeCommit()) {
            this.a(this.d);
        }
    }

    protected void postOpenEditor() {
        Diagram diagram = this.getDiagramToOpen();
        if (this.e && !this.doOpenEditorBeforeCommit() && diagram != null) {
            this.a(diagram);
        }
    }

    protected Diagram getDiagramToOpen() {
        return this.d;
    }

    private void a(Diagram diagram) {
        JomtGlobal.commandSupport.setIsFromPrjTree(true);
        Command command = this.createOpenEditorCommand(diagram);
        this.callCommand(command);
    }

    protected Command createOpenEditorCommand(Diagram diagram) {
        OpenDiagramEditorCommand openDiagramEditorCommand = new OpenDiagramEditorCommand();
        DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
        openDiagramEditorCommand.setDiagramViewInfo(diagramViewInfo);
        return openDiagramEditorCommand;
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
        DiagramOperations.addNewFrameIfNeed(this.d);
    }

    public Diagram addDiagram(IEntityStore iEntityStore, EObject eObject) {
        Diagram diagram;
        block4: {
            diagram = this.createNewDiagram(iEntityStore, eObject);
            if (diagram == null) {
                return null;
            }
            int n2 = 100;
            while (true) {
                try {
                    this.setDiagramName(iEntityStore, diagram);
                }
                catch (UMLSemanticsException uMLSemanticsException) {
                    if (n2-- != 0) continue;
                    return null;
                }
                break;
            }
            Iterator<FramePresentation> iterator = Iterables.filter(diagram.getOwnedElements(), FramePresentation.class).iterator();
            if (!iterator.hasNext()) break block4;
            FramePresentation framePresentation = iterator.next();
            this.a(framePresentation);
        }
        return diagram;
    }

    protected boolean isCorrectModel(Object object) {
        return object instanceof EObject;
    }

    protected EObject selectCorrectModel(EObject eObject) {
        return eObject;
    }

    protected abstract Diagram createNewDiagram(IEntityStore var1, EObject var2);

    protected void setDiagramName(IEntityStore iEntityStore, Diagram diagram) {
        diagram.setName(this.getNameString());
    }

    protected abstract String getNameString();

    public EObject getModel() {
        return this.b;
    }

    private void a(LabelPresentation labelPresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.resize();
            labelPresentation.setDoAutoResize(false);
        }
    }

    public String getDiagramName() {
        return this.c;
    }

    public void setDiagramName(String string) {
        this.c = string;
    }

    protected void updateEditingNode() {
        this.callCommand("ModifyName");
    }

    private boolean a(EObject eObject) {
        try {
            ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
            String string = resourceBundleList.getString("jude.is_change_to_valid_model_class");
            if (string == null) {
                return false;
            }
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("isChangeToValidModel", Element.class, String.class);
            if (method == null) {
                return false;
            }
            return (Boolean)method.invoke(clazz.newInstance(), eObject, this.diagramType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.error("error has occurred.", illegalArgumentException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.error("error has occurred.", classNotFoundException);
        }
        catch (SecurityException securityException) {
            a.error("error has occurred.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            a.error("error has occurred.", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.error("error has occurred.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            a.error("error has occurred.", invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            a.error("error has occurred.", instantiationException);
        }
        return false;
    }
}

