/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ContainmentGroupPresentation;
import net.astah.jmodel.ContainmentPresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreateRelationCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Namespaces;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;

public class CreateContainmentCommand
extends Command {
    protected ContainmentPresentation containerPs;
    protected LabelPresentation parentPs;
    protected LabelPresentation childPs;
    protected UMLDiagram dgm;
    protected ContainmentPresentation shared;
    protected boolean isShiftPressed = false;
    private IEntityStore a;
    protected int direction = 0;

    public void setPresentation(ContainmentPresentation containmentPresentation) {
        this.containerPs = containmentPresentation;
    }

    public void setParentPresentation(LabelPresentation labelPresentation) {
        this.parentPs = labelPresentation;
    }

    public void setChildPresentation(LabelPresentation labelPresentation) {
        this.childPs = labelPresentation;
    }

    public void setSharedPresentation(ContainmentPresentation containmentPresentation) {
        this.shared = containmentPresentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setDirection(String string) {
        if (string == null) {
            return;
        }
        this.direction = string.equals("horizontal") ? 1 : 0;
    }

    @Override
    public void execute() {
        this.a = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            if (this.containerPs == null || this.a == null || this.parentPs == null || this.childPs == null) {
                return;
            }
            Namespace namespace = (Namespace)this.parentPs.getModel();
            EObject eObject = this.childPs.getModel();
            try {
                if (this.useTransaction) {
                    this.a.beginTransaction();
                }
                if (this.b(namespace, eObject)) {
                    this.showLoopAlertMessage();
                } else if (!this.a(this.parentPs, this.childPs).isEmpty()) {
                    this.showDuplicatedAlertMessage();
                } else if (this.a(namespace, eObject)) {
                    this.createRelationAndEnsureWellFormed(namespace, eObject);
                    this.a.addEntity(this.containerPs);
                    this.containerPs.setParentPresentation(this.parentPs);
                    this.containerPs.setChildPresentation(this.childPs);
                    Namespaces.setNamespace(this.parentPs.getModel(), this.childPs.getModel());
                    this.dgm.addPresentation(this.containerPs);
                    this.containerPs.setDiagram(this.dgm);
                    CreateRelationCommand.setRightAngle(this.containerPs);
                    if (this.shared != null) {
                        ContainmentGroupPresentation containmentGroupPresentation = null;
                        if (this.shared.isShared()) {
                            containmentGroupPresentation = this.shared.getSharedGroup();
                            this.containerPs.setSharedGroup(containmentGroupPresentation);
                        } else {
                            containmentGroupPresentation = JmodelFactory.eINSTANCE.createContainmentGroupPresentation();
                            this.a.addEntity(containmentGroupPresentation);
                            containmentGroupPresentation.setDiagram(this.dgm);
                            ArrayList<ContainmentPresentation> arrayList = new ArrayList<ContainmentPresentation>();
                            arrayList.add(this.containerPs);
                            arrayList.add(this.shared);
                            this.containerPs.setSharedGroup(containmentGroupPresentation);
                            this.shared.setSharedGroup(containmentGroupPresentation);
                            containmentGroupPresentation.setBundledDirection(this.a(this.parentPs, this.childPs, (LabelPresentation)this.shared.getChildPresentation()));
                            containmentGroupPresentation.setBundledPoint(this.getCenterPoint(arrayList, containmentGroupPresentation.getBundledDirection()));
                        }
                    }
                    this.removeIllegalContainmentPresentations(eObject);
                } else {
                    if (this.useTransaction) {
                        this.a.abortTransaction();
                    }
                    MessageManager.displayAlertMessageDialog("uml", "invalid_containment.message");
                    return;
                }
                if (this.useTransaction) {
                    this.a.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    this.a.abortTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    this.a.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    this.a.abortTransaction();
                }
                throw exception;
            }
            finally {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private boolean a(Namespace namespace, EObject eObject) {
        try {
            String string = PropertyManager.getJudeResourceBundle().getString("jude.create_model_presentation_command");
            String string2 = PropertyManager.getJudeResourceBundle().getString("jude.create_model_presentation_command_method");
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, IEntityStore.class, Namespace.class, Element.class);
            Object object = method.invoke(clazz.newInstance(), this.a, namespace, eObject);
            return (Boolean)object;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void removeIllegalContainmentPresentations(EObject eObject) throws InterruptedException, RollbackException {
        for (Presentation presentation : Presentations.getPresentations(eObject)) {
            List<Presentation> list = presentation.getAllClients();
            for (Presentation presentation2 : list) {
                ContainmentPresentation containmentPresentation;
                if (!(presentation2 instanceof ContainmentPresentation) || (containmentPresentation = (ContainmentPresentation)presentation2).getChildPresentation() != presentation || containmentPresentation.getParentPresentation().getModel() == presentation.getModel().eContainer()) continue;
                EditingDomain editingDomain = this.a.getDomain();
                CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, containmentPresentation));
            }
        }
    }

    private List<ContainmentPresentation> a(LabelPresentation labelPresentation, LabelPresentation labelPresentation2) {
        ArrayList<ContainmentPresentation> arrayList = new ArrayList<ContainmentPresentation>();
        for (Presentation presentation : labelPresentation.getAllClients()) {
            ContainmentPresentation containmentPresentation;
            if (!(presentation instanceof ContainmentPresentation) || (containmentPresentation = (ContainmentPresentation)presentation).getParentPresentation() != labelPresentation || containmentPresentation.getChildPresentation() != labelPresentation2) continue;
            arrayList.add(containmentPresentation);
        }
        return arrayList;
    }

    private boolean b(Namespace namespace, EObject eObject) {
        for (Namespace namespace2 = namespace; namespace2 != null; namespace2 = namespace2.getNamespace()) {
            if (namespace2 != eObject) continue;
            return true;
        }
        return false;
    }

    public void createRelationAndEnsureWellFormed(Namespace namespace, EObject eObject) {
    }

    protected void showDuplicatedAlertMessage() {
        MessageManager.displayAlertMessageDialog("uml", "duplicated_containment.message");
    }

    protected void showLoopAlertMessage() {
        MessageManager.displayAlertMessageDialog("uml", "containment_loop_detected.message");
    }

    protected Pnt2d getCenterPoint(List<ContainmentPresentation> list, int n2) {
        ContainmentPresentation containmentPresentation = list.get(0);
        LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation.getParentPresentation();
        Pnt2d pnt2d = labelPresentation.getLocation();
        double d2 = labelPresentation.getWidth();
        double d3 = labelPresentation.getHeight();
        double d4 = pnt2d.x + d2;
        double d5 = pnt2d.y + d3;
        double d6 = 0.0;
        if (n2 == 1) {
            d6 = this.getHorizontalCenterLength(list, d4, d2);
            return new Pnt2d(d4 + d6, pnt2d.y + d3 / 2.0);
        }
        d6 = this.getVerticalCenterLength(list, d5, d3);
        return new Pnt2d(pnt2d.x + d2 / 2.0, d5 + d6);
    }

    protected double getHorizontalCenterLength(List<ContainmentPresentation> list, double d2, double d3) {
        double d4 = 0.0;
        if (this.hasSubPresentationsRightSuper(list, d2, d3)) {
            double d5 = this.getMinXOfSubPresentations(list, d2);
            d4 = (d5 - d2) / 2.0;
            if (d4 < 15.0) {
                d4 = 15.0;
            }
        } else {
            double d6 = this.getMaxXOfSubPresentationsLeftSuper(list, d2);
            d4 = (d6 - d2 + d3) / 2.0;
            if (d4 > -15.0) {
                d4 = -15.0;
            }
            d4 -= d3;
        }
        return d4;
    }

    protected double getVerticalCenterLength(List<ContainmentPresentation> list, double d2, double d3) {
        double d4 = 0.0;
        if (this.hasSubPresentationsUnderSuper(list, d2, d3)) {
            double d5 = this.getMinYOfSubPresentations(list, d2);
            d4 = (d5 - d2) / 2.0;
            if (d4 < 15.0) {
                d4 = 15.0;
            }
        } else {
            double d6 = this.getMaxYOfSubPresentationsAboveSuper(list, d2);
            d4 = (d6 - d2 + d3) / 2.0;
            if (d4 > -15.0) {
                d4 = -15.0;
            }
            d4 -= d3;
        }
        return d4;
    }

    protected boolean hasSubPresentationsRightSuper(List<ContainmentPresentation> list, double d2, double d3) {
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d5 = pnt2d.x;
            if (!(d5 >= d4)) continue;
            return true;
        }
        return false;
    }

    protected double getMinXOfSubPresentations(List<ContainmentPresentation> list, double d2) {
        double d3 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.x;
            if (!(d4 < d3) || !(d4 >= d2)) continue;
            d3 = d4;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = 0.0;
        }
        return d3;
    }

    protected double getMaxXOfSubPresentationsLeftSuper(List<ContainmentPresentation> list, double d2) {
        double d3 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.x;
            double d5 = labelPresentation.getWidth();
            double d6 = d4 + d5;
            if (!(d6 <= d2) || !(d6 > d3)) continue;
            d3 = d6;
        }
        return d3;
    }

    protected boolean hasSubPresentationsUnderSuper(List<ContainmentPresentation> list, double d2, double d3) {
        double d4 = d2 - d3;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d5 = pnt2d.y;
            if (!(d5 >= d4)) continue;
            return true;
        }
        return false;
    }

    protected double getMinYOfSubPresentations(List<ContainmentPresentation> list, double d2) {
        double d3 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.y;
            if (!(d4 < d3) || !(d4 >= d2)) continue;
            d3 = d4;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = 0.0;
        }
        return d3;
    }

    protected double getMaxYOfSubPresentationsAboveSuper(List<ContainmentPresentation> list, double d2) {
        double d3 = Double.MIN_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContainmentPresentation containmentPresentation = list.get(i2);
            if (!(containmentPresentation instanceof ContainmentPresentation)) continue;
            ContainmentPresentation containmentPresentation2 = containmentPresentation;
            LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation2.getChildPresentation();
            Pnt2d pnt2d = labelPresentation.getLocation();
            double d4 = pnt2d.y;
            double d5 = labelPresentation.getHeight();
            double d6 = d4 + d5;
            if (!(d6 <= d2) || !(d6 > d3)) continue;
            d3 = d6;
        }
        return d3;
    }

    private int a(LabelPresentation labelPresentation, LabelPresentation labelPresentation2, LabelPresentation labelPresentation3) {
        Pnt2d pnt2d = new Pnt2d((labelPresentation2.getCenterX() + labelPresentation3.getCenterX()) / 2.0, (labelPresentation2.getCenterY() + labelPresentation3.getCenterY()) / 2.0);
        Line2d line2d = new Line2d(labelPresentation.getLocation().x, labelPresentation.getLocation().y, labelPresentation.getLocation().x + labelPresentation.getWidth(), labelPresentation.getLocation().y + labelPresentation.getHeight());
        Line2d line2d2 = new Line2d(labelPresentation.getLocation().x + labelPresentation.getWidth(), labelPresentation.getLocation().y, labelPresentation.getLocation().x, labelPresentation.getLocation().y + labelPresentation.getHeight());
        if (line2d.relativeCCW(pnt2d) >= 1) {
            if (line2d2.relativeCCW(pnt2d) >= 1) {
                return 1;
            }
            return 0;
        }
        if (line2d2.relativeCCW(pnt2d) >= 1) {
            return 0;
        }
        return 1;
    }
}

