/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.Project;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.StatePresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.StateChartDiagramOperations;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateCompositeStateCommand
extends Command {
    private Presentation a;
    private Region b = null;
    private UMLDiagram c;
    private ActivityPartition d = null;
    private ActivityPartition e = null;
    protected State newCompositeState;
    private String f = null;
    private boolean g = false;

    public void setPresentation(Presentation presentation) {
        this.a = presentation;
    }

    public void setModelName(String string) {
        this.f = string;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.c = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.g = bl;
    }

    public void setContainer(Region region) {
        this.b = region;
    }

    public State getModel() {
        return this.newCompositeState;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.a == null || iJomtEntityStore == null || this.c == null) {
                return;
            }
            try {
                if (!(this.c instanceof UMLStateChartDiagram)) {
                    return;
                }
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (this.b == null) {
                    Namespace namespace = StateChartDiagramOperations.getFrontOverlapState((UMLStateChartDiagram)this.c, ((JomtPresentation)this.a).getLocation());
                    if (namespace instanceof State) {
                        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.region.label");
                        this.b = ((State)namespace).createRegion(String.format("%s0", string));
                    } else {
                        this.b = (Region)namespace;
                    }
                }
                this.createNewCompositeState(project, iJomtEntityStore);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.g);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (IllegalModelTypeException illegalModelTypeException) {
                MessageManager.requireBugReport(illegalModelTypeException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void createNewCompositeState(Project project, IEntityStore iEntityStore) throws IllegalModelTypeException {
        this.newCompositeState = UMLFactory.eINSTANCE.createState();
        this.newCompositeState.setContainer(this.b);
        String string = this.f != null ? this.f : PropertyManager.getProjectViewResourceBundle().getString("projectview.item.state.label") + project.simpleStateNum++;
        this.newCompositeState.setName(string);
        iEntityStore.addEntity(this.a);
        ElementPresentations.addPresentation(this.newCompositeState, this.a, this.c);
        ((RectPresentation)this.a).setBodyColorWithDefault();
        this.setRelationToNewContainerState(this.b);
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(this.a);
        StatePresentation statePresentation = (StatePresentation)this.a;
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            statePresentation.setDoAutoResize(false);
            statePresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            statePresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            statePresentation.setDoAutoResize(true);
            statePresentation.resize();
        }
        Elements.compareStereotypeAndsetTagValue(this.newCompositeState);
    }

    protected void setRelationToNewContainerState(Region region) {
        StatePresentation statePresentation = (StatePresentation)this.a;
        if (Presentations.getPresentations(region).size() > 0) {
            StatePresentation statePresentation2 = (StatePresentation)Presentations.getPresentations(region).get(0);
            int n2 = statePresentation2.getDepth();
            statePresentation.setDepth(n2 - 1);
        }
    }
}

