/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.CombinedFragmentPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.SequenceMessagePresentation;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jomt.jcontrol.CreateInteractionFragmentCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.SequenceDiagramOperations;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.operations.MessagePresentations;
import net.astah.uml2.uml.CombinedFragments;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateCombinedFragmentCommand
extends CreateInteractionFragmentCommand {
    private CombinedFragmentPresentation a;
    private InteractionOperatorKind b = InteractionOperatorKind.ALT_LITERAL;

    public void setPresentation(CombinedFragmentPresentation combinedFragmentPresentation) {
        super.setPresentation(combinedFragmentPresentation);
        this.a = combinedFragmentPresentation;
    }

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (this.a == null || iJomtEntityStore == null || this.dgm == null) {
                return;
            }
            if (this.isBelowTermination()) {
                MessageManager.displayAlertMessageDialog("uml", "combinedfragment_cannot_below_termination.message");
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                UMLInteractionDiagram uMLInteractionDiagram = (UMLInteractionDiagram)this.dgm;
                Interaction interaction = uMLInteractionDiagram.getInteraction();
                CombinedFragment combinedFragment = CombinedFragments.createCombinedFragment(interaction, this.getCreateEClass(), this.b);
                ElementPresentations.addPresentation(combinedFragment, this.a, this.dgm);
                this.a(combinedFragment);
                this.setRelationWithParent();
                if (uMLInteractionDiagram instanceof UMLSequenceDiagram) {
                    SequenceDiagramOperations.setAllMessageIndex((UMLSequenceDiagram)uMLInteractionDiagram);
                }
                Elements.compareStereotypeAndsetTagValue(combinedFragment);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected EClass getCreateEClass() {
        return UMLPackage.eINSTANCE.getCombinedFragment();
    }

    private void a(CombinedFragment combinedFragment) {
        for (Presentation presentation : this.coveredLifelines) {
            NamedElement namedElement;
            EModelElement eModelElement;
            if (presentation.getModel() instanceof InteractionFragment) {
                eModelElement = (InteractionFragment)presentation.getModel();
                namedElement = (InteractionOperand)combinedFragment.getOperands().get(0);
                eModelElement.setEnclosingOperand((InteractionOperand)namedElement);
                continue;
            }
            if (presentation instanceof LifelinePresentation) {
                eModelElement = (LifelinePresentation)presentation;
                namedElement = eModelElement.getClassifierRole();
                namedElement.getCoveredBys().add(combinedFragment);
                eModelElement.updateLifeline();
                continue;
            }
            if (!(presentation instanceof SequenceMessagePresentation)) continue;
            eModelElement = (Message)presentation.getModel();
            namedElement = this.a((Message)eModelElement);
            if (namedElement != null) {
                if (this.getParentCombinedFragment() == null || this.getParentCombinedFragment().getModel() != namedElement) continue;
                this.a(combinedFragment, (Message)eModelElement);
                continue;
            }
            this.a(combinedFragment, (Message)eModelElement);
        }
    }

    private void a(CombinedFragment combinedFragment, Message message) {
        InteractionOperand interactionOperand = (InteractionOperand)combinedFragment.getOperands().get(0);
        interactionOperand.getFragments().addAll(MessagePresentations.getRelatedFragments(message));
    }

    private CombinedFragment a(Message message) {
        MessageOccurrenceSpecification messageOccurrenceSpecification;
        InteractionOperand interactionOperand;
        if (message.getSendEvent() instanceof MessageOccurrenceSpecification && (interactionOperand = (messageOccurrenceSpecification = (MessageOccurrenceSpecification)message.getSendEvent()).getEnclosingOperand()) != null) {
            return (CombinedFragment)interactionOperand.eContainer();
        }
        if (message.getReceiveEvent() instanceof MessageOccurrenceSpecification && (interactionOperand = (messageOccurrenceSpecification = (MessageOccurrenceSpecification)message.getReceiveEvent()).getEnclosingOperand()) != null) {
            return (CombinedFragment)interactionOperand.eContainer();
        }
        return null;
    }

    public void setOperatorKind(InteractionOperatorKind interactionOperatorKind) {
        this.b = interactionOperatorKind;
    }
}

