/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Namespace;

public abstract class CreateClassifierFromPrjCommand
extends Command {
    protected Classifier newClassifier;
    private boolean a = false;
    protected Namespace parent;
    protected String modelName;

    public void setModelName(String string) {
        this.modelName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore == null) {
            return;
        }
        if (this.parent == null) {
            this.parent = this.getParentPackage();
        }
        if (this.parent == null) {
            return;
        }
        int n2 = 100;
        while (n2-- > 0) {
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.createNewClassifierAndEnsureWellFormed(iJomtEntityStore, this.parent);
                if (!this.useTransaction) break;
                iJomtEntityStore.commitTransaction();
                break;
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(badTransactionException);
                break;
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(exception);
                break;
            }
        }
        this.postCreating();
    }

    public void createNewClassifierAndEnsureWellFormed(IEntityStore iEntityStore, Namespace namespace) {
        this.newClassifier = this.createNewClassifier(iEntityStore, namespace);
        Elements.compareStereotypeAndsetTagValue(this.newClassifier);
    }

    protected void postCreating() {
        if (this.newClassifier != null && this.a) {
            JomtGlobal.commandSupport.startEditing(this.newClassifier);
        }
    }

    protected Namespace getParentPackage() {
        Namespace namespace = (Namespace)JomtGlobal.commandSupport.getSelectedModelElementFromProjectView();
        if (namespace == null) {
            return null;
        }
        return namespace;
    }

    protected abstract Classifier createNewClassifier(IEntityStore var1, Namespace var2);

    protected void setIsFromPrj(boolean bl) {
        this.a = bl;
    }

    public void setParent(Namespace namespace) {
        this.parent = namespace;
    }

    public Classifier getNewClassifier() {
        return this.newClassifier;
    }
}

