/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.ActivityNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.Project;
import net.astah.jmodel.SwimlaneIndependable;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.AutoScroller;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateActivityPartitionCommand
extends Command {
    private ActivityPartitionPresentation a;
    private Presentation b;
    private double c = 175.0;
    private UMLDiagram d;
    private ActivityPartition e;
    private ActivityPartitionPresentation f;
    private String g = null;
    private boolean h = false;
    private static final Logger i = LoggerFactory.getLogger(CreateActivityPartitionCommand.class);

    public ActivityPartition getModel() {
        return this.e;
    }

    public void setPresentation(ActivityPartitionPresentation activityPartitionPresentation) {
        this.a = activityPartitionPresentation;
    }

    public void setParentPresentation(Presentation presentation) {
        this.b = presentation;
    }

    public void setModelName(String string) {
        this.g = string;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.d = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.h = bl;
    }

    public void setDefaultSpan(double d2) {
        this.c = d2;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.a == null || iJomtEntityStore == null || this.d == null) {
                return;
            }
            if (!(this.d instanceof UMLActivityDiagram)) {
                return;
            }
            UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)this.d;
            int n2 = uMLActivityDiagram.getVerticalMaxLevel();
            int n3 = uMLActivityDiagram.getHorizontalMaxLevel();
            boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("jude.activityDiagram.crossSwimlane.support");
            if (!bl) {
                if (this.a.isHorizontal() && n2 > 0) {
                    MessageManager.displayAlertMessageDialog("uml", "cannot_cross_partition.message");
                    return;
                }
                if (!this.a.isHorizontal() && n3 > 0) {
                    MessageManager.displayAlertMessageDialog("uml", "cannot_cross_partition.message");
                    return;
                }
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                ActivityPartition activityPartition = null;
                this.e = null;
                activityPartition = this.b != null ? (ActivityPartition)this.b.getModel() : (!PartitionUtil.hasTopSwimlane(uMLActivityDiagram, this.a) ? PartitionUtil.createTopSwimlane(project, iJomtEntityStore, uMLActivityDiagram, this.a.isHorizontal()) : PartitionUtil.getTopSwimlane(uMLActivityDiagram, this.a.isHorizontal()));
                this.e = this.createSubPartition(iJomtEntityStore, uMLActivityDiagram.getActivityGraph(), activityPartition);
                if (this.g == null) {
                    this.g = PropertyManager.getProjectViewResourceBundle().getString("uml.partition.label") + project.swimlaneNum++;
                }
                this.e.setName(this.g);
                ActivityPartitionPresentation activityPartitionPresentation = this.a;
                List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
                if (list.size() == 0) {
                    this.setFirstPartition(activityPartitionPresentation, uMLActivityDiagram);
                } else {
                    this.addSwimlaneOfTopSwimlanes(uMLActivityDiagram, this.e, activityPartitionPresentation);
                }
                iJomtEntityStore.addEntity(this.a);
                this.addPresentation(uMLActivityDiagram, this.a, this.e);
                this.a.setBodyColorWithDefault();
                this.a.resize();
                ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
                arrayList.add(activityPartitionPresentation);
                PartitionUtil.doAlign(uMLActivityDiagram, activityPartitionPresentation, arrayList);
                this.doMovePartition(uMLActivityDiagram, n2, n3, activityPartitionPresentation);
                this.a(activityPartitionPresentation, uMLActivityDiagram);
                Elements.compareStereotypeAndsetTagValue(this.e);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                this.autoScroll(activityPartitionPresentation);
                this.setCreatedSwimlanePresentation(activityPartitionPresentation);
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.h);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (IllegalModelTypeException illegalModelTypeException) {
                MessageManager.requireBugReport(illegalModelTypeException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void doMovePartition(UMLActivityDiagram uMLActivityDiagram, int n2, int n3, ActivityPartitionPresentation activityPartitionPresentation) {
        int n4 = uMLActivityDiagram.getVerticalMaxLevel();
        int n5 = uMLActivityDiagram.getHorizontalMaxLevel();
        if (!(n2 == n4 && n3 == n5 || n2 == -1 && n3 == -1)) {
            boolean bl = false;
            double d2 = activityPartitionPresentation.getMyNameBlockHeight();
            if (n2 != n4) {
                if (n4 > 1) {
                    bl = true;
                    PartitionUtil.moveAll(uMLActivityDiagram, d2, bl, false);
                    PartitionUtil.moveContentsAndOtherPresentation(uMLActivityDiagram, d2, false);
                } else if (n5 > 1) {
                    bl = false;
                    if (n2 == -1) {
                        d2 = ((double)n5 - 1.0) * activityPartitionPresentation.getMyNameBlockHeight();
                    }
                    PartitionUtil.moveAll(uMLActivityDiagram, d2, bl, false);
                }
            } else if (n3 != n5) {
                if (n5 > 1) {
                    bl = false;
                    PartitionUtil.moveAll(uMLActivityDiagram, d2, bl, false);
                    PartitionUtil.moveContentsAndOtherPresentation(uMLActivityDiagram, d2, true);
                } else if (n4 > 1) {
                    bl = true;
                    if (n3 == -1) {
                        d2 = ((double)n4 - 1.0) * activityPartitionPresentation.getMyNameBlockHeight();
                    }
                    PartitionUtil.moveAll(uMLActivityDiagram, d2, bl, false);
                }
            }
        }
    }

    protected void addSwimlaneOfTopSwimlanes(UMLActivityDiagram uMLActivityDiagram, ActivityPartition activityPartition, ActivityPartitionPresentation activityPartitionPresentation) {
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        this.setNewSwimlaneLoc(activityPartition, activityPartitionPresentation, uMLActivityDiagram, pnt2d, activityPartitionPresentation.isHorizontal());
    }

    protected void setNewSwimlaneLoc(ActivityPartition activityPartition, ActivityPartitionPresentation activityPartitionPresentation, UMLActivityDiagram uMLActivityDiagram, Pnt2d pnt2d, boolean bl) {
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getReferedSwimlanePs(uMLActivityDiagram, pnt2d, bl);
        if (activityPartitionPresentation2 != null) {
            ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
            Pnt2d pnt2d2 = (Pnt2d)activityPartitionPresentation2.getLocation().clone();
            double d2 = PartitionUtil.getNameBlockHeightWithChildren(uMLActivityDiagram, activityPartitionPresentation2);
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (!bl) {
                d3 = activityPartitionPresentation2.getMinY() + d2;
                d4 = activityPartitionPresentation2.getMaxX();
                d5 = pnt2d.x;
                d6 = pnt2d.y;
            } else {
                d3 = activityPartitionPresentation2.getMinX() + d2;
                d4 = activityPartitionPresentation2.getMaxY();
                d5 = pnt2d.y;
                d6 = pnt2d.x;
            }
            if (d5 > d4) {
                activityPartitionPresentation2.insertNextLane(activityPartitionPresentation);
                if (!bl) {
                    pnt2d2.x = activityPartitionPresentation2.getMaxX();
                } else {
                    pnt2d2.y = activityPartitionPresentation2.getMaxY();
                }
                activityPartitionPresentation.setLocation(pnt2d2);
            } else if (d6 > d3) {
                if (!bl) {
                    pnt2d2.y += d2;
                } else {
                    pnt2d2.x += d2;
                }
                activityPartitionPresentation.setLocation(pnt2d2);
            } else {
                double d7 = 0.0;
                d7 = !bl ? activityPartitionPresentation2.getMinX() + activityPartitionPresentation2.getSpan() / 2.0 : activityPartitionPresentation2.getMinY() + activityPartitionPresentation2.getSpan() / 2.0;
                if (d5 < d7) {
                    activityPartitionPresentation2.insertPreviousLane(activityPartitionPresentation);
                    activityPartitionPresentation.setLocation(pnt2d2);
                } else {
                    activityPartitionPresentation2.insertNextLane(activityPartitionPresentation);
                    if (!bl) {
                        pnt2d2.x = activityPartitionPresentation2.getMaxX();
                    } else {
                        pnt2d2.y = activityPartitionPresentation2.getMaxY();
                    }
                    activityPartitionPresentation.setLocation(pnt2d2);
                }
            }
            ActivityPartition activityPartition3 = activityPartition.getSuperPartition();
            if (activityPartition3.equals(activityPartition2)) {
                activityPartitionPresentation.setLength(activityPartitionPresentation2.getLength());
                activityPartitionPresentation.setSpan(activityPartitionPresentation2.getSpan());
            } else {
                activityPartitionPresentation.setLength(activityPartitionPresentation2.getLength());
                activityPartitionPresentation.setSpan(this.c);
            }
        } else {
            double d8 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, !bl);
            activityPartitionPresentation.setLength(d8 + activityPartitionPresentation.getMyNameBlockHeight());
            ActivityPartitionPresentation activityPartitionPresentation3 = PartitionUtil.getDeepestPartitionPs(uMLActivityDiagram, !activityPartitionPresentation.isHorizontal()).get(0);
            activityPartitionPresentation.setSpan(activityPartitionPresentation3.getLength() - activityPartitionPresentation3.getMyNameBlockHeight());
            Pnt2d pnt2d3 = new Pnt2d(0.0, 0.0);
            if (!bl) {
                pnt2d3.x = (double)uMLActivityDiagram.getHorizontalMaxLevel() * activityPartitionPresentation.getMyNameBlockHeight();
                pnt2d3.y = 0.0 - activityPartitionPresentation.getMyNameBlockHeight();
            } else {
                pnt2d3.x = 0.0 - activityPartitionPresentation.getMyNameBlockHeight();
                pnt2d3.y = (double)uMLActivityDiagram.getVerticalMaxLevel() * activityPartitionPresentation.getMyNameBlockHeight();
            }
            activityPartitionPresentation.setLocation(pnt2d3);
        }
    }

    protected void setFirstPartition(ActivityPartitionPresentation activityPartitionPresentation, UMLActivityDiagram uMLActivityDiagram) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = activityPartitionPresentation.getLength();
        Activity activity = uMLActivityDiagram.getActivityGraph();
        EList<ActivityNode> eList = activity.getNodes();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityNode activityNode = (ActivityNode)eList.get(i2);
            Presentation presentation = Presentations.getPresentations(activityNode).get(0);
            if (presentation.getDiagram() instanceof UMLActivityDiagram && activityNode instanceof ActivityParameterNode && presentation instanceof SwimlaneIndependable && ((SwimlaneIndependable)((Object)presentation)).isSwimlaneIndependent()) continue;
            ActivityNodePresentation activityNodePresentation = (ActivityNodePresentation)Presentations.getPresentations(activityNode).get(0);
            if (activityNodePresentation.getLocation().x < 0.0) {
                activityNodePresentation.move(new Vec2d(-activityNodePresentation.getLocation().x, 0.0));
            }
            if (activityNodePresentation.getLocation().y < 0.0) {
                activityNodePresentation.move(new Vec2d(0.0, -activityNodePresentation.getLocation().y));
            }
            Pnt2d pnt2d = activityNodePresentation.getLocation();
            double d5 = pnt2d.x + activityNodePresentation.getWidth();
            double d6 = pnt2d.y + activityNodePresentation.getHeight();
            if (activityPartitionPresentation.isHorizontal()) {
                if (d6 > d3) {
                    d3 = d6;
                }
            } else if (d5 > d2) {
                d2 = d5;
            }
            if (activityPartitionPresentation.getDepth() > activityNodePresentation.getDepth()) continue;
            activityPartitionPresentation.setDepth(activityNodePresentation.getDepth() + 1);
        }
        this.a(activityPartitionPresentation, d2, d3);
    }

    private void a(ActivityPartitionPresentation activityPartitionPresentation, double d2, double d3) {
        if (activityPartitionPresentation.isHorizontal()) {
            if (d3 > this.c) {
                activityPartitionPresentation.setSpan(d3);
            } else {
                activityPartitionPresentation.setSpan(this.c);
            }
            activityPartitionPresentation.setLocation(new Pnt2d(0.0 - activityPartitionPresentation.getMyNameBlockHeight(), 0.0));
        } else {
            if (d2 > this.c) {
                activityPartitionPresentation.setSpan(d2);
            } else {
                activityPartitionPresentation.setSpan(this.c);
            }
            activityPartitionPresentation.setLocation(new Pnt2d(0.0, 0.0 - activityPartitionPresentation.getMyNameBlockHeight()));
        }
    }

    protected void autoScroll(ActivityPartitionPresentation activityPartitionPresentation) {
        if (JomtGlobal.viewManager != null) {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (activityPartitionPresentation == null || diagramEditor == null) {
                return;
            }
            double d2 = diagramEditor.getCamera().toDeviceCoordX(activityPartitionPresentation.getMinX());
            double d3 = diagramEditor.getCamera().toDeviceCoordY(activityPartitionPresentation.getMinY());
            AutoScroller autoScroller = new AutoScroller(diagramEditor);
            autoScroller.autoPanToShow(new Presentation[]{activityPartitionPresentation}, d2, d3);
        }
    }

    private void a(ActivityPartitionPresentation activityPartitionPresentation, UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartition> list = PartitionUtil.getAllSwimlanes(uMLActivityDiagram, activityPartitionPresentation.isHorizontal());
        if (list.size() == 2) {
            ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, !activityPartitionPresentation.isHorizontal());
            if (activityPartition == null) {
                List list2 = uMLActivityDiagram.getActivityGraph().getNodes().stream().filter(activityNode -> !(activityNode instanceof ActivityParameterNode)).collect(Collectors.toList());
                EList<ActivityEdge> eList = uMLActivityDiagram.getActivityGraph().getEdges();
                this.e.getNodes().addAll(list2);
                this.e.getSuperPartition().getNodes().addAll(list2);
                this.e.getEdges().addAll(eList);
                this.e.getSuperPartition().getEdges().addAll(eList);
            } else {
                EList<ActivityNode> eList = activityPartition.getNodes();
                EList<ActivityEdge> eList2 = activityPartition.getEdges();
                this.e.getNodes().addAll(eList);
                this.e.getSuperPartition().getNodes().addAll(eList);
                this.e.getEdges().addAll(eList2);
                this.e.getSuperPartition().getEdges().addAll(eList2);
            }
        } else {
            ActivityPartition activityPartition = this.e.getSuperPartition();
            if (activityPartition.getSubpartitions().size() == 1) {
                this.e.getNodes().addAll(activityPartition.getNodes());
                this.e.getEdges().addAll(activityPartition.getEdges());
            }
        }
    }

    protected void debug(UMLActivityDiagram uMLActivityDiagram) {
        if (i.isDebugEnabled()) {
            Object object;
            i.debug(this.getClass().getName());
            ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
            this.debugPartition(activityPartition);
            List<ActivityPartitionPresentation> list = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, false);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                object = list.get(i2);
                this.debugPartition((ActivityPartition)object.getModel());
            }
            ActivityPartition activityPartition2 = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
            this.debugPartition(activityPartition2);
            object = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, true);
            for (int i3 = 0; i3 < object.size(); ++i3) {
                ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)object.get(i3);
                this.debugPartition((ActivityPartition)activityPartitionPresentation.getModel());
            }
        }
    }

    protected void debugPartition(ActivityPartition activityPartition) {
        if (activityPartition == null) {
            return;
        }
        ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)Presentations.getPresentations(activityPartition).get(0);
        boolean bl = activityPartitionPresentation.isHorizontal();
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        double d2 = activityPartitionPresentation.getSpan();
        double d3 = activityPartitionPresentation.getLength();
        double d4 = activityPartitionPresentation.getNameBlockHeight();
        String string = activityPartition.getLabel();
        String string2 = EObjects.getID(activityPartitionPresentation);
        ActivityPartitionPresentation activityPartitionPresentation2 = activityPartitionPresentation.getPreviousLane();
        ActivityPartitionPresentation activityPartitionPresentation3 = activityPartitionPresentation.getNextLane();
        Activity activity = activityPartition.getInActivity();
        if (bl) {
            if (i.isDebugEnabled()) {
                i.debug("[{}:{}:{}:H]", new Object[]{activityPartition.getName(), string, string2});
                i.debug("act=[{}:{}]", new Object[]{activity, activity.getLabel()});
                i.debug(" {}{}{}{} ", new Object[]{this.debugSuperPartition(activityPartition), this.debugSubPartition(activityPartition), this.debugPreviousPartition(activityPartitionPresentation2), this.debugNextPartition(activityPartitionPresentation3)});
                i.debug("loc={} span(height)={} length(width)={} nameBlockHeight={}", new Object[]{pnt2d, d2, d3, d4});
            }
        } else if (i.isDebugEnabled()) {
            i.debug("[{}:{}:{}:V]", new Object[]{activityPartition.getName(), string, string2});
            i.debug("act=[{}:{}]", new Object[]{activity, activity.getLabel()});
            i.debug(" {}{}{}{} ", new Object[]{this.debugSuperPartition(activityPartition) + this.debugSubPartition(activityPartition) + this.debugPreviousPartition(activityPartitionPresentation2) + this.debugNextPartition(activityPartitionPresentation3)});
            i.debug("loc={} span(width)={} length(height)={} nameBlockHeight={}", new Object[]{pnt2d, d2, d3, d4});
        }
    }

    protected String debugSuperPartition(ActivityPartition activityPartition) {
        StringBuilder stringBuilder = new StringBuilder(" Super=[");
        ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
        if (activityPartition2 != null) {
            Activity activity = activityPartition2.getInActivity();
            stringBuilder.append(activityPartition2);
            stringBuilder.append(":");
            stringBuilder.append(activityPartition2.getLabel());
            stringBuilder.append(" act=");
            stringBuilder.append(activity);
            stringBuilder.append(":");
            stringBuilder.append(activity.getLabel());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected String debugSubPartition(ActivityPartition activityPartition) {
        StringBuilder stringBuilder = new StringBuilder(" Sub=[");
        EList<ActivityPartition> eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            Activity activity = activityPartition2.getInActivity();
            stringBuilder.append(activityPartition2.getName());
            stringBuilder.append(":");
            stringBuilder.append(activityPartition2.getLabel());
            stringBuilder.append(" act=");
            stringBuilder.append(activity);
            stringBuilder.append(":");
            stringBuilder.append(activity.getLabel());
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected String debugPreviousPartition(ActivityPartitionPresentation activityPartitionPresentation) {
        StringBuilder stringBuilder = new StringBuilder(" Previous=[");
        stringBuilder.append(activityPartitionPresentation);
        if (activityPartitionPresentation != null) {
            stringBuilder.append(":");
            stringBuilder.append(EObjects.getID(activityPartitionPresentation));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected String debugNextPartition(ActivityPartitionPresentation activityPartitionPresentation) {
        StringBuilder stringBuilder = new StringBuilder(" Next=[");
        stringBuilder.append(activityPartitionPresentation);
        if (activityPartitionPresentation != null) {
            stringBuilder.append(":");
            stringBuilder.append(EObjects.getID(activityPartitionPresentation));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ActivityPartitionPresentation getCreatedSwimlanePresentation() {
        return this.f;
    }

    public void setCreatedSwimlanePresentation(ActivityPartitionPresentation activityPartitionPresentation) {
        this.f = activityPartitionPresentation;
    }

    public ActivityPartition createSubPartition(IEntityStore iEntityStore, Activity activity, ActivityPartition activityPartition) {
        ActivityPartition activityPartition2 = UMLFactory.eINSTANCE.createActivityPartition();
        activityPartition2.setSuperPartition(activityPartition);
        activityPartition2.setInActivity(activity);
        activityPartition.getSubpartitions().add(activityPartition2);
        return activityPartition2;
    }

    public void addPresentation(UMLActivityDiagram uMLActivityDiagram, Presentation presentation, Element element) throws IllegalModelTypeException {
        uMLActivityDiagram.addPresentation(presentation);
        if (element != null) {
            presentation.setModel(element);
        }
        presentation.setDiagram(uMLActivityDiagram);
    }
}

