/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ActivityParameterNodePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.CreateObjectNodeCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.AutoScroller;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateActivityParameterNodeCommand
extends CreateObjectNodeCommand {
    protected Activity container = null;
    protected PresentationContainer containerPs = null;

    @Override
    public ActivityParameterNode getModel() {
        return (ActivityParameterNode)super.getModel();
    }

    public void setContainerPresentation(PresentationContainer presentationContainer) {
        this.containerPs = presentationContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.presentation == null || iJomtEntityStore == null || this.dgm == null) {
                return;
            }
            if (this.containerPs == null) {
                return;
            }
            if (this.container == null) {
                this.container = this.dgm.getActivityGraph();
            }
            int n2 = 100;
            while (n2-- > 0) {
                try {
                    try {
                        if (this.useTransaction) {
                            iJomtEntityStore.beginTransaction();
                        }
                        Activity activity = this.dgm.getActivityGraph();
                        ActivityParameterNode activityParameterNode = this.createModel();
                        activityParameterNode.setActivity(activity);
                        Parameter parameter = activity.createOwnedParameter(activityParameterNode.getName(), activityParameterNode.getType());
                        activityParameterNode.setParameter(parameter);
                        iJomtEntityStore.addEntity(this.presentation);
                        this.presentation.setModel(activityParameterNode);
                        this.presentation.setDepth(this.containerPs.getDepth() - 1);
                        this.presentation.setContainer(this.containerPs);
                        this.presentation.setBodyColorWithDefault();
                        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(this.presentation);
                        if (jomtDefaultSizeUtilities.getDefaultUse()) {
                            Rectangle2d rectangle2d = this.presentation.getRect();
                            this.presentation.setDoAutoResize(false);
                            this.presentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
                            this.presentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
                            Pnt2d pnt2d = this.presentation.getLocation();
                            pnt2d.x -= (jomtDefaultSizeUtilities.getDefaultWidth() - rectangle2d.width) / 2.0;
                            pnt2d.y -= (jomtDefaultSizeUtilities.getDefaultHeight() - rectangle2d.height) / 2.0;
                        } else {
                            Rectangle2d rectangle2d = this.presentation.getRect();
                            this.presentation.setDoAutoResize(true);
                            double d2 = this.presentation.getDefaultWidth();
                            double d3 = 5.0 + this.presentation.getDefaultLabelHeight() + 3.0;
                            this.presentation.setWidth(d2);
                            this.presentation.setHeight(d3);
                            Pnt2d pnt2d = this.presentation.getLocation();
                            pnt2d.x -= (d2 - rectangle2d.width) / 2.0;
                            pnt2d.y -= (d3 - rectangle2d.height) / 2.0;
                            this.presentation.setLocation(pnt2d);
                        }
                        Elements.compareStereotypeAndsetTagValue(activityParameterNode);
                        ElementPresentations.addPresentation(activityParameterNode, this.presentation, this.dgm);
                        this.presentation.setBodyColorWithDefault();
                        this.setSize();
                        if (this.useTransaction) {
                            iJomtEntityStore.commitTransaction();
                        }
                        this.autoScroll((ActivityParameterNodePresentation)this.presentation);
                        if (JomtGlobal.modeManager == null) return;
                        JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                        return;
                    }
                    catch (UMLSemanticsException uMLSemanticsException) {
                        if (!this.useTransaction) continue;
                        iJomtEntityStore.abortTransaction();
                    }
                    catch (BadTransactionException badTransactionException) {
                        MessageManager.requireBugReport(badTransactionException);
                        if (!this.useTransaction) return;
                        iJomtEntityStore.abortTransaction();
                        return;
                    }
                    catch (Exception exception) {
                        if (!this.useTransaction) throw exception;
                        iJomtEntityStore.abortTransaction();
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return;
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void AddClassifierInState(IEntityStore iEntityStore) {
    }

    protected void autoScroll(ActivityParameterNodePresentation activityParameterNodePresentation) {
        if (JomtGlobal.viewManager == null) {
            return;
        }
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (activityParameterNodePresentation == null || diagramEditor == null) {
            return;
        }
        AutoScroller autoScroller = new AutoScroller(diagramEditor);
        autoScroller.autoPanToShow2(new Presentation[]{activityParameterNodePresentation});
    }

    @Override
    protected ActivityParameterNode createModel() {
        ActivityParameterNode activityParameterNode = UMLFactory.eINSTANCE.createActivityParameterNode();
        Project project = ModelGlobal.prjManager.getCurrentProject();
        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.activity_parameter_node.label") + project.activityParameterNodeNum++;
        activityParameterNode.setName(string);
        return activityParameterNode;
    }

    @Override
    protected void addtionalSetup() {
    }
}

