/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ActivityNodePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.SwimlaneIndependable;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;

public abstract class CreateActivityNodeCommand
extends Command {
    protected ActivityNode model;
    protected ActivityNodePresentation presentation;
    protected UMLActivityDiagram dgm;
    protected Activity containerActivity;
    protected boolean isShiftPressed = false;
    protected String modelName = null;
    private List<ActivityPartition> a = new ArrayList<ActivityPartition>();

    protected abstract ActivityNode createModel();

    protected abstract void addtionalSetup();

    public ActivityNode getModel() {
        return this.model;
    }

    public void setPresentation(ActivityNodePresentation activityNodePresentation) {
        this.presentation = activityNodePresentation;
    }

    public ActivityNodePresentation getPresentation() {
        return this.presentation;
    }

    public void setDiagram(UMLActivityDiagram uMLActivityDiagram) {
        this.dgm = uMLActivityDiagram;
    }

    public UMLActivityDiagram getDiagram() {
        return this.dgm;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setContainer(Activity activity) {
        this.containerActivity = activity;
    }

    @Override
    public void execute() {
        block4: {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                if (this.presentation == null || iJomtEntityStore == null || this.dgm == null) {
                    return;
                }
                if (!this.isModelCorrect()) {
                    return;
                }
                this.addModels(iJomtEntityStore);
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
                if (!this.useTransaction) break block4;
                iJomtEntityStore.abortTransaction();
            }
        }
    }

    protected boolean isModelCorrect() {
        return true;
    }

    protected void addModels(IEntityStore iEntityStore) {
        try {
            this.createActivityNode(iEntityStore);
            if (JomtGlobal.modeManager != null) {
                JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
            }
        }
        catch (UMLSemanticsException uMLSemanticsException) {
            MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
            if (this.useTransaction) {
                iEntityStore.abortTransaction();
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            if (this.useTransaction) {
                iEntityStore.abortTransaction();
            }
        }
        catch (IllegalModelTypeException illegalModelTypeException) {
            MessageManager.requireBugReport(illegalModelTypeException);
            if (this.useTransaction) {
                iEntityStore.abortTransaction();
            }
        }
    }

    public ActivityNode createActivityNode(IEntityStore iEntityStore) throws IllegalModelTypeException {
        if (!this.isModelCorrect()) {
            return null;
        }
        if (this.useTransaction) {
            iEntityStore.beginTransaction();
        }
        if (this.containerActivity == null) {
            this.containerActivity = this.dgm.getActivityGraph();
        }
        this.model = this.createModel();
        if (this.modelName != null) {
            this.model.setName(this.modelName);
        }
        this.model.setActivity(this.containerActivity);
        if (!(this.presentation instanceof SwimlaneIndependable) || !((SwimlaneIndependable)((Object)this.presentation)).isSwimlaneIndependent()) {
            for (ActivityPartition activityPartition : this.a) {
                this.model.getInPartitions().add(activityPartition);
            }
        }
        iEntityStore.addEntity(this.presentation);
        this.addtionalSetup();
        ElementPresentations.addPresentation(this.model, this.presentation, this.dgm);
        this.presentation.setBodyColorWithDefault();
        this.setSize();
        if (this.needResize()) {
            this.presentation.resizeContainer();
        }
        if (this.useTransaction) {
            iEntityStore.commitTransaction();
        }
        return this.model;
    }

    protected Activity getContainer() {
        return this.dgm.getActivityGraph();
    }

    protected boolean needResize() {
        return true;
    }

    protected void setSize() {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(this.presentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            this.presentation.setDoAutoResize(false);
            this.presentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            this.presentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            this.presentation.setDoAutoResize(true);
            this.presentation.resize();
            this.presentation.setDoAutoResize(false);
        }
    }

    public void addPartitions(Set<ActivityPartition> set) {
        this.a.addAll(set);
    }

    public void setModelName(String string) {
        this.modelName = string;
    }
}

