/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Style;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.widget.CColor;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.edit.layout.MMStyleMapOwner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Slot;

public class CopyStyleCommand
extends Command {
    @Override
    public void execute() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Map<String, String> map = this.getStylesToCopy(editor);
        if (map == null) {
            return;
        }
        ViewGlobal.styleClipboard.setNeedFireChange(!EObjects.isReadOnly(this.getDiagram(editor)));
        ViewGlobal.styleClipboard.setStyles(map);
    }

    protected Editor getEditor() {
        return JomtGlobal.viewManager.getCurrentDiagramEditor();
    }

    protected Diagram getDiagram(Editor editor) {
        return ((DiagramEditor)this.getEditor()).getDiagram();
    }

    protected Map<String, String> getStylesToCopy(Editor editor) {
        DiagramEditor diagramEditor = (DiagramEditor)editor;
        List<GNode> list = diagramEditor.getCanvas().getSelectedNodes();
        List<GNode> list2 = StyleSupport.getTargetsForFontColor(list);
        if (list2 == null || list2.size() != 1) {
            return null;
        }
        GNode gNode = list2.get(0);
        if (gNode == null) {
            return null;
        }
        Object object = null;
        boolean bl = false;
        if (gNode instanceof CJomtTextNode) {
            object = ((CJomtTextNode)gNode).getModel();
            bl = true;
        } else {
            object = gNode.getModel();
        }
        if (object instanceof MMDiagramElement) {
            if (object instanceof MMDiagram) {
                return null;
            }
            return MMStyleMapOwner.getAllStylesWithAuto((MMDiagramElement)object);
        }
        if (object instanceof GraphicalElement) {
            MessageManager.displayToDoWarningMessage();
            return null;
        }
        if (object instanceof DiagramElement) {
            DiagramElement diagramElement = (DiagramElement)object;
            Style style = diagramElement.getLocalStyle();
            if (style != null) {
                HashMap<String, String> hashMap = Maps.newHashMap();
                hashMap.put((String)((Object)diagramElement.eClass()), (String)((Object)style));
                return hashMap;
            }
            return null;
        }
        UserObject userObject = (UserObject)object;
        EObject eObject = userObject.getModel();
        Presentation presentation = userObject.getPresentation();
        Map<String, String> map = presentation.getAllStylesWithAuto();
        if (eObject instanceof NamedElement || eObject instanceof Slot) {
            Object object2;
            if (presentation instanceof LabelPresentation && (object2 = ((LabelPresentation)presentation).getCompositeParent()) != null) {
                presentation = object2;
            }
            if (bl) {
                if (userObject.isSubItem()) {
                    map.clear();
                    this.addSubItemFontColor(userObject, presentation, map);
                } else {
                    object2 = map.get("font.color");
                    map.clear();
                    map.put("font.color", (String)object2);
                }
                return map;
            }
            this.addSubItemFontColor(userObject, presentation, map);
            return map;
        }
        if (this.isStyleSupportedSubItem(userObject)) {
            map.clear();
            this.addSubItemFontColor(userObject, presentation, map);
            return map;
        }
        return map;
    }

    protected boolean isStyleSupportedSubItem(UserObject userObject) {
        return false;
    }

    protected void addSubItemFontColor(UserObject userObject, Presentation presentation, Map<String, String> map) {
        if (!userObject.isSubItem()) {
            return;
        }
        EObject eObject = userObject.getModel();
        if (eObject != null) {
            CColor cColor = StyleSupport.getSubItemFontColorWithAuto(presentation, (Element)eObject);
            map.put("font.color", cColor.toString());
        }
    }
}

