/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.ActionPresentation;
import net.astah.jmodel.DiagramEntityClipboard;
import net.astah.jmodel.FinalStatePresentation;
import net.astah.jmodel.InitialStatePresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.TransitionPresentation;
import net.astah.jomt.jcontrol.CutCopyCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.JomtPresentationUtil;
import net.astah.jomt.jutil.RubberUtilities;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.uml2.uml.FinalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyCommand
extends CutCopyCommand {
    private static final Logger a = LoggerFactory.getLogger(CopyCommand.class);
    protected boolean withImage = false;

    @Override
    public void setArgumentString(String string) {
        this.withImage = string != null && string.equalsIgnoreCase("image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        DiagramEntityClipboard diagramEntityClipboard = ViewGlobal.clipboard;
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        this.dgm = diagramEditor.getDiagram();
        if (this.presentations == null && diagramEditor != null) {
            this.presentations = diagramEditor.getSelectedPresentations();
        }
        if (diagramEntityClipboard == null || this.presentations == null || this.presentations.length == 0) {
            return;
        }
        diagramEntityClipboard.setClipType(0);
        if (this.isNoNeedDoCopy(diagramEntityClipboard, this.dgm)) {
            return;
        }
        try {
            RubberUtilities.setCopyMode(true);
            Transferable transferable = this.a();
            if (transferable != null) {
                diagramEntityClipboard.setSystemClipboard(transferable);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            a.error("error has occurred.", outOfMemoryError);
            this.handleMemoryError(diagramEntityClipboard, "copy_failure.message");
            int n2 = MessageManager.displayMessageOKDialog("app", "out_of_memory.message");
            a.error("OutOfMemoryError has occurred.", outOfMemoryError);
            a.info("choose value: {}", n2);
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
            this.handleMemoryError(diagramEntityClipboard, "copy_failure.message");
        }
        finally {
            RubberUtilities.setCopyMode(false);
        }
    }

    private Transferable a() {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.transfer.copy_all");
        if (bl || this.withImage) {
            return this.getTransferableImage();
        }
        return null;
    }

    protected boolean isNoNeedDoCopy(DiagramEntityClipboard diagramEntityClipboard, Diagram diagram) {
        return false;
    }

    @Override
    protected DiagramElement[] getValidCopy(DiagramElement[] diagramElementArray) {
        List<DiagramElement> list = Arrays.asList(diagramElementArray);
        Presentation[] presentationArray = Iterables.toArray(Iterables.filter(list, Presentation.class), Presentation.class);
        DiagramElement[] diagramElementArray2 = JomtPresentationUtil.getValidCopy(presentationArray, true);
        diagramElementArray2 = this.a((Presentation[])diagramElementArray2);
        return diagramElementArray2;
    }

    protected Presentation[] addAtlieDefaultElements(Presentation[] presentationArray) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        ArrayList<Presentation> arrayList2 = new ArrayList<Presentation>();
        for (Presentation presentation : presentationArray) {
            arrayList.add(presentation);
            if (!(presentation instanceof InitialStatePresentation) && !(presentation instanceof FinalStatePresentation)) continue;
            arrayList2.addAll(this.a(presentation));
        }
        for (Presentation presentation : arrayList2) {
            if (arrayList.contains(presentation)) continue;
            arrayList.add(presentation);
        }
        return arrayList.toArray(new Presentation[arrayList.size()]);
    }

    private List<Presentation> a(Presentation presentation) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        List<Presentation> list = presentation.getClients();
        for (Presentation presentation2 : list) {
            if (!(presentation2 instanceof TransitionPresentation)) continue;
            arrayList.add(presentation2);
            arrayList.addAll(presentation2.getServers());
        }
        return arrayList;
    }

    private Presentation[] a(Presentation[] presentationArray) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        ArrayList<Presentation> arrayList2 = new ArrayList<Presentation>();
        for (Presentation presentation : presentationArray) {
            arrayList.add(presentation);
            if (presentation instanceof ActionPresentation) {
                if (!this.b(presentation)) continue;
                arrayList2.add(presentation);
                continue;
            }
            if (!this.a(presentation, presentationArray)) continue;
            arrayList2.add(presentation);
        }
        arrayList.removeAll(arrayList2);
        return arrayList.toArray(new Presentation[arrayList.size()]);
    }

    private boolean b(Presentation presentation) {
        for (Presentation presentation2 : presentation.getClients()) {
            for (Presentation presentation3 : presentation2.getServers()) {
                if (!(presentation3.getModel() instanceof FinalState) && !(presentation3 instanceof InitialStatePresentation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean a(Presentation presentation, Presentation[] presentationArray) {
        List<Presentation> list = Arrays.asList(presentationArray);
        return presentation instanceof PartPresentation && !list.contains(((PartPresentation)presentation).getContainer());
    }
}

