/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.ClassifierFactory;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.HyperlinkUtil;
import net.astah.jomt.jview.DNDConvertDialog;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.extension.Hyperlink;
import net.astah.model.extension.Hyperlinks;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Vertex;

public abstract class ConvertToUMLCommand
extends Command {
    protected String target;

    @Override
    public void setArgumentString(String string) {
        if (string != null) {
            this.target = string;
        }
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            Object[] objectArray = this.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                JFrame jFrame = (JFrame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
                DNDConvertDialog dNDConvertDialog = this.createConvertDialog(objectArray, jFrame);
                dNDConvertDialog.setLocationRelativeTo(jFrame);
                dNDConvertDialog.setVisible(true);
                if (dNDConvertDialog.getResult() == 1) {
                    List<Object> list = dNDConvertDialog.getCheckedItems();
                    for (Object object : list) {
                        Classifier classifier;
                        EModelElement eModelElement;
                        if (!this.isTarget(object)) continue;
                        if (object instanceof MMTopicShape) {
                            eModelElement = (MMTopicShape)object;
                            classifier = this.a((DiagramElement)eModelElement, (Namespace)dNDConvertDialog.getNamespace((MMTopicShape)eModelElement));
                            if (classifier == null) continue;
                            this.a(dNDConvertDialog, eModelElement, classifier);
                            continue;
                        }
                        if (!(object instanceof NamedElement) || (classifier = this.a((NamedElement)(eModelElement = (NamedElement)object), (Namespace)dNDConvertDialog.getNamespace(eModelElement))) == null) continue;
                        this.a(dNDConvertDialog, eModelElement, classifier);
                    }
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                iJomtEntityStore.abortTransaction();
                MessageManager.displayAlertMessageDialog("uml", "classifier_unique_name_error.message");
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract boolean isTarget(Object var1);

    private Classifier a(NamedElement namedElement, Namespace namespace) {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        Classifier classifier = null;
        String string = namedElement.getName().replaceAll("\n", "");
        if (this.target.equals("Class")) {
            classifier = ClassifierFactory.createClass((IEntityStore)iJomtEntityStore, namespace, string);
        } else if (this.target.equals("Interface")) {
            classifier = ClassifierFactory.createInterface((IEntityStore)iJomtEntityStore, namespace, string);
        } else if (this.target.equals("Actor")) {
            classifier = ClassifierFactory.createActor((IEntityStore)iJomtEntityStore, namespace, string);
        } else if (this.target.equals("UseCase")) {
            classifier = ClassifierFactory.createUseCase((IEntityStore)iJomtEntityStore, namespace, string);
        } else {
            return null;
        }
        JomtGlobal.commandSupport.setIsFromPrjTree(false);
        return classifier;
    }

    private Classifier a(DiagramElement diagramElement, Namespace namespace) {
        Object object;
        EModelElement eModelElement;
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (namespace == null) {
            eModelElement = DiagramElementOperations.getDiagram(diagramElement);
            if (eModelElement instanceof UMLDiagram) {
                object = ((UMLDiagram)eModelElement).getParent();
                namespace = (Namespace)object;
            } else if (eModelElement instanceof MMDiagram) {
                object = ((MMDiagram)eModelElement).getParent();
                namespace = (Namespace)object;
            }
        }
        eModelElement = null;
        object = "";
        if (diagramElement instanceof MMTopicShape) {
            object = ((MMTopicShape)diagramElement).getText();
        }
        if (this.target.equals("Class")) {
            eModelElement = ClassifierFactory.createClass((IEntityStore)iJomtEntityStore, namespace, (String)object);
        } else if (this.target.equals("Interface")) {
            eModelElement = this.createClassifierForInterface(iJomtEntityStore, namespace, (String)object);
        } else if (this.target.equals("Actor")) {
            eModelElement = ClassifierFactory.createActor((IEntityStore)iJomtEntityStore, namespace, (String)object);
        } else if (this.target.equals("UseCase")) {
            eModelElement = ClassifierFactory.createUseCase((IEntityStore)iJomtEntityStore, namespace, (String)object);
        } else {
            return null;
        }
        JomtGlobal.commandSupport.setIsFromPrjTree(false);
        return eModelElement;
    }

    protected Classifier createClassifierForInterface(MMTopicShape mMTopicShape, Namespace namespace, IEntityStore iEntityStore) {
        return ClassifierFactory.createInterface(iEntityStore, namespace, mMTopicShape.getText());
    }

    protected Classifier createClassifierForInterface(IEntityStore iEntityStore, Namespace namespace, String string) {
        return ClassifierFactory.createInterface(iEntityStore, namespace, string);
    }

    protected abstract Object[] getSelectedModels();

    protected Set<EObject> getModels(Object[] objectArray) {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        for (Object object : objectArray) {
            EObject eObject;
            if (object instanceof MMTopicShape) {
                hashSet.add((MMTopicShape)object);
                continue;
            }
            if (!(object instanceof UserObject) || !((eObject = ((UserObject)object).getModel()) instanceof Vertex)) continue;
            hashSet.add(eObject);
        }
        return hashSet;
    }

    protected abstract DNDConvertDialog createConvertDialog(Object[] var1, JFrame var2);

    private void a(DNDConvertDialog dNDConvertDialog, EObject eObject, EObject eObject2) {
        boolean bl = dNDConvertDialog.isSourceToTarget();
        boolean bl2 = dNDConvertDialog.isTargetToSource();
        boolean bl3 = dNDConvertDialog.isCopyHyperlinkToModel();
        if (bl3) {
            for (Hyperlink hyperlink : Hyperlinks.getHyperlinks(eObject)) {
                HyperlinkUtil.copyHyperlinkToModel(eObject2, hyperlink);
            }
        }
        if (bl) {
            HyperlinkUtil.createHyperlink(eObject, eObject2);
        }
        if (bl2) {
            HyperlinkUtil.createHyperlink(eObject2, eObject);
        }
    }
}

