/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.compare.CompareJob;
import net.astah.emf.compare.ProjectComparisonScope;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.control.Command;
import net.astah.golf.model.EMFEntityStore;
import net.astah.golf.util.NonCompatibleException;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.CommonDialog;
import net.astah.jomt.jview.CompareDialog;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.provider.CompareItemProviderAdapterFactory;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareProjectCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(CompareProjectCommand.class);

    @Override
    public void execute() {
        CommonDialog commonDialog = JomtWidgetFactory.instance().createCommonOpenFileDialog();
        commonDialog.setTitle(CompareProjectCommand.a("ui.compare_and_merge_dialog.title.label"));
        File file = commonDialog.open();
        if (file == null) {
            return;
        }
        Project project = ModelGlobal.prjManager.getCurrentProject();
        ProjectComparisonScope projectComparisonScope = new ProjectComparisonScope(project.doc);
        projectComparisonScope.setRight(new EMFEntityStore(), file);
        EditingDomain editingDomain = project.doc.getDomain();
        CompareJob compareJob = new CompareJob((TransactionalEditingDomain)editingDomain, projectComparisonScope);
        compareJob.addJobChangeListener(Jobs.done(iJobChangeEvent -> {
            try {
                IStatus iStatus = compareJob.getResult();
                if (iStatus.isOK()) {
                    Comparison comparison = compareJob.getComparison();
                    if (comparison.getDifferences().isEmpty()) {
                        MessageManager.displayInfoMessageDialog("app", "compare_project_no_difference_found.message");
                    } else {
                        this.showCompareDialog(projectComparisonScope, comparison);
                    }
                } else if (iStatus.getSeverity() != 8) {
                    Throwable throwable = iStatus.getException();
                    if (throwable instanceof IOException) {
                        MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                    } else if (throwable instanceof NonCompatibleException) {
                        String string = throwable.getMessage() != null ? throwable.getMessage() : "noncompatible_model_error.message";
                        MessageManager.displayErrorMessage("app", string);
                    } else if (throwable instanceof OutOfMemoryError) {
                        MessageManager.displayErrorMessage("app", "out_of_memory.message");
                    } else if (throwable instanceof StackOverflowError) {
                        MessageManager.displayErrorMessage("app", "stack_overflow_error.message");
                    } else {
                        MessageManager.displayStatusMessageDialog("app", "compare.unexpected_error", iStatus);
                        a.error(iStatus.getMessage(), throwable);
                    }
                }
            }
            finally {
                projectComparisonScope.dispose();
            }
        }, true));
        compareJob.schedule();
    }

    private static String a(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showCompareDialog(IComparisonScope iComparisonScope, Comparison comparison) {
        ComposedAdapterFactory composedAdapterFactory = this.createComparisonAdapterFactory();
        EditingDomain editingDomain = this.attachEditingDomain(comparison, composedAdapterFactory);
        try {
            CompareDialog compareDialog = new CompareDialog((Frame)this.a(), iComparisonScope, comparison);
            compareDialog.setDefaultCloseOperation(2);
            compareDialog.setLocationByPlatform(true);
            compareDialog.setVisible(true);
        }
        finally {
            ResourceSets.dispose(editingDomain.getResourceSet());
        }
    }

    protected EditingDomain attachEditingDomain(Comparison comparison, AdapterFactory adapterFactory) {
        AdapterFactoryEditingDomain adapterFactoryEditingDomain = new AdapterFactoryEditingDomain(adapterFactory, new BasicCommandStack());
        ResourceImpl resourceImpl = new ResourceImpl(URI.createURI("comparison:/"));
        adapterFactoryEditingDomain.getResourceSet().getResources().add(resourceImpl);
        resourceImpl.getContents().add(comparison);
        return adapterFactoryEditingDomain;
    }

    protected ComposedAdapterFactory createComparisonAdapterFactory() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory();
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new CompareItemProviderAdapterFactory());
        return composedAdapterFactory;
    }

    private JFrame a() {
        return (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
    }
}

