/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.base.Strings;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.golf.draw.GCamera;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.JmodelPackage;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jomt.jcontrol.CreateDiagramFromPrjCommand;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jcontrol.j;
import net.astah.jomt.jcontrol.k;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.HyperlinkUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.command.AstahCopyToClipboardCommand;
import net.astah.model.command.AstahPasteFromClipboardCommand;
import net.astah.model.extension.Extensions;
import net.astah.model.extension.Hyperlink;
import net.astah.model.extension.Hyperlinks;
import net.astah.model.operations.DiagramOperations;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.uml.NamedElement;

public class CloneModelFromPrjCommand
extends net.astah.golf.control.Command {
    protected IEntityStore doc;
    private NamedElement a;
    private String b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project == null || project.doc == null) {
            return;
        }
        this.doc = project.doc;
        EObject eObject = this.d();
        if (!this.isClonable(eObject)) {
            return;
        }
        Command command = this.createCloneModelCommand(eObject);
        try {
            if (!command.canExecute()) {
                return;
            }
            command.execute();
            Collection<?> collection = command.getResult();
            this.doc.beginTransaction();
            EObject eObject2 = this.cloneModel(eObject, collection);
            this.doc.commitTransaction();
            this.a(eObject2);
        }
        catch (UMLSemanticsException uMLSemanticsException) {
            this.doc.abortTransaction();
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            this.doc.abortTransaction();
        }
        catch (Exception exception) {
            this.doc.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
        finally {
            command.dispose();
        }
    }

    protected boolean isClonable(EObject eObject) {
        return eObject instanceof UMLDiagram || eObject instanceof MMDiagram;
    }

    protected Command createCloneModelCommand(EObject eObject) {
        return this.a(eObject, Collections.emptyList());
    }

    private Command a(EObject eObject, Collection<DiagramElement> collection) {
        if (eObject instanceof Diagram) {
            return this.a((Diagram)eObject, collection);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected EObject cloneModel(EObject eObject, Collection<?> collection) {
        if (eObject instanceof UMLDiagram) {
            UMLDiagram uMLDiagram = (UMLDiagram)eObject;
            UMLDiagram uMLDiagram2 = this.a((NamedElement)uMLDiagram.getParent(), uMLDiagram);
            this.a((Diagram)uMLDiagram, (Diagram)uMLDiagram2);
            Pnt2d pnt2d = this.a(uMLDiagram.getOwnedElements());
            if (pnt2d != null) {
                this.a((Diagram)uMLDiagram2, pnt2d);
            }
            return uMLDiagram2;
        }
        if (eObject instanceof MMDiagram) {
            MMDiagram mMDiagram = (MMDiagram)eObject;
            Diagram diagram = this.cloneDiagram(this.a == null ? (NamedElement)mMDiagram.getParent() : this.a, mMDiagram);
            Pnt2d pnt2d = this.a(mMDiagram.getOwnedElements());
            if (pnt2d != null) {
                this.a(diagram, pnt2d);
            }
            return diagram;
        }
        return null;
    }

    private void a(Diagram diagram, Diagram diagram2) {
        FramePresentation framePresentation = DiagramOperations.getFramePresentation(diagram);
        FramePresentation framePresentation2 = DiagramOperations.getFramePresentation(diagram2);
        framePresentation2.setLocation(framePresentation.getLocation());
        framePresentation2.setSize(framePresentation.getWidth(), framePresentation.getHeight());
    }

    private void a(EObject eObject) {
        if (eObject instanceof Diagram) {
            this.a((Diagram)eObject);
            this.a();
        }
    }

    private void a() {
        this.b();
        this.c();
    }

    private void b() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(""), null);
    }

    private void c() {
        EditingDomain editingDomain = this.doc.getDomain();
        Collection<Object> collection = editingDomain.getClipboard();
        collection.clear();
    }

    private Pnt2d a(List<DiagramElement> list) {
        List<DiagramElement> list2 = list.stream().filter(diagramElement -> !(diagramElement instanceof FramePresentation)).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return null;
        }
        Rectangle2D rectangle2D = DiagramElementOperations.getBoundsRect(list2.toArray(new DiagramElement[0]), false);
        return new Pnt2d(rectangle2D.getMinX(), rectangle2D.getMinY());
    }

    private Command a(Diagram diagram, Collection<DiagramElement> collection) {
        if (collection.isEmpty()) {
            collection = diagram.getOwnedElements();
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(diagram);
        DiagramContext diagramContext = new DiagramContext(diagram, collection, null);
        return new AstahCopyToClipboardCommand((EditingDomain)transactionalEditingDomain, diagramContext, collection);
    }

    protected boolean executeCommand(TransactionalEditingDomain transactionalEditingDomain, Command command) {
        if (command.canExecute()) {
            command.execute();
            return true;
        }
        return false;
    }

    private UMLDiagram a(NamedElement namedElement, UMLDiagram uMLDiagram) {
        CreateDiagramFromPrjCommand createDiagramFromPrjCommand = this.a(uMLDiagram);
        createDiagramFromPrjCommand.setOpenEditorAfterCreate(false);
        createDiagramFromPrjCommand.setUseTransaction(false);
        createDiagramFromPrjCommand.setParent(namedElement);
        this.callCommand(createDiagramFromPrjCommand);
        UMLDiagram uMLDiagram2 = (UMLDiagram)createDiagramFromPrjCommand.getDiagram();
        if (uMLDiagram2 != null) {
            uMLDiagram2.setName(this.a(namedElement, uMLDiagram.getName()));
            uMLDiagram2.setStyleMap(uMLDiagram.getStyleMap());
            Extensions.setDefinition(uMLDiagram2, Extensions.getDefinition(uMLDiagram));
            Hyperlinks.getHyperlinks(uMLDiagram).forEach(hyperlink -> HyperlinkUtil.createHyperlink(uMLDiagram2).setValue((Hyperlink)hyperlink));
            if (uMLDiagram2 instanceof UMLInteractionDiagram) {
                String string = ((UMLInteractionDiagram)uMLDiagram).getArgument();
                ((UMLInteractionDiagram)uMLDiagram2).setArgument(string);
            }
        }
        return uMLDiagram2;
    }

    public Diagram cloneDiagram(NamedElement namedElement, Diagram diagram) {
        if (diagram instanceof MMDiagram) {
            j j2 = new j(this);
            j2.setOpenEditorAfterCreate(false);
            j2.setUseTransaction(false);
            j2.setParent(namedElement);
            this.callCommand(j2);
            Diagram diagram2 = j2.getDiagram();
            if (diagram2 != null) {
                diagram2.setName(Strings.isNullOrEmpty(this.b) ? this.a(namedElement, diagram.getName()) : this.b);
                Extensions.setDefinition(diagram2, Extensions.getDefinition(diagram));
                if (Strings.isNullOrEmpty(this.b)) {
                    Hyperlinks.getHyperlinks(diagram).forEach(hyperlink -> HyperlinkUtil.createHyperlink(diagram2).setValue((Hyperlink)hyperlink));
                }
            }
            return diagram2;
        }
        return null;
    }

    public Diagram cloneDiagramFromOtherCommand(NamedElement namedElement, Diagram diagram) {
        return this.cloneDiagramFromOtherCommand(namedElement, diagram, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagram cloneDiagramFromOtherCommand(NamedElement namedElement, Diagram diagram, Collection<DiagramElement> collection) {
        Command command = this.a((EObject)diagram, collection);
        try {
            Diagram diagram2;
            if (!command.canExecute()) {
                Diagram diagram3 = null;
                return diagram3;
            }
            command.execute();
            Collection<?> collection2 = command.getResult();
            Diagram diagram4 = diagram2 = (Diagram)this.cloneModel(diagram, collection2);
            return diagram4;
        }
        finally {
            command.dispose();
        }
    }

    private String a(NamedElement namedElement, String string) {
        return this.assignUniqueName(string, DiagramOperations.getOwningDiagrams(namedElement).stream().map(Diagram::getName).collect(Collectors.toSet()));
    }

    protected String assignUniqueName(String string, Set<String> set) {
        int n2 = 0;
        String string2;
        while (set.contains(string2 = String.format("%s_%d", string, n2))) {
            ++n2;
        }
        return string2;
    }

    private CreateDiagramFromPrjCommand a(UMLDiagram uMLDiagram) {
        return (CreateDiagramFromPrjCommand)new k(this).doSwitch(uMLDiagram);
    }

    private boolean a(Diagram diagram, Pnt2d pnt2d) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(diagram);
        DiagramContext diagramContext = new DiagramContext(diagram, diagram.getOwnedElements(), pnt2d);
        EReference eReference = diagram instanceof UMLDiagram ? JmodelPackage.Literals.UML_DIAGRAM__PRESENTATIONS : DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT;
        AstahPasteFromClipboardCommand astahPasteFromClipboardCommand = new AstahPasteFromClipboardCommand((EditingDomain)transactionalEditingDomain, (Object)diagramContext, (Object)diagram, eReference, -1);
        return this.executeCommand(transactionalEditingDomain, astahPasteFromClipboardCommand);
    }

    private void a(Diagram diagram) {
        OpenDiagramEditorCommand openDiagramEditorCommand = new OpenDiagramEditorCommand();
        DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
        openDiagramEditorCommand.setDiagramViewInfo(diagramViewInfo);
        this.callCommand(openDiagramEditorCommand);
    }

    private EObject d() {
        return JomtGlobal.commandSupport.getSelectedModelElementFromProjectView();
    }

    public void setParent(NamedElement namedElement) {
        this.a = namedElement;
    }

    public void setCloneDiagramName(String string) {
        this.b = string;
    }
}

