/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.astah.dd.di.Diagram;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.CreateModelPresentationCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.uml2.uml.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeClassTypeCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ChangeClassTypeCommand.class);

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (iJomtEntityStore == null) {
            return;
        }
        Object[] objectArray = diagramEditor.getSelectedModels();
        UserObject userObject = (UserObject)objectArray[0];
        ClassifierPresentation classifierPresentation = (ClassifierPresentation)userObject.getPresentation();
        try {
            iJomtEntityStore.beginTransaction();
            int n2 = classifierPresentation.getClassType();
            if (n2 == 0) {
                classifierPresentation.setClassType(1);
                this.a(classifierPresentation);
                this.c(classifierPresentation);
                this.b(classifierPresentation);
            } else {
                classifierPresentation.setClassType(0);
                this.c(classifierPresentation);
                this.a(this.a(diagramEditor), classifierPresentation);
            }
            this.c(classifierPresentation);
            iJomtEntityStore.commitTransaction();
            while (diagramEditor.getEditingNode() != null) {
                CJomtTextNode cJomtTextNode = diagramEditor.getEditingNode();
                cJomtTextNode.setSelected(false);
            }
            diagramEditor.repaintCanvas();
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            iJomtEntityStore.abortTransaction();
        }
        catch (Exception exception) {
            iJomtEntityStore.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(ClassifierPresentation classifierPresentation) {
        EObject eObject = classifierPresentation.getModel();
        if (!(eObject instanceof Class)) {
            return;
        }
        Class clazz = (Class)eObject;
        for (Object object : classifierPresentation.getAllClients().toArray()) {
            if (!(object instanceof NoteAnchorPresentation)) continue;
            this.a(clazz, (NoteAnchorPresentation)object);
        }
    }

    private void a(Class clazz, NoteAnchorPresentation noteAnchorPresentation) {
        Element element = noteAnchorPresentation.getAnnotatedElement();
        if (element instanceof Property && clazz.getOwnedAttributes().contains(element) && ((Property)element).getAssociation() == null || element instanceof Operation && clazz.getOwnedOperations().contains(element)) {
            Presentations.removePresentation(noteAnchorPresentation);
        }
    }

    private void b(ClassifierPresentation classifierPresentation) {
        EObject eObject = classifierPresentation.getModel();
        if (!(eObject instanceof Class)) {
            return;
        }
        Class clazz = (Class)eObject;
        HashSet<Property> hashSet = this.a(clazz.getOwnedAttributes());
        this.a(hashSet, classifierPresentation.getLocation(), classifierPresentation);
    }

    private HashSet<Property> a(List<Property> list) {
        HashSet<Property> hashSet = new HashSet<Property>();
        for (Property property : list) {
            if (Properties.isPrimitiveType(property) || property instanceof Port || !property.isComposite()) continue;
            hashSet.add(property);
        }
        return hashSet;
    }

    private void a(UMLDiagram uMLDiagram, ClassifierPresentation classifierPresentation) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        Classifier classifier = (Classifier)classifierPresentation.getModel();
        arrayList.addAll(Properties.getParts(classifier));
        arrayList.addAll(Properties.getRoles(classifier));
        for (Property property : arrayList) {
            List<Presentation> list = Presentations.getPresentations(property);
            for (Presentation presentation : list) {
                if (!(presentation instanceof PartPresentation) || ((PartPresentation)presentation).getContainer() != classifierPresentation) continue;
                Presentations.removePresentation(presentation);
            }
        }
        this.a(classifierPresentation, uMLDiagram);
    }

    private List a(Set set, Pnt2d pnt2d, RectPresentation rectPresentation) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        CreateModelPresentationCommand createModelPresentationCommand = new CreateModelPresentationCommand();
        createModelPresentationCommand.setModels(set);
        createModelPresentationCommand.setDiagram(this.a(diagramEditor));
        createModelPresentationCommand.setLocation(pnt2d);
        createModelPresentationCommand.setContainer(rectPresentation);
        createModelPresentationCommand.setIsTransact(false);
        this.callCommand(createModelPresentationCommand);
        return createModelPresentationCommand.getPresentations();
    }

    private void c(ClassifierPresentation classifierPresentation) {
        double d2 = classifierPresentation.getDefaultHeight();
        double d3 = classifierPresentation.getDefaultWidth();
        classifierPresentation.setSize(d3, d2);
        classifierPresentation.resize();
    }

    private void a(JomtPresentation jomtPresentation, UMLDiagram uMLDiagram) {
        List<Presentation> list = jomtPresentation.getAllClients();
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (Presentation presentation : list) {
            if (presentation instanceof PortPresentation) {
                List<Presentation> list2 = presentation.getAllClients();
                for (Presentation presentation2 : list2) {
                    arrayList.add(presentation2);
                }
            }
            arrayList.add(presentation);
        }
        Presentations.removePresentations(arrayList);
    }

    private UMLDiagram a(DiagramEditor diagramEditor) {
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram instanceof UMLDiagram) {
            return (UMLDiagram)diagram;
        }
        return null;
    }
}

