/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jomt.jcontrol.DepthCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.operations.NoteAnchorPresentations;

public class ArrangeDepthCommand
extends Command {
    protected DiagramElement[] presentations;
    protected String arg;

    public void setPresentations(Presentation[] presentationArray) {
        this.presentations = presentationArray;
    }

    public DiagramElement[] getPresentations() {
        return this.presentations;
    }

    @Override
    public void execute() {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        Diagram diagram = null;
        try {
            Object object;
            DiagramEditor diagramEditor = null;
            if (this.presentations == null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.presentations = diagramEditor.getSelectedPresentations();
                diagram = diagramEditor.getDiagram();
                if (EObjects.isReadOnly(diagram)) {
                    JomtGlobal.modeManager.changeButtonsState(false);
                    return;
                }
            }
            if (this.presentations == null || this.presentations.length == 0) {
                JomtGlobal.modeManager.changeButtonsState(false);
                return;
            }
            if (this.presentations.length > 0) {
                this.presentations = NoteAnchorPresentations.setAssociationClassAnchor(this.presentations);
                for (int i2 = 0; i2 < this.presentations.length; ++i2) {
                    object = this.presentations[i2];
                    if (object == null) continue;
                    arrayList.add((DiagramElement)object);
                }
            }
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                iJomtEntityStore.beginTransaction();
                this.callDepthCommand(diagram, arrayList);
                iJomtEntityStore.commitTransaction();
                JomtGlobal.modeManager.changeButtonsState(false);
                object = JomtGlobal.viewManager.getCurrentDiagramEditor();
                if (object != null) {
                    ((DiagramEditor)object).getCanvas().requestFocus();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    @Override
    public void setArgumentString(String string) {
        this.arg = string;
    }

    protected void callDepthCommand(Diagram diagram, List<DiagramElement> list) {
        DepthCommand depthCommand = new DepthCommand();
        depthCommand.setArrangeDepth(this.arg);
        depthCommand.setPresentations(list);
        depthCommand.setDiagram(diagram);
        this.callCommand(depthCommand);
    }
}

