/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.CJomtTree;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class ApplyStereotypeCommand
extends Command {
    Stereotype a;
    Element b;
    private boolean c = false;

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            while (true) {
                if (this.b == null) {
                    this.b = this.getModel();
                }
                if (this.b == null || this.getStereotype() == null) {
                    return;
                }
                if (this.b.getAppliedStereotypes().contains(this.a)) {
                    MessageManager.displayAlertMessageDialog("app", "tell_stereotype_already_applied.message");
                    return;
                }
                try {
                    iJomtEntityStore.beginTransaction();
                    this.b.applyStereotype(this.a);
                    CJomtTree cJomtTree = JomtGlobal.viewManager.getProjectView().getStructureTree();
                    cJomtTree.setIsFromPrj(this.c);
                    if (this.a == this.b.getAppliedStereotypes().get(0)) {
                        // empty if block
                    }
                    iJomtEntityStore.commitTransaction();
                    cJomtTree.setIsFromPrj(false);
                }
                catch (UMLSemanticsException uMLSemanticsException) {
                    iJomtEntityStore.abortTransaction();
                    continue;
                }
                catch (BadTransactionException badTransactionException) {
                    MessageManager.requireBugReport(badTransactionException);
                    iJomtEntityStore.abortTransaction();
                }
                catch (Exception exception) {
                    iJomtEntityStore.abortTransaction();
                    throw exception;
                }
                break;
            }
            this.postCreating();
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected Element getModelOnDiagram() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Object[] objectArray = diagramEditor.getSelectedModels();
        if (objectArray == null || objectArray.length == 0 || !(objectArray[0] instanceof UserObject)) {
            return null;
        }
        if (objectArray.length > 1) {
            return null;
        }
        EObject eObject = ((UserObject)objectArray[0]).getModel();
        if (eObject == null) {
            return null;
        }
        if (eObject != null && eObject instanceof Element) {
            return (Element)eObject;
        }
        return null;
    }

    protected abstract Element getModel();

    protected void postCreating() {
    }

    public void setModel(Element element) {
        this.b = element;
    }

    public void setStereotype(Stereotype stereotype) {
        this.a = stereotype;
    }

    public Stereotype getStereotype() {
        return this.a;
    }
}

