/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.MindmapStyleTemplate;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMBranchEdge;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplyMindmapTemplateCommand
extends Command {
    private MMDiagram a;
    private int b = 0;
    private static final Logger c = LoggerFactory.getLogger(ApplyMindmapTemplateCommand.class);

    @Override
    public void setArgumentString(String string) {
        this.b = Integer.parseInt(string);
    }

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (this.a == null) {
                this.a = this.getDiagram();
            }
            if (this.a == null) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.a(this.a);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                this.b();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract MMDiagram getDiagram();

    private void a(MMDiagram mMDiagram) {
        String[] stringArray = MindMapUtilties.getMindMapProperty().getTemplateItems("mindmap_style.built_in.template");
        String string = this.a();
        if (!this.a(string)) {
            for (DiagramElement object : mMDiagram.getOwnedElements()) {
                if (!(object instanceof MMBranchEdge)) continue;
                MMStyleSupport.clearStyleMap(object);
            }
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = MindMapUtilties.getMindMapProperty().getStringWithDefault(string + "." + stringArray[i2]);
            MMStyleSupport.setValueForMindMapWithSetChanged(mMDiagram, stringArray[i2], string2);
        }
        this.a(mMDiagram.getRoot());
    }

    private boolean a(String string) {
        String string2 = MindMapUtilties.getMindMapProperty().getStringWithDefault(string + ".use_custom_color");
        return Boolean.valueOf(string2);
    }

    private String a() {
        return MindmapStyleTemplate.getAllTemplates().get(this.b).getKey();
    }

    private void a(MMTopicShape mMTopicShape) {
        for (MMTopicShape mMTopicShape2 : mMTopicShape.getChildren()) {
            mMTopicShape2.setManualLayout(false);
            this.a(mMTopicShape2);
        }
    }

    public void setDiagram(MMDiagram mMDiagram) {
        this.a = mMDiagram;
    }

    private void b() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null && this.a.equals(diagramEditor.getDiagram())) {
            diagramEditor.repaintCanvas();
        }
    }
}

