/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import java.util.Map;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;

public abstract class ApplyDiagramInitVisibilitiesCommand
extends Command {
    private Element a;

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore == null) {
            return;
        }
        EObject eObject = this.getTargetModel();
        if (eObject == null) {
            return;
        }
        if (!(eObject instanceof UMLDiagram)) {
            return;
        }
        UMLDiagram uMLDiagram = (UMLDiagram)eObject;
        Map<String, String> map = uMLDiagram.getStyleMap();
        List<Presentation> list = uMLDiagram.getPresentations();
        if (!this.isTargetDiagram(uMLDiagram)) {
            return;
        }
        try {
            if (this.useTransaction) {
                iJomtEntityStore.beginTransaction();
            }
            for (Presentation presentation : list) {
                this.setInitVisibilities(presentation, map);
            }
            if (this.useTransaction) {
                iJomtEntityStore.commitTransaction();
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            if (this.useTransaction) {
                iJomtEntityStore.commitTransaction();
            }
        }
        catch (Exception exception) {
            if (this.useTransaction) {
                iJomtEntityStore.commitTransaction();
            }
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract boolean isTargetModelTab(ModelTab var1);

    protected abstract boolean isTargetDiagram(UMLDiagram var1);

    protected abstract void setInitVisibilities(Presentation var1, Map<String, String> var2);

    protected EObject getTargetModel() {
        if (this.a != null) {
            return this.a;
        }
        ModelTab modelTab = this.getModelTab();
        if (this.isTargetModelTab(modelTab)) {
            return modelTab.getModel();
        }
        return null;
    }

    protected ModelTab getModelTab() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        if (propertyView == null) {
            return null;
        }
        ModelTab modelTab = propertyView.getModelPane().getCurrentModelTabGroup().getCurrentModelTab();
        return modelTab;
    }

    public void setTargetModel(Element element) {
        this.a = element;
    }
}

