/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.Collections;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.jmodel.JomtPresentation;
import net.astah.jomt.jcontrol.AlignCommand;

public class AlignVerticalEvenCommand
extends AlignCommand {
    @Override
    public void alignmentPresentations(List<DiagramElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        List<JomtPresentation> list2 = this.getIJomtPresentations(list);
        double d2 = this.getSpaceBetweenPresentations(list2);
        List<JomtPresentation> list3 = this.getSortedPresentations(list2);
        this.a(list3, d2);
    }

    public double getSpaceBetweenPresentations(List<JomtPresentation> list) {
        if (list == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        int n2 = 0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = 0.0;
        double d5 = 0.0;
        for (JomtPresentation jomtPresentation : list) {
            ++n2;
            Rectangle2d rectangle2d = jomtPresentation.getBoundsRect();
            if (rectangle2d.y < d2) {
                d2 = rectangle2d.y;
            }
            if (rectangle2d.y > d3) {
                d3 = rectangle2d.y;
                d5 = rectangle2d.height;
            }
            d4 += rectangle2d.height;
        }
        return (d3 - d2 + d5 - d4) / (double)(n2 - 1);
    }

    public List<JomtPresentation> getSortedPresentations(List<JomtPresentation> list) {
        if (list == null) {
            throw new IllegalArgumentException("sortedPresentation is null.");
        }
        Collections.sort(list, (jomtPresentation, jomtPresentation2) -> (int)Math.rint(jomtPresentation.getBoundsRect().y - jomtPresentation2.getBoundsRect().y));
        return list;
    }

    @Override
    protected boolean isDependenceOfVerticalSwimlane(List<DiagramElement> list) {
        return false;
    }

    private void a(List<JomtPresentation> list, double d2) {
        JomtPresentation jomtPresentation = list.get(0);
        for (int i2 = 1; i2 < list.size(); ++i2) {
            JomtPresentation jomtPresentation2 = list.get(i2);
            Rectangle2d rectangle2d = jomtPresentation2.getBoundsRect();
            Rectangle2d rectangle2d2 = jomtPresentation.getBoundsRect();
            double d3 = rectangle2d2.y + rectangle2d2.height + d2 - rectangle2d.y;
            Vec2d vec2d = new Vec2d(0.0, d3);
            this.movePresentation(jomtPresentation2, vec2d);
            jomtPresentation = jomtPresentation2;
            this.notifyRelatedModel(jomtPresentation2);
        }
        this.notifyRelatedModel(list.get(0));
    }

    @Override
    protected AlignLocationCommand.AlignKind getAlignKind() {
        return AlignLocationCommand.AlignKind.VERTICAL_SPACE_EVENLY;
    }
}

