/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.AlignCommand;
import net.astah.uml2.uml.util.PartitionUtil;

public class AlignTopCommand
extends AlignCommand {
    @Override
    protected void alignmentPresentations(List<DiagramElement> list) {
        double d2 = this.getMinYInUPresentations(list);
        for (DiagramElement diagramElement : list) {
            if (diagramElement == null || !(diagramElement instanceof JomtPresentation)) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)JomtPresentation.class.cast(diagramElement);
            Vec2d vec2d = new Vec2d(0.0, d2 - jomtPresentation.getBoundsRect().y);
            this.movePresentation(jomtPresentation, vec2d);
            this.notifyRelatedModel(jomtPresentation);
        }
    }

    public double getMinYInUPresentations(List<DiagramElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d2 = Double.MAX_VALUE;
        for (DiagramElement diagramElement : list) {
            if (diagramElement == null || !(diagramElement instanceof JomtPresentation)) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)JomtPresentation.class.cast(diagramElement);
            Rectangle2d rectangle2d = jomtPresentation.getBoundsRect();
            if (!(rectangle2d.y < d2)) continue;
            d2 = rectangle2d.y;
        }
        return d2;
    }

    @Override
    protected boolean isDependenceOfVerticalSwimlane(List<DiagramElement> list) {
        return false;
    }

    @Override
    protected List<ActivityPartitionPresentation> getNeccessarySwimlanes(UMLActivityDiagram uMLActivityDiagram) {
        return PartitionUtil.getSwimlanePss(uMLActivityDiagram, true);
    }

    @Override
    protected AlignLocationCommand.AlignKind getAlignKind() {
        return AlignLocationCommand.AlignKind.TOP;
    }
}

