/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.edit.command.SetSizeCommand;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ActionPresentation;
import net.astah.jmodel.CallBehaviorActionPresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ComponentPresentation;
import net.astah.jmodel.FinalStatePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InstanceSpecificationPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.NodePresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.ObjectNodePresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PinPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.StatePresentation;
import net.astah.jomt.jcontrol.d;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.VectorCustomeIconSpec;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.Shape;
import net.astah.notation.editor.IResizableViewElement;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlignSizeCommand
extends net.astah.golf.control.Command {
    private static final Logger a = LoggerFactory.getLogger(AlignSizeCommand.class);

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (iJomtEntityStore == null) {
                return;
            }
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            Diagram diagram = diagramEditor.getDiagram();
            if (MindMapUtilties.isMindMap(diagram)) {
                this.displayNoAdjustSizeElementMessage();
                return;
            }
            if (EObjects.isReadOnly(diagram)) {
                return;
            }
            List<DiagramElement> list = Arrays.asList(diagramEditor.getSelectedPresentations());
            List<Presentation> list2 = this.getResizingPresentations(list);
            List<Shape> list3 = this.a(diagramEditor);
            ArrayList<DiagramElement> arrayList = Lists.newArrayList(Iterables.filter(list, diagramElement -> list3.contains(diagramElement) || list2.contains(diagramElement)));
            if (arrayList.isEmpty()) {
                this.displayNoAdjustSizeElementMessage();
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.alignSize(arrayList);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred.", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
        }
    }

    protected void alignSize(List<DiagramElement> list) {
        this.alignPresentationSize(this.getResizingPresentations(list));
        this.alignShapeSize(Lists.newArrayList(Iterables.filter(list, Shape.class)));
    }

    private List<Shape> a(DiagramEditor diagramEditor) {
        List<GNode> list = diagramEditor.getSelectedViewElements();
        List list2 = list.stream().filter(gNode -> {
            Object object = gNode.getModel();
            if (!(gNode instanceof IResizableViewElement) || !(object instanceof Shape)) {
                return false;
            }
            IResizableViewElement iResizableViewElement = (IResizableViewElement)((Object)gNode);
            Shape shape = (Shape)object;
            Bounds bounds = shape.getBounds();
            for (int i2 = 0; i2 < 4; ++i2) {
                Pnt2d pnt2d = new Pnt2d();
                switch (i2) {
                    default: {
                        pnt2d.set(bounds.getX(), bounds.getY());
                        break;
                    }
                    case 1: {
                        pnt2d.set(bounds.getX(), bounds.getY() + bounds.getHeight());
                        break;
                    }
                    case 2: {
                        pnt2d.set(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
                        break;
                    }
                    case 3: {
                        pnt2d.set(bounds.getX() + bounds.getWidth(), bounds.getY());
                    }
                }
                if (iResizableViewElement.startResize(pnt2d, i2) != null) continue;
                return false;
            }
            return true;
        }).map(gNode -> (Shape)gNode.getModel()).collect(Collectors.toList());
        Iterable iterable = Iterables.filter(list2, shape -> !(shape.getOwningElement() instanceof Edge));
        if (Iterables.isEmpty(iterable)) {
            return Lists.newArrayList(list2);
        }
        return Lists.newArrayList(iterable);
    }

    protected abstract void alignPresentationSize(List<Presentation> var1);

    protected void alignShapeSize(List<Shape> list) {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        try {
            CommandUtils.execute(editingDomain, this.createSetShapeSizeCommand(list));
        }
        catch (InterruptedException | RollbackException exception) {
            exception.printStackTrace();
        }
    }

    protected double getMaxHeight(Collection<?> collection) {
        double d2 = 0.0;
        for (Object obj : collection) {
            if (obj instanceof RectPresentation) {
                RectPresentation rectPresentation = (RectPresentation)obj;
                d2 = Math.max(d2, rectPresentation.getHeight());
            }
            if (!(obj instanceof Shape)) continue;
            d2 = Math.max(d2, ((Shape)obj).getBounds().getHeight());
        }
        return d2;
    }

    protected double getMaxWidth(Collection<?> collection) {
        double d2 = 0.0;
        for (Object obj : collection) {
            if (obj instanceof RectPresentation) {
                RectPresentation rectPresentation = (RectPresentation)obj;
                d2 = Math.max(d2, rectPresentation.getWidth());
            }
            if (!(obj instanceof Shape)) continue;
            d2 = Math.max(d2, ((Shape)obj).getBounds().getWidth());
        }
        return d2;
    }

    protected List<Presentation> getResizingPresentations(List<DiagramElement> list) {
        RectPresentation rectPresentation;
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        ArrayList arrayList2 = new ArrayList();
        if (list == null) {
            return arrayList;
        }
        for (DiagramElement diagramElement : list) {
            if (diagramElement instanceof PinPresentation) continue;
            if (diagramElement instanceof ClassifierPresentation && !(diagramElement instanceof ComponentPresentation) && !(diagramElement instanceof NodePresentation) && !((ClassifierPresentation)diagramElement).isInterfaceAndInIconStatus() || diagramElement instanceof ActionPresentation) {
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof InstanceSpecificationPresentation) {
                rectPresentation = (InstanceSpecificationPresentation)diagramElement;
                if (rectPresentation.getNotationType() != 0) continue;
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof ObjectNodePresentation) {
                rectPresentation = (ObjectNodePresentation)diagramElement;
                if (rectPresentation.getNotationType() != 0) continue;
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof CallBehaviorActionPresentation) {
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof StatePresentation && !(diagramElement instanceof FinalStatePresentation)) {
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof ComponentPresentation) {
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (diagramElement instanceof PartPresentation) {
                arrayList.add((Presentation)diagramElement);
                continue;
            }
            if (!(diagramElement instanceof NotePresentation)) continue;
            arrayList.add((Presentation)diagramElement);
        }
        if (!arrayList.isEmpty()) {
            DiagramElement diagramElement;
            Iterator<DiagramElement> iterator = arrayList.iterator();
            diagramElement = (Presentation)iterator.next();
            if (diagramElement instanceof StatePresentation) {
                rectPresentation = (StatePresentation)diagramElement;
                Presentation presentation = this.a((StatePresentation)rectPresentation);
                while (iterator.hasNext()) {
                    DiagramElement diagramElement2 = iterator.next();
                    if (diagramElement2 instanceof NotePresentation) continue;
                    if (!(diagramElement2 instanceof StatePresentation)) {
                        arrayList.clear();
                    } else {
                        StatePresentation statePresentation = (StatePresentation)diagramElement2;
                        Presentation presentation2 = this.a(statePresentation);
                        if (presentation == null && presentation2 == null || !(presentation == null && presentation2 != null || presentation != null && presentation2 == null) && presentation2.equals(presentation)) continue;
                        arrayList.clear();
                    }
                    break;
                }
            } else if (diagramElement instanceof ClassifierPresentation || diagramElement instanceof PartPresentation) {
                rectPresentation = this.a(diagramElement);
                while (iterator.hasNext()) {
                    DiagramElement diagramElement3 = iterator.next();
                    if (diagramElement3 instanceof NotePresentation) continue;
                    if (!(diagramElement3 instanceof ClassifierPresentation) && !(diagramElement3 instanceof PartPresentation)) {
                        arrayList.clear();
                    } else {
                        RectPresentation rectPresentation2 = this.a(diagramElement3);
                        if (rectPresentation == null && rectPresentation2 == null || !(rectPresentation == null && rectPresentation2 != null || rectPresentation != null && rectPresentation2 == null) && rectPresentation2.equals(rectPresentation)) continue;
                        arrayList.clear();
                    }
                    break;
                }
            }
        }
        arrayList.removeAll(arrayList2);
        return arrayList;
    }

    private RectPresentation a(Object object) {
        PresentationContainer presentationContainer = null;
        if (object instanceof ClassifierPresentation || object instanceof PartPresentation) {
            JomtPresentation jomtPresentation = (JomtPresentation)object;
            PresentationContainer presentationContainer2 = jomtPresentation.getContainer();
            presentationContainer = presentationContainer2 == null ? null : presentationContainer2;
        }
        return presentationContainer;
    }

    Presentation a(StatePresentation statePresentation) {
        if (statePresentation == null) {
            throw new IllegalArgumentException("statePresentation is null.");
        }
        EObject eObject = statePresentation.getModel();
        if (eObject == null) {
            return null;
        }
        return (Presentation)new d(this).doSwitch(eObject);
    }

    protected boolean isFixedAspectRatio(Presentation presentation) {
        String string;
        VectorCustomeIconSpec vectorCustomeIconSpec;
        return presentation instanceof ActionPresentation && (vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(string = ((ActionPresentation)presentation).getStereotype())) != null && vectorCustomeIconSpec.isfixedAspectRatio();
    }

    protected void displayNoAdjustSizeElementMessage() {
        MessageManager.displayConfirmMessageDialog("app", "confirm_adjust_size.message");
    }

    protected Dimension getAlignDimension(Shape shape, List<Shape> list) {
        return DCFactory.eINSTANCE.createDimension(this.getAlignWidth(shape, list), this.getAlignHeight(shape, list));
    }

    protected double getAlignWidth(Shape shape, List<Shape> list) {
        return shape.getBounds().getWidth();
    }

    protected double getAlignHeight(Shape shape, List<Shape> list) {
        return shape.getBounds().getHeight();
    }

    protected Command createSetShapeSizeCommand(List<Shape> list) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Shape shape : list) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(shape);
            compoundCommand.append(SetSizeCommand.create(transactionalEditingDomain, null, shape, this.getAlignDimension(shape, list)));
        }
        return compoundCommand.unwrap();
    }
}

