/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.jmodel.JomtPresentation;
import net.astah.jomt.jcontrol.AlignVerticalCommand;

public class AlignRightCommand
extends AlignVerticalCommand {
    @Override
    protected double getDatumX(List<JomtPresentation> list) {
        return this.getRightX(list);
    }

    public double getRightX(List<JomtPresentation> list) {
        if (list == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d2 = Double.NEGATIVE_INFINITY;
        for (JomtPresentation jomtPresentation : list) {
            Rectangle2d rectangle2d = jomtPresentation.getBoundsRect();
            if (!(rectangle2d.x + rectangle2d.width > d2)) continue;
            d2 = rectangle2d.x + rectangle2d.width;
        }
        return d2;
    }

    @Override
    protected Vec2d getMoveVector(JomtPresentation jomtPresentation, double d2) {
        return new Vec2d(d2 - jomtPresentation.getBoundsRect().x - jomtPresentation.getBoundsRect().width, 0.0);
    }

    @Override
    protected AlignLocationCommand.AlignKind getAlignKind() {
        return AlignLocationCommand.AlignKind.RIGHT;
    }
}

