/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.AlignCommand;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.uml2.uml.util.PartitionUtil;

public class AlignHorizontalCenterCommand
extends AlignCommand {
    public double getCenterY(List<DiagramElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        return DiagramElementOperations.getBoundsRect(list, true).getCenterY();
    }

    @Override
    protected void alignmentPresentations(List<DiagramElement> list) {
        double d2 = this.getCenterY(list);
        for (DiagramElement diagramElement : list) {
            if (diagramElement == null || !(diagramElement instanceof JomtPresentation)) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)JomtPresentation.class.cast(diagramElement);
            Rectangle2d rectangle2d = jomtPresentation.getBoundsRect();
            double d3 = rectangle2d.height;
            double d4 = d2 - d3 / 2.0 - rectangle2d.y;
            Vec2d vec2d = new Vec2d(0.0, d4);
            this.movePresentation(jomtPresentation, vec2d);
            this.notifyRelatedModel(jomtPresentation);
        }
    }

    @Override
    protected boolean isDependenceOfVerticalSwimlane(List<DiagramElement> list) {
        return false;
    }

    @Override
    protected List<ActivityPartitionPresentation> getNeccessarySwimlanes(UMLActivityDiagram uMLActivityDiagram) {
        return PartitionUtil.getSwimlanePss(uMLActivityDiagram, true);
    }

    @Override
    protected AlignLocationCommand.AlignKind getAlignKind() {
        return AlignLocationCommand.AlignKind.HORIZONTAL_CENTER;
    }
}

