/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.ObjectNodePresentation;
import net.astah.jmodel.PinPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.c;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.CastUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.uml.ActivityPartition;

public abstract class AlignCommand
extends net.astah.golf.control.Command {
    protected DiagramElement[] selectedPs = null;
    protected Diagram diagram = null;

    public void setPresentations(Presentation[] presentationArray) {
        this.selectedPs = presentationArray;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.selectedPs == null) {
                object = JomtGlobal.viewManager.getCurrentDiagramEditor();
                if (object == null) {
                    return;
                }
                this.diagram = ((DiagramEditor)object).getDiagram();
                if (EObjects.isReadOnly(this.diagram)) {
                    return;
                }
                this.selectedPs = ((DiagramEditor)object).getSelectedPresentations();
            }
            if (this.selectedPs == null || this.selectedPs.length == 0 || this.getLayoutTargetDiagramViewElementsCount() < 2) {
                return;
            }
            this.g();
            this.f();
            this.c();
            this.d();
            this.e();
            object = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                object.beginTransaction();
                if (this.selectedPs[0] instanceof Presentation) {
                    this.alignmentPresentations();
                } else {
                    this.a();
                }
                object.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                object.abortTransaction();
            }
            catch (Exception exception) {
                object.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a() throws InterruptedException, RollbackException {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        CommandUtils.execute(editingDomain, this.createAlginLocationCommand());
    }

    protected Command createAlginLocationCommand() {
        CompoundCommand compoundCommand = new CompoundCommand();
        List<Shape> list = this.getLayoutTargetShapes();
        boolean bl = list.stream().allMatch(shape -> shape.getOwningElement() instanceof Edge);
        for (Shape shape2 : this.getLayoutTargetShapes()) {
            DiagramElement diagramElement = shape2.getOwningElement();
            if (diagramElement instanceof Edge && !bl) continue;
            DiagramContext diagramContext = new DiagramContext(this.diagram, this.getLayoutTargetShapes(), null, diagramElement);
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(shape2);
            compoundCommand.append(AlignLocationCommand.create((EditingDomain)transactionalEditingDomain, (Object)diagramContext, (Object)shape2, null, this.getAlignKind()));
        }
        return compoundCommand.unwrap();
    }

    public void alignmentPresentations() {
        List<List<DiagramElement>> list = this.getPresentationLists();
        for (List<DiagramElement> list2 : list) {
            if (list2 == null || list2.isEmpty()) continue;
            this.alignmentPresentations(list2);
            this.a(list2);
            this.b(list2);
        }
    }

    private void a(List<DiagramElement> list) {
        Presentation presentation;
        ActivityPartitionPresentation activityPartitionPresentation;
        if (this.isDependenceOfVerticalSwimlane(list) && (activityPartitionPresentation = this.getVerticalSwimLanePresentation(presentation = (Presentation)list.get(0))) != null) {
            this.a(list, activityPartitionPresentation);
        }
        if (this.isDependenceOfHorizontalSwimlane(list) && (activityPartitionPresentation = this.getHorizontalSwimLanePresentation(presentation = (Presentation)list.get(0))) != null) {
            this.b(list, activityPartitionPresentation);
        }
    }

    private void a(List<DiagramElement> list, ActivityPartitionPresentation activityPartitionPresentation) {
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        double d2 = pnt2d.x;
        double d3 = pnt2d.x + activityPartitionPresentation.getWidth();
        for (DiagramElement diagramElement : Iterables.filter(list, Presentation.class)) {
            if (!(diagramElement instanceof RectPresentation) || diagramElement instanceof ObjectNodePresentation) continue;
            this.b(d2, d3, (RectPresentation)diagramElement);
        }
    }

    private void b(List<DiagramElement> list, ActivityPartitionPresentation activityPartitionPresentation) {
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        double d2 = pnt2d.y;
        double d3 = pnt2d.y + activityPartitionPresentation.getSpan();
        for (DiagramElement diagramElement : Iterables.filter(list, Presentation.class)) {
            if (!(diagramElement instanceof RectPresentation) || diagramElement instanceof ObjectNodePresentation) continue;
            this.a(d2, d3, (RectPresentation)diagramElement);
        }
    }

    private void a(double d2, double d3, RectPresentation rectPresentation) {
        Pnt2d pnt2d = rectPresentation.getLocation();
        if (pnt2d.y < d2) {
            pnt2d.y = d2;
            rectPresentation.setLocation(pnt2d);
        } else if (pnt2d.y + rectPresentation.getHeight() > d3) {
            pnt2d.y = d3 - rectPresentation.getHeight();
            rectPresentation.setLocation(pnt2d);
        }
    }

    private void b(double d2, double d3, RectPresentation rectPresentation) {
        Pnt2d pnt2d = rectPresentation.getLocation();
        if (pnt2d.x < d2) {
            pnt2d.x = d2;
            rectPresentation.setLocation(pnt2d);
        } else if (pnt2d.x + rectPresentation.getWidth() > d3) {
            pnt2d.x = d3 - rectPresentation.getWidth();
            rectPresentation.setLocation(pnt2d);
        }
    }

    private void b(List<DiagramElement> list) {
        for (DiagramElement diagramElement : Iterables.filter(list, Presentation.class)) {
            if (!(diagramElement instanceof LabelPresentation)) continue;
            LabelPresentation labelPresentation = (LabelPresentation)diagramElement;
            labelPresentation.resize();
        }
    }

    protected abstract void alignmentPresentations(List<DiagramElement> var1);

    protected abstract AlignLocationCommand.AlignKind getAlignKind();

    protected boolean isDependenceOfVerticalSwimlane(List<DiagramElement> list) {
        for (DiagramElement diagramElement : list) {
            if (!(diagramElement instanceof RectPresentation) || this.getVerticalSwimLanePresentation((RectPresentation)diagramElement) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isDependenceOfHorizontalSwimlane(List<DiagramElement> list) {
        for (DiagramElement diagramElement : list) {
            if (!(diagramElement instanceof RectPresentation) || this.getHorizontalSwimLanePresentation((RectPresentation)diagramElement) == null) continue;
            return true;
        }
        return false;
    }

    public int getLayoutTargetDiagramViewElementsCount() {
        return this.getLayoutTargetPresentations().size() + this.getLayoutTargetShapes().size();
    }

    public List<DiagramElement> getLayoutTargetPresentations() {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        Iterable<Presentation> iterable = Iterables.filter(this.b(), Presentation.class);
        for (Presentation presentation : iterable) {
            if (!this.isLayoutTarget(presentation) || presentation instanceof ClassifierPresentation && this.a(arrayList, (ClassifierPresentation)presentation)) continue;
            arrayList.add(presentation);
        }
        return arrayList;
    }

    public List<Shape> getLayoutTargetShapes() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (DiagramElement diagramElement : this.selectedPs) {
            if (!(diagramElement instanceof Shape)) continue;
            arrayList.add((Shape)diagramElement);
        }
        return arrayList;
    }

    private boolean a(List<DiagramElement> list, ClassifierPresentation classifierPresentation) {
        if (classifierPresentation.isInterfaceAndInIconStatus()) {
            for (Presentation presentation : classifierPresentation.getPartner()) {
                if (!list.contains(presentation)) continue;
                return true;
            }
        }
        return false;
    }

    private List<DiagramElement> b() {
        List<DiagramElement> list = null;
        if (this.selectedPs.length == 1 && this.selectedPs[0] instanceof ActivityPartitionPresentation) {
            ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)this.selectedPs[0];
            list = activityPartitionPresentation.getContents();
        } else {
            list = Arrays.asList(this.selectedPs);
        }
        return (List)CastUtil.automaticCast(list);
    }

    protected boolean isLayoutTarget(Presentation presentation) {
        return Presentations.isLayoutTarget(presentation);
    }

    protected void notifyRelatedModel(Presentation presentation) {
    }

    private void c() {
        List<DiagramElement> list = Arrays.asList(this.selectedPs);
        Iterable<Presentation> iterable = Iterables.filter(list, Presentation.class);
        ArrayList<Presentation> arrayList = Lists.newArrayList(iterable);
        List<JomtPresentation> list2 = this.getNonChildPresentations(arrayList);
        int n2 = list2.size();
        if (n2 > 0) {
            this.selectedPs = list2.toArray(new Presentation[n2]);
        }
    }

    private void d() {
        List<DiagramElement> list = Arrays.asList(this.selectedPs);
        Iterable<Shape> iterable = Iterables.filter(list, Shape.class);
        ArrayList<Shape> arrayList = Lists.newArrayList(iterable);
        List<Shape> list2 = this.getNonChildShapes(arrayList);
        int n2 = list2.size();
        if (n2 > 0) {
            this.selectedPs = list2.toArray(new Shape[n2]);
        }
    }

    private void e() {
        List<DiagramElement> list = Arrays.asList(this.selectedPs);
        Iterable<DiagramElement> iterable = Iterables.filter(list, DiagramElement.class);
        ArrayList<DiagramElement> arrayList = Lists.newArrayList(iterable);
        List<DiagramElement> list2 = this.c(arrayList);
        int n2 = list2.size();
        if (n2 > 0) {
            this.selectedPs = list2.toArray(new DiagramElement[n2]);
        }
    }

    private List<DiagramElement> c(List<DiagramElement> list) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (DiagramElement diagramElement : list) {
            if (diagramElement instanceof FramePresentation) continue;
            arrayList.add(diagramElement);
        }
        return arrayList;
    }

    protected List<JomtPresentation> getNonChildPresentations(List<Presentation> list) {
        Predicate<Presentation> predicate = presentation -> this.a((Presentation)presentation);
        Stream<Presentation> stream = list.stream().filter(predicate);
        List list2 = stream.collect(Collectors.toList());
        return (List)CastUtil.automaticCast(list2);
    }

    protected List<Shape> getNonChildShapes(List<Shape> list) {
        Predicate<Shape> predicate = shape -> this.a((Shape)shape);
        Stream<Shape> stream = list.stream().filter(predicate);
        List list2 = stream.collect(Collectors.toList());
        return (List)CastUtil.automaticCast(list2);
    }

    private boolean a(Shape shape) {
        DiagramElement diagramElement = shape.getOwningElement();
        return diagramElement instanceof Diagram;
    }

    private boolean a(Presentation presentation) {
        Boolean bl = (Boolean)new c(this).doSwitch(presentation);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    protected ActivityPartitionPresentation getVerticalSwimLanePresentation(Presentation presentation) {
        UMLActivityDiagram uMLActivityDiagram;
        ActivityPartition activityPartition;
        if (presentation != null && presentation.getDiagram() instanceof UMLActivityDiagram && (activityPartition = PartitionUtil.getMyPartition(uMLActivityDiagram = (UMLActivityDiagram)presentation.getDiagram(), presentation.getModel(), false)) != null) {
            return (ActivityPartitionPresentation)Presentations.getPresentation(activityPartition);
        }
        return null;
    }

    protected ActivityPartitionPresentation getHorizontalSwimLanePresentation(Presentation presentation) {
        UMLActivityDiagram uMLActivityDiagram;
        ActivityPartition activityPartition;
        if (presentation != null && presentation.getDiagram() instanceof UMLActivityDiagram && (activityPartition = PartitionUtil.getMyPartition(uMLActivityDiagram = (UMLActivityDiagram)presentation.getDiagram(), presentation.getModel(), true)) != null) {
            return (ActivityPartitionPresentation)Presentations.getPresentation(activityPartition);
        }
        return null;
    }

    protected List<List<DiagramElement>> getPresentationLists() {
        ArrayList<List<DiagramElement>> arrayList = new ArrayList<List<DiagramElement>>();
        List<DiagramElement> list = this.getLayoutTargetPresentations();
        if (!this.isDependenceOfVerticalSwimlane(list) && !this.isDependenceOfHorizontalSwimlane(list)) {
            arrayList.add(list);
            return arrayList;
        }
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram instanceof UMLActivityDiagram) {
            List<ActivityPartitionPresentation> list2 = this.getNeccessarySwimlanes((UMLActivityDiagram)diagram);
            for (ActivityPartitionPresentation activityPartitionPresentation : list2) {
                List<RectPresentation> list3 = activityPartitionPresentation.getContents();
                List list4 = this.a(list3, list);
                arrayList.add(list4);
                list.removeAll(list4);
            }
            arrayList.add(list);
        } else {
            arrayList.add(list);
        }
        return arrayList;
    }

    protected List<ActivityPartitionPresentation> getNeccessarySwimlanes(UMLActivityDiagram uMLActivityDiagram) {
        return PartitionUtil.getSwimlanePs(uMLActivityDiagram);
    }

    private List a(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        for (Object e2 : list2) {
            if (!list.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    private void f() {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(this.selectedPs));
        for (DiagramElement diagramElement : this.selectedPs) {
            if (!(diagramElement instanceof PortPresentation) && !(diagramElement instanceof PinPresentation)) continue;
            arrayList.remove(diagramElement);
        }
        this.selectedPs = arrayList.toArray(new DiagramElement[0]);
    }

    private void g() {
        List<DiagramElement> list = Arrays.asList(this.selectedPs);
        List<DiagramElement> list2 = this.getNoneMindMapPresentations(list);
        this.selectedPs = list2.toArray(new DiagramElement[list2.size()]);
    }

    protected List<DiagramElement> getNoneMindMapPresentations(List<DiagramElement> list) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (DiagramElement diagramElement : list) {
            if (diagramElement instanceof MMDiagramElement) continue;
            arrayList.add(diagramElement);
        }
        return arrayList;
    }

    protected void movePresentation(JomtPresentation jomtPresentation, Vec2d vec2d) {
        if (this.isTargetLabelPresentation(jomtPresentation)) {
            double d2 = jomtPresentation.getLocalMovement().x + vec2d.x;
            double d3 = jomtPresentation.getLocalMovement().y + vec2d.y;
            jomtPresentation.setLocalMovement(new Vec2d(d2, d3));
        } else {
            jomtPresentation.move(vec2d);
        }
    }

    protected boolean isTargetLabelPresentation(JomtPresentation jomtPresentation) {
        Presentation presentation;
        return jomtPresentation instanceof LabelPresentation && (presentation = ((LabelPresentation)jomtPresentation).getCompositeParent()) instanceof PortPresentation;
    }

    protected List<JomtPresentation> getIJomtPresentations(List<DiagramElement> list) {
        ArrayList<Presentation> arrayList = Lists.newArrayList(Iterables.filter(list, Presentation.class));
        Predicate<Presentation> predicate = presentation -> presentation instanceof JomtPresentation;
        Stream<Presentation> stream = arrayList.stream().filter(predicate);
        List list2 = stream.collect(Collectors.toList());
        return (List)CastUtil.automaticCast(list2);
    }
}

