/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.PathPresentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.MoveCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class AdjustSpaceCommand
extends Command {
    protected UMLDiagram diagram;
    protected Pnt2d startPnt;
    protected Vec2d moveVec;
    protected Collection<JomtPresentation> targets;
    protected Map<PathPresentation, Pnt2d[]> pathPoints;
    protected boolean isShiftPressed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            DiagramEditor diagramEditor;
            Project project = ModelGlobal.prjManager.getCurrentProject();
            if (project == null) {
                return;
            }
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (this.diagram == null && JomtGlobal.viewManager != null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.diagram = (UMLDiagram)diagramEditor.getDiagram();
            }
            if (this.diagram == null) {
                return;
            }
            if (this.startPnt == null || this.moveVec == null || this.targets == null) {
                return;
            }
            this.targets = this.adjustTargets(this.targets, this.moveVec);
            if (!this.isValidTargets(this.targets)) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.adjustSpace();
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(badTransactionException);
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(exception);
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        finally {
            if (JomtGlobal.modeManager != null) {
                JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
            }
        }
    }

    protected boolean isValidTargets(Collection<JomtPresentation> collection) {
        return !collection.isEmpty();
    }

    protected void adjustSpace() {
        this.moveNormalPresentations(this.targets, this.moveVec);
        this.adjustPathPresentations(this.targets);
    }

    protected void moveNormalPresentations(Collection<JomtPresentation> collection, Vec2d vec2d) {
        MoveCommand moveCommand = new MoveCommand();
        moveCommand.setPresentations(collection.toArray(new JomtPresentation[0]));
        moveCommand.setMoveVector(vec2d);
        moveCommand.setUseTransaction(false);
        this.callCommand(moveCommand);
    }

    protected List<JomtPresentation> adjustTargets(Collection<JomtPresentation> collection, Vec2d vec2d) {
        ArrayList<JomtPresentation> arrayList = new ArrayList<JomtPresentation>();
        arrayList.addAll(collection);
        return arrayList;
    }

    protected void adjustPathPresentations(Collection<JomtPresentation> collection) {
        for (PathPresentation pathPresentation : this.pathPoints.keySet()) {
            if (collection.contains(pathPresentation)) continue;
            Pnt2d[] pnt2dArray = this.pathPoints.get(pathPresentation);
            Pnt2d[] pnt2dArray2 = new Pnt2d[pnt2dArray.length - 2];
            System.arraycopy(pnt2dArray, 1, pnt2dArray2, 0, pnt2dArray2.length);
            pathPresentation.getPoints().clear();
            pathPresentation.getPoints().addAll(Arrays.asList(pnt2dArray2));
        }
    }

    protected Rectangle2d getBoundsRect(JomtPresentation jomtPresentation) {
        return jomtPresentation.getBoundsRect();
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.diagram = uMLDiagram;
    }

    public void setStartPnt(Pnt2d pnt2d) {
        this.startPnt = pnt2d;
    }

    public void setMoveVector(Vec2d vec2d) {
        this.moveVec = vec2d;
    }

    public void setTargets(Collection<JomtPresentation> collection) {
        this.targets = collection;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    public void setPathPoints(Map<PathPresentation, Pnt2d[]> map) {
        this.pathPoints = map;
    }
}

