/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.AssociationPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.Defaults;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.operations.AssociationPresentations;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.VisibilityKind;

public class AddQualifierCommand
extends Command {
    private Property a = null;
    private String b = null;
    private Classifier c = null;

    @Override
    public void execute() {
        try {
            if (this.a == null) {
                this.a = this.getAssociationEnd();
                if (this.a == null) {
                    return;
                }
            }
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                iJomtEntityStore.beginTransaction();
                this.addQualifier(iJomtEntityStore);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public Property addQualifier(IEntityStore iEntityStore) {
        if (this.b == null) {
            this.b = "key" + ModelGlobal.prjManager.getCurrentProject().attributeNum++;
        }
        if (this.c == null) {
            this.c = Defaults.getAttrDefType();
        }
        Property property = this.a.createQualifier(this.b, this.c);
        property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        return property;
    }

    protected Property getAssociationEnd() {
        return this.getAssociationEndFromDiagram();
    }

    public void setAssociationEnd(Property property) {
        this.a = property;
    }

    public void setName(String string) {
        this.b = string;
    }

    public void setType(Classifier classifier) {
        this.c = classifier;
    }

    protected Property getAssociationEndFromDiagram() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Object[] objectArray = diagramEditor.getSelectedModels();
        if (objectArray.length != 1) {
            return null;
        }
        Presentation presentation = ((UserObject)objectArray[0]).getPresentation();
        GCamera gCamera = diagramEditor.getCamera();
        double d2 = gCamera.toWorldCoordX(this.getPoint().x);
        double d3 = gCamera.toWorldCoordY(this.getPoint().y);
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        AssociationPresentation associationPresentation = null;
        Association association = null;
        if (!(presentation instanceof AssociationPresentation)) {
            return null;
        }
        associationPresentation = (AssociationPresentation)presentation;
        association = (Association)associationPresentation.getModel();
        Pnt2d[] pnt2dArray = associationPresentation.getOuterPoints().toArray(new Pnt2d[0]);
        if (pnt2dArray == null || pnt2dArray.length == 0) {
            pnt2dArray = associationPresentation.getAllPoints().toArray(new Pnt2d[0]);
        }
        Property property = AssociationPresentations.getAssociationEnd(association, pnt2d, pnt2dArray);
        return property;
    }
}

