/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.io.File;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.CImageIcon;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.mindmap.MMUserIconInfo;
import net.astah.uml.mindmap.MMUserIconManager;
import net.astah.uml.mindmap.UserIcon;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AddMMUserIconCommand
extends Command {
    private UserIcon a;

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            CFileChooser cFileChooser = this.a();
            if (!cFileChooser.isApproveOpenDialog()) {
                return;
            }
            File file = cFileChooser.getSelectedFile();
            JomtGlobal.setFileDir(file.getParent());
            if (!file.canRead()) {
                MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                return;
            }
            CImageIcon cImageIcon = this.a(file);
            if (cImageIcon == null) {
                MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.a = new UserIcon(EcoreUtil.generateUUID());
                MMUserIconInfo mMUserIconInfo = MMUserIconManager.instance().getSystemUserIconInfo();
                mMUserIconInfo.addUserIcon(this.a);
                String string = file.getAbsolutePath();
                this.a.setIcon(string);
                MMUserIconManager.instance().writeProjectUserIconInfo(iJomtEntityStore);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iJomtEntityStore.abortTransaction();
                MMUserIconInfo mMUserIconInfo = MMUserIconManager.instance().getSystemUserIconInfo();
                mMUserIconInfo.removeUserIcon(this.a);
                MessageManager.displayErrorMessage("app", "could_not_open_by_java_bug.message");
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private CImageIcon a(File file) {
        CImageIcon cImageIcon = null;
        String string = file.getAbsolutePath().toLowerCase();
        if (string.endsWith("jpg") || string.endsWith("jpeg") || string.endsWith("gif") || string.endsWith("png")) {
            cImageIcon = JomtWidgetFactory.instance().createImageIcon(file.getAbsolutePath());
        }
        return cImageIcon;
    }

    private CFileChooser a() {
        String string = JomtGlobal.getFileDir();
        CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Open Dialog");
        cFileChooser.addChoosableFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Compressed Image Files");
        cFileChooser.addChoosableFileFilter("gif", "GIF Image Files");
        cFileChooser.addChoosableFileFilter("png", "PNG Image Files");
        cFileChooser.setFileFilter(new String[]{"jpg", "jpeg", "gif", "png"}, "Supported Image Files");
        return cFileChooser;
    }
}

