/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.astah.emf.common.util.LogUtil;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.DependencyPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.StereotypeUtil;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.AddRelatedPsForClassifierMethod;
import net.astah.jomt.jcontrol.ClassifierFactory;
import net.astah.jomt.jcontrol.CreatePartnerCommand;
import net.astah.jomt.jcontrol.SelectNewPresentations;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Associations;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.NamedElements;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UseCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;

@Keep
public class AddDependedPresentationsCommand
extends Command {
    private LabelPresentation a = null;
    protected UMLDiagram diagram = null;
    private static final Logger b = LoggerFactory.getLogger(AddDependedPresentationsCommand.class);

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (this.diagram == null) {
                this.diagram = (UMLDiagram)diagramEditor.getDiagram();
            }
            if (this.a == null) {
                this.a = this.a();
            }
            if (this.a == null) {
                return;
            }
            ArrayList<Element> arrayList = new ArrayList<Element>();
            EObject eObject = this.a.getModel();
            if (!(eObject instanceof Element)) {
                return;
            }
            Element element = (Element)eObject;
            arrayList.add(element);
            this.callStaticMethodOfaddDependedModels(this.diagram, arrayList);
            this.removeInvalidModels(this.diagram, arrayList);
            SelectNewPresentations selectNewPresentations = new SelectNewPresentations();
            selectNewPresentations.storeCurrentSelections();
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                AddRelatedPsForClassifierMethod addRelatedPsForClassifierMethod = this.getAddRelatedPsForClassifierMethod(this.diagram, element, this.a);
                List<Presentation> list = addRelatedPsForClassifierMethod.addDependedPresentation();
                list.add(this.a);
                if (!arrayList.isEmpty()) {
                    List list2 = AddDependedPresentationsCommand.addPresentations(iJomtEntityStore, this.diagram, arrayList, this.a);
                    list2.addAll(list);
                    AddDependedPresentationsCommand.resizeAll(list2);
                    this.alignmentAll(this.a, list2);
                    this.callStaticMethodOfaddRelationPresentations(list2, this.diagram);
                    this.resetForInterface(this.diagram);
                } else {
                    AddDependedPresentationsCommand.resizeAll(list);
                    this.alignmentAll(this.a, list);
                    this.callStaticMethodOfaddRelationPresentations(list, this.diagram);
                    this.resetForInterface(this.diagram);
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                this.postShowing();
                diagramEditor.unselect();
                selectNewPresentations.updateSelections();
                diagramEditor.repaintCanvas();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected AddRelatedPsForClassifierMethod getAddRelatedPsForClassifierMethod(UMLDiagram uMLDiagram, Element element, LabelPresentation labelPresentation) {
        return new AddRelatedPsForClassifierMethod(uMLDiagram, element, labelPresentation);
    }

    protected void removeInvalidModels(UMLDiagram uMLDiagram, List list) {
        AddDependedPresentationsCommand.removeNontargetModels(uMLDiagram, list);
        this.removeExistedModels(uMLDiagram, list);
        this.removeInvalidatePorts(uMLDiagram, list);
    }

    protected void resetForInterface(UMLDiagram uMLDiagram) {
        List<Presentation> list = uMLDiagram.getPresentations();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Presentation presentation = list.get(i2);
            if (!StereotypeUtil.isInterface(presentation.getModel()) || !(presentation instanceof ClassifierPresentation)) continue;
            ClassifierPresentation classifierPresentation = (ClassifierPresentation)presentation;
            if (classifierPresentation.needCreatePartner()) {
                this.a(classifierPresentation);
                classifierPresentation.dispatchRelationsForInterface();
                continue;
            }
            if (!classifierPresentation.containsUsage() || classifierPresentation.getNotationType() != 1) continue;
            classifierPresentation.setNotationType(3);
        }
    }

    private ClassifierPresentation a(ClassifierPresentation classifierPresentation) {
        UMLDiagram uMLDiagram = (UMLDiagram)JomtGlobal.viewManager.getCurrentDiagramEditor().getDiagram();
        CreatePartnerCommand createPartnerCommand = new CreatePartnerCommand();
        createPartnerCommand.setDgm(uMLDiagram);
        createPartnerCommand.setInterfacePs(classifierPresentation);
        DependencyPresentation dependencyPresentation = classifierPresentation.getFirstDependency();
        if (dependencyPresentation == null) {
            dependencyPresentation = classifierPresentation.getFirstUsage();
        }
        createPartnerCommand.setRelationPs(dependencyPresentation);
        this.callCommand(createPartnerCommand);
        return (ClassifierPresentation)createPartnerCommand.getCreatedPartner().get(0);
    }

    protected void postShowing() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        List<GNode> list = diagramEditor.getCanvas().getSelectedNodes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!(list.get(i2) instanceof CJomtTextNode)) continue;
            ((CJomtTextNode)list.get(i2)).setComponentFocus(false);
            ((CJomtTextNode)list.get(i2)).setSelected(false);
        }
        diagramEditor.getCanvas().requestFocus();
        diagramEditor.repaintCanvas();
    }

    protected void alignmentAll(LabelPresentation labelPresentation, List list) {
        double d2 = labelPresentation.getMaxX() + 50.0;
        double d3 = labelPresentation.getMinY();
        for (Presentation presentation : list) {
            RectPresentation rectPresentation;
            if (presentation.equals(labelPresentation)) continue;
            if (presentation instanceof PortPresentation) {
                rectPresentation = (PortPresentation)presentation;
                PresentationContainer presentationContainer = rectPresentation.getContainer();
                if (presentationContainer == null) continue;
                rectPresentation.setLocation(new Pnt2d(presentationContainer.getCenterX(), presentationContainer.getMinY() - 7.0));
                continue;
            }
            if (presentation instanceof PartPresentation) {
                rectPresentation = ((PartPresentation)presentation).getContainer();
                if (rectPresentation == null) continue;
                ((PartPresentation)presentation).setLocation(new Pnt2d(d2, rectPresentation.getLocation().getY() + 40.0));
                continue;
            }
            if (!(presentation instanceof LabelPresentation)) continue;
            ((LabelPresentation)presentation).setLocation(new Pnt2d(d2, d3));
            d3 = d3 + ((LabelPresentation)presentation).getHeight() + 20.0;
        }
    }

    public static void resizeAll(List list) {
        for (Presentation presentation : list) {
            if (!(presentation instanceof LabelPresentation)) continue;
            ((LabelPresentation)presentation).resize();
        }
    }

    public static void removeNontargetModels(UMLDiagram uMLDiagram, List<Element> list) {
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Element element = (Element)objectArray[i2];
        }
    }

    protected void removeExistedModels(UMLDiagram uMLDiagram, List<Element> list) {
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Element element = (Element)objectArray[i2];
            if (!this.isExistedPresentation(uMLDiagram, element)) continue;
            list.remove(element);
        }
    }

    protected boolean isExistedPresentation(UMLDiagram uMLDiagram, Element element) {
        List<Presentation> list = uMLDiagram.getPresentations();
        for (Presentation presentation : list) {
            if (element != presentation.getModel()) continue;
            return true;
        }
        return false;
    }

    private LabelPresentation a() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Object[] objectArray = diagramEditor.getSelectedModels();
        if (objectArray == null || objectArray.length == 0 || !(objectArray[0] instanceof UserObject)) {
            return null;
        }
        EObject eObject = ((UserObject)objectArray[0]).getModel();
        if (this.isValidModel(eObject)) {
            return (LabelPresentation)((UserObject)objectArray[0]).getPresentation();
        }
        return null;
    }

    protected boolean isValidModel(EObject eObject) {
        return eObject instanceof Classifier || eObject instanceof Package || eObject instanceof Property || eObject instanceof Port;
    }

    public static List addPresentations(IEntityStore iEntityStore, UMLDiagram uMLDiagram, List<Element> list) throws IllegalModelTypeException {
        return AddDependedPresentationsCommand.addPresentations(iEntityStore, uMLDiagram, list, null);
    }

    protected static JomtPresentation setPresentationVisibility(JomtPresentation jomtPresentation) {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            try {
                String string = resourceBundleList.getString("astah.add_depend_presentation_command");
                String string2 = "setVisibilities";
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod(string2, Presentation.class);
                return (JomtPresentation)method.invoke(clazz, jomtPresentation);
            }
            catch (SecurityException securityException) {
                b.error("Exception : " + LogUtil.getStackTrace(securityException));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                b.error("Exception : " + LogUtil.getStackTrace(noSuchMethodException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                b.error("Exception : " + LogUtil.getStackTrace(illegalArgumentException));
            }
            catch (IllegalAccessException illegalAccessException) {
                b.error("Exception : " + LogUtil.getStackTrace(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                b.error("Exception : " + LogUtil.getStackTrace(invocationTargetException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                b.error("Exception : " + LogUtil.getStackTrace(classNotFoundException));
            }
        }
        return null;
    }

    protected static JomtPresentation getPresentation(UMLDiagram uMLDiagram, Element element) {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            try {
                String string = resourceBundleList.getString("astah.create_model_presentation_command");
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                Object var6_13 = null;
                Method method = clazz.getMethod("createPresentation", UMLDiagram.class, Element.class, Boolean.TYPE);
                return (JomtPresentation)method.invoke(obj, uMLDiagram, element, false);
            }
            catch (InstantiationException instantiationException) {
                b.error("Exception : " + LogUtil.getStackTrace(instantiationException));
            }
            catch (SecurityException securityException) {
                b.error("Exception : " + LogUtil.getStackTrace(securityException));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                b.error("Exception : " + LogUtil.getStackTrace(noSuchMethodException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                b.error("Exception : " + LogUtil.getStackTrace(illegalArgumentException));
            }
            catch (IllegalAccessException illegalAccessException) {
                b.error("Exception : " + LogUtil.getStackTrace(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                b.error("Exception : " + LogUtil.getStackTrace(invocationTargetException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                b.error("Exception : " + LogUtil.getStackTrace(classNotFoundException));
            }
        }
        return null;
    }

    public static List addPresentations(IEntityStore iEntityStore, UMLDiagram uMLDiagram, List<Element> list, LabelPresentation labelPresentation) throws IllegalModelTypeException {
        ArrayList<JomtPresentation> arrayList = new ArrayList<JomtPresentation>();
        for (Element element : list) {
            JomtPresentation jomtPresentation = AddDependedPresentationsCommand.getPresentation(uMLDiagram, element);
            if (jomtPresentation == null) continue;
            iEntityStore.addEntity(jomtPresentation);
            ElementPresentations.addPresentation(element, jomtPresentation, uMLDiagram);
            ((RectPresentation)jomtPresentation).setBodyColorWithDefault();
            arrayList.add(jomtPresentation);
        }
        return arrayList;
    }

    protected static PartPresentation getPartPresentation(Property property, RectPresentation rectPresentation) {
        for (PartPresentation partPresentation : Iterables.filter(Presentations.getPresentations(property), PartPresentation.class)) {
            if (AddDependedPresentationsCommand.getContainerClassPs(partPresentation) != rectPresentation) continue;
            return partPresentation;
        }
        return null;
    }

    protected static Property getPartWithPort(ConnectableElement connectableElement) {
        for (Object e2 : connectableElement.getEnds()) {
            ConnectorEnd connectorEnd = (ConnectorEnd)e2;
            if (connectorEnd.getPartWithPort() == null) continue;
            return connectorEnd.getPartWithPort();
        }
        return null;
    }

    protected boolean isPartPresentation(Presentation presentation) {
        return presentation instanceof PartPresentation;
    }

    protected boolean isPortPresentation(Presentation presentation) {
        return presentation instanceof PortPresentation;
    }

    protected static PresentationContainer getContainerClassPs(Presentation presentation) {
        if (presentation instanceof PartPresentation) {
            return ((PartPresentation)presentation).getContainer();
        }
        if (presentation instanceof PortPresentation) {
            PresentationContainer presentationContainer = ((PortPresentation)presentation).getContainer();
            if (presentationContainer instanceof ClassifierPresentation) {
                return (ClassifierPresentation)presentationContainer;
            }
            if (presentationContainer instanceof PartPresentation) {
                return AddDependedPresentationsCommand.getContainerClassPs(presentationContainer);
            }
        } else if (presentation instanceof ClassifierPresentation) {
            return (ClassifierPresentation)presentation;
        }
        return null;
    }

    @Keep
    protected static void setVisibilities(Presentation presentation) {
        if (!(presentation instanceof ClassifierPresentation)) {
            return;
        }
        ClassifierPresentation classifierPresentation = (ClassifierPresentation)presentation;
        ClassifierFactory.setVisibilities(classifierPresentation);
    }

    protected void callStaticMethodOfaddDependedModels(UMLDiagram uMLDiagram, List<Element> list) {
        AddDependedPresentationsCommand.addDependedModels(uMLDiagram, list);
    }

    public static void addDependedModels(UMLDiagram uMLDiagram, List<Element> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.addAll(list);
        for (Element element : arrayList) {
            if (!(element instanceof Classifier) && !(element instanceof Package) && !(element instanceof Property) && !(element instanceof Port)) continue;
            if (element instanceof Classifier) {
                AddDependedPresentationsCommand.addModelsOfAssociationType((Classifier)element, list);
            }
            if (element instanceof ConnectableElement) {
                AddDependedPresentationsCommand.a(uMLDiagram, (ConnectableElement)element, list);
            }
            AddDependedPresentationsCommand.addModelsOfClientDependencyType(element, list);
            AddDependedPresentationsCommand.addModelsOfSupplierDependencyType(element, list);
            if (element instanceof Classifier) {
                AddDependedPresentationsCommand.addModelsOfGeneralizationType((Classifier)element, list);
                AddDependedPresentationsCommand.addModelsOfSpecializationType((Classifier)element, list);
            }
            if (!(element instanceof UseCase)) continue;
            AddDependedPresentationsCommand.addModelsOfIncludeUseCase((UseCase)element, list);
            AddDependedPresentationsCommand.addModelsOfExtendUseCase((UseCase)element, list);
        }
    }

    private static void a(UMLDiagram uMLDiagram, ConnectableElement connectableElement, List<Element> list) {
    }

    protected static void addModelsOfTemplateType(Element element, List<Element> list) {
        if (!(element instanceof TemplateableElement)) {
            return;
        }
        EList<TemplateBinding> eList = ((TemplateableElement)element).getTemplateBindings();
        for (TemplateBinding templateBinding : eList) {
            TemplateableElement templateableElement = templateBinding.getSignature().getTemplate();
            if (list.contains(templateableElement)) continue;
            list.add(templateableElement);
        }
    }

    protected static void addModelsOfBoundElementType(Element element, List<Element> list) {
        if (!(element instanceof TemplateableElement)) {
            return;
        }
        TemplateSignature templateSignature = ((TemplateableElement)element).getOwnedTemplateSignature();
        if (templateSignature == null) {
            return;
        }
    }

    protected static void addModelsOfAssociationType(Classifier classifier, List<Element> list) {
        EList<Association> eList = classifier.getAssociations();
        for (Association association : eList) {
            Type type = Associations.getTargetMemberEndType(association);
            if (!list.contains(type) && !classifier.equals(type)) {
                list.add(type);
                continue;
            }
            Type type2 = Associations.getSourceMemberEndType(association);
            if (list.contains(type2) || classifier.equals(type2)) continue;
            list.add(type2);
        }
    }

    protected static void addModelsOfClientDependencyType(Element element, List<Element> list) {
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            EList<Dependency> eList = namedElement.getClientDependencies();
            for (Dependency dependency : eList) {
                NamedElement namedElement2 = (NamedElement)dependency.getSuppliers().get(0);
                if (!(namedElement2 instanceof NamedElement) || list.contains(namedElement2)) continue;
                list.add(namedElement2);
            }
        }
    }

    protected static void addModelsOfSupplierDependencyType(Element element, List<Element> list) {
        if (element instanceof NamedElement) {
            List<Dependency> list2 = NamedElements.getSupplierDependencies((NamedElement)element);
            for (Dependency dependency : list2) {
                NamedElement namedElement = (NamedElement)dependency.getClients().get(0);
                if (namedElement instanceof Property) {
                    Type type = ((Property)namedElement).getType();
                    if (list.contains(type)) continue;
                    list.add(type);
                    continue;
                }
                if (element instanceof Port || list.contains(namedElement)) continue;
                list.add(namedElement);
            }
        }
    }

    protected static void addModelsOfGeneralizationType(Classifier classifier, List<Element> list) {
        EList<Generalization> eList = classifier.getGeneralizations();
        for (Generalization generalization : eList) {
            Classifier classifier2 = generalization.getGeneral();
            if (list.contains(classifier2)) continue;
            list.add(classifier2);
        }
    }

    protected static void addModelsOfSpecializationType(Classifier classifier, List<Element> list) {
        list.addAll(Classifiers.getSpecificClasses(classifier));
    }

    protected List callStaticMethodOfaddRelationPresentations(List list, UMLDiagram uMLDiagram) throws IllegalModelTypeException {
        return AddDependedPresentationsCommand.addRelationPresentations(list, uMLDiagram);
    }

    public static List addRelationPresentations(List list, UMLDiagram uMLDiagram) throws IllegalModelTypeException {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (Presentation presentation : list) {
            EObject eObject = presentation.getModel();
            if (!(eObject instanceof NamedElement) && !(eObject instanceof Property) && !(eObject instanceof Port)) continue;
            AddRelatedPsForClassifierMethod addRelatedPsForClassifierMethod = new AddRelatedPsForClassifierMethod(uMLDiagram, (Element)eObject, presentation);
            arrayList.addAll(addRelatedPsForClassifierMethod.addRelatedPresentation(false));
        }
        return arrayList;
    }

    public void setClassifierPs(LabelPresentation labelPresentation) {
        this.a = labelPresentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.diagram = uMLDiagram;
    }

    protected void removeInvalidatePorts(UMLDiagram uMLDiagram, List list) {
    }

    protected static void addModelsOfIncludeUseCase(UseCase useCase, List<Element> list) {
        EObject eObject;
        for (EStructuralFeature.Setting object2 : UML2Util.getNonNavigableInverseReferences(useCase)) {
            eObject = object2.getEObject();
            if (!(eObject instanceof Include) || ((Include)eObject).getAddition() != useCase) continue;
            list.add(((Include)eObject).getIncludingCase());
        }
        EList<Include> eList = useCase.getIncludes();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            eObject = (Include)iterator.next();
            list.add(eObject.getAddition());
        }
    }

    protected static void addModelsOfExtendUseCase(UseCase useCase, List list) {
        EObject eObject;
        for (EStructuralFeature.Setting object2 : UML2Util.getNonNavigableInverseReferences(useCase)) {
            eObject = object2.getEObject();
            if (!(eObject instanceof Extend) || ((Extend)eObject).getExtendedCase() != useCase) continue;
            list.add(((Extend)eObject).getExtension());
        }
        EList<Extend> eList = useCase.getExtends();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            eObject = (Extend)iterator.next();
            list.add(eObject.getExtendedCase());
        }
    }
}

