/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.StatePresentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.State;

public abstract class AddActionToStateCommand
extends Command {
    protected State state;
    protected String name = "action";
    private boolean a = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.state == null) {
                DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
                Object[] objectArray = diagramEditor.getSelectedModels();
                if (objectArray == null || objectArray.length == 0) {
                    return;
                }
                if (!(objectArray[0] instanceof UserObject)) {
                    return;
                }
                Presentation presentation = ((UserObject)objectArray[0]).getPresentation();
                if (!(presentation instanceof StatePresentation)) {
                    return;
                }
                this.state = (State)((StatePresentation)presentation).getModel();
            }
            if (this.isExistedAction() && !this.a) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.createAction(iJomtEntityStore.getDomain());
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void createAction(EditingDomain editingDomain) throws InterruptedException, RollbackException {
        CommandUtils.execute(editingDomain, SetCommand.create(editingDomain, this.state, this.getFeature(), this.name));
    }

    protected abstract EStructuralFeature getFeature();

    protected abstract boolean isExistedAction();

    public void setState(State state) {
        this.state = state;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOverwrite(boolean bl) {
        this.a = bl;
    }
}

