/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.astah.golf.control.Mode;
import net.astah.golf.draw.GNode;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLClassDiagram;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UMLCompositeStructureDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLDiagramWithAssociations;
import net.astah.jmodel.UMLObjectDiagram;
import net.astah.jmodel.UMLPackageDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jmodel.UMLUseCaseDiagram;
import net.astah.jmodel.util.JmodelAdapterFactory;
import net.astah.jmodel.util.JmodelSwitch;
import net.astah.jomt.jcontrol.mode.CollaborationDiagramDnDMode;
import net.astah.jomt.jcontrol.mode.CompositeStructureDiagramDnDMode;
import net.astah.jomt.jcontrol.mode.DiagramDnDMode;
import net.astah.jomt.jcontrol.mode.DiagramPopupMode;
import net.astah.jomt.jcontrol.mode.DiagramZoomMode;
import net.astah.jomt.jcontrol.mode.MessageModifyMode;
import net.astah.jomt.jcontrol.mode.MoveFeatureMode;
import net.astah.jomt.jcontrol.mode.MoveMode;
import net.astah.jomt.jcontrol.mode.PluralMoveMode;
import net.astah.jomt.jcontrol.mode.RelationMode;
import net.astah.jomt.jcontrol.mode.ResizeMode;
import net.astah.jomt.jcontrol.mode.SequenceDiagramDnDMode;
import net.astah.jomt.jcontrol.mode.StateChartDiagramDnDMode;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jviewElement.JomtDiagramViewElement;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.editor.ItemEditorFactoryImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmodelEditorAdapterFactory
extends JmodelAdapterFactory {
    private static final Logger a = LoggerFactory.getLogger(JmodelEditorAdapterFactory.class);
    protected Collection<Object> supportedTypes = new HashSet<Object>();
    protected Adapter adapter;

    public JmodelEditorAdapterFactory() {
        this.supportedTypes.add(IItemEditorFactory.class);
    }

    @Override
    public Adapter createAdapter(Notifier notifier) {
        if (this.adapter == null) {
            this.adapter = new ItemEditorFactoryImpl(new CreateSwitch(), null, new AssociateModeSwitch(), new LineSwitch(), new ModeToolBarSwitch(), null);
        }
        return this.adapter;
    }

    @Override
    public boolean isFactoryForType(Object object) {
        return this.supportedTypes.contains(object) || super.isFactoryForType(object);
    }

    @Override
    protected void associate(Adapter adapter, Notifier notifier) {
    }

    protected static class ModeToolBarSwitch
    extends JmodelSwitch<String> {
        protected ModeToolBarSwitch() {
        }

        @Override
        public String caseUMLClassDiagram(UMLClassDiagram uMLClassDiagram) {
            return "diagramview.modetoolbar.class_modetoolbar";
        }

        @Override
        public String caseUMLObjectDiagram(UMLObjectDiagram uMLObjectDiagram) {
            return "diagramview.modetoolbar.object_modetoolbar";
        }

        @Override
        public String caseUMLPackageDiagram(UMLPackageDiagram uMLPackageDiagram) {
            return "diagramview.modetoolbar.package_modetoolbar";
        }

        @Override
        public String caseUMLUseCaseDiagram(UMLUseCaseDiagram uMLUseCaseDiagram) {
            return "diagramview.modetoolbar.usecase_modetoolbar";
        }

        @Override
        public String caseUMLStateChartDiagram(UMLStateChartDiagram uMLStateChartDiagram) {
            return "diagramview.modetoolbar.statechart_modetoolbar";
        }

        @Override
        public String caseUMLActivityDiagram(UMLActivityDiagram uMLActivityDiagram) {
            return "diagramview.modetoolbar.activitygraph_modetoolbar";
        }

        @Override
        public String caseUMLSequenceDiagram(UMLSequenceDiagram uMLSequenceDiagram) {
            return "diagramview.modetoolbar.sequence_modetoolbar";
        }

        @Override
        public String caseUMLCommunicationDiagram(UMLCommunicationDiagram uMLCommunicationDiagram) {
            return "diagramview.modetoolbar.collaboration_modetoolbar";
        }

        @Override
        public String caseUMLCompositeStructureDiagram(UMLCompositeStructureDiagram uMLCompositeStructureDiagram) {
            return "diagramview.modetoolbar.compositestructure_modetoolbar";
        }
    }

    protected static class LineSwitch
    extends JmodelSwitch<String> {
        protected LineSwitch() {
        }

        @Override
        public String caseUMLClassDiagram(UMLClassDiagram uMLClassDiagram) {
            return "uml.class_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLPackageDiagram(UMLPackageDiagram uMLPackageDiagram) {
            return "uml.package_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLObjectDiagram(UMLObjectDiagram uMLObjectDiagram) {
            return "uml.object_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLUseCaseDiagram(UMLUseCaseDiagram uMLUseCaseDiagram) {
            return "uml.usecase_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLStateChartDiagram(UMLStateChartDiagram uMLStateChartDiagram) {
            return "uml.state_chart_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLActivityDiagram(UMLActivityDiagram uMLActivityDiagram) {
            return "uml.activity_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLSequenceDiagram(UMLSequenceDiagram uMLSequenceDiagram) {
            return "uml.sequence_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLCommunicationDiagram(UMLCommunicationDiagram uMLCommunicationDiagram) {
            return "uml.collaboration_diagram.line_shape.selected";
        }

        @Override
        public String caseUMLCompositeStructureDiagram(UMLCompositeStructureDiagram uMLCompositeStructureDiagram) {
            return "uml.compositestructure_diagram.line_shape.selected";
        }
    }

    protected static class AssociateModeSwitch
    extends JmodelSwitch<List<Mode>> {
        protected AssociateModeSwitch() {
        }

        @Override
        public List<Mode> caseUMLSequenceDiagram(UMLSequenceDiagram uMLSequenceDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            arrayList.add(new MessageModifyMode());
            arrayList.add(new SequenceDiagramDnDMode());
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLActivityDiagram(UMLActivityDiagram uMLActivityDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            try {
                ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
                String string = resourceBundleList.getString("jude.resize_swimlane_mode_manager");
                Class<?> clazz = Class.forName(string);
                Mode mode = (Mode)clazz.newInstance();
                arrayList.add(mode);
                String string2 = resourceBundleList.getString("jude.activity_diagram_drag_and_drop_mode_manager");
                Class<?> clazz2 = Class.forName(string2);
                Mode mode2 = (Mode)clazz2.newInstance();
                arrayList.add(mode2);
            }
            catch (Exception exception) {
                a.warn("Failed to get mode for " + uMLActivityDiagram.getName(), exception);
            }
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLStateChartDiagram(UMLStateChartDiagram uMLStateChartDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            arrayList.add(new StateChartDiagramDnDMode());
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLClassDiagram(UMLClassDiagram uMLClassDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
            try {
                String string = resourceBundleList.getString("jude.class_diagram_drag_and_drop_mode_manager");
                Class<?> clazz = Class.forName(string);
                Mode mode = (Mode)clazz.newInstance();
                arrayList.add(mode);
            }
            catch (Exception exception) {
                a.warn("Failed to get mode for " + uMLClassDiagram.getName(), exception);
            }
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLCompositeStructureDiagram(UMLCompositeStructureDiagram uMLCompositeStructureDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            arrayList.add(new CompositeStructureDiagramDnDMode());
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLCommunicationDiagram(UMLCommunicationDiagram uMLCommunicationDiagram) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            arrayList.add(new CollaborationDiagramDnDMode());
            return arrayList;
        }

        @Override
        public List<Mode> caseUMLDiagramWithAssociations(UMLDiagramWithAssociations uMLDiagramWithAssociations) {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.addAll(this.a());
            arrayList.add(new DiagramDnDMode());
            return arrayList;
        }

        private List<Mode> a() {
            ArrayList<Mode> arrayList = Lists.newArrayList();
            arrayList.add(new MoveMode());
            arrayList.add(new PluralMoveMode());
            arrayList.add(new DiagramPopupMode());
            arrayList.add(new DiagramZoomMode());
            arrayList.add(new ResizeMode());
            arrayList.add(new MoveFeatureMode());
            arrayList.add(new RelationMode());
            return arrayList;
        }
    }

    protected static class CreateSwitch
    extends JmodelSwitch<GNode> {
        protected CreateSwitch() {
        }

        @Override
        public GNode caseUMLDiagram(UMLDiagram uMLDiagram) {
            JomtDiagramViewElement jomtDiagramViewElement = new JomtDiagramViewElement(uMLDiagram);
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (iJomtEntityStore != null && !ViewGlobal.isSilentMode) {
                jomtDiagramViewElement.setEntityStore(iJomtEntityStore);
            }
            return jomtDiagramViewElement;
        }
    }
}

