/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.astah.golf.control.CommandManager;
import net.astah.golf.widget.CDesktopPane;
import net.astah.jomt.jcontrol.AlignEditorsCommand;
import net.astah.jomt.jcontrol.GridLayoutEditorsCommand;
import net.astah.jomt.jcontrol.HorizontalEditorsCommand;
import net.astah.jomt.jcontrol.VerticalEditorsCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.IEditorAlignKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorAlignKeeper
implements IEditorAlignKeeper {
    static final Logger a = LoggerFactory.getLogger(EditorAlignKeeper.class);
    public static final EditorAlignKeeper INSTANCE = new EditorAlignKeeper();
    private IEditorAlignKeeper.ALIGN_KIND b = null;
    private final List<Editor> c = new ArrayList<Editor>();
    private final List<Editor> d = new ArrayList<Editor>();
    private final List<Editor> e = new ArrayList<Editor>();

    private EditorAlignKeeper() {
    }

    @Override
    public void startKeeping(@NonNull IEditorAlignKeeper.ALIGN_KIND aLIGN_KIND, @NonNull List<Editor> list) {
        if (aLIGN_KIND == null) {
            throw new NullPointerException("alignKind");
        }
        if (list == null) {
            throw new NullPointerException("editors");
        }
        this.b = aLIGN_KIND;
        this.c.clear();
        this.c.addAll(list);
    }

    @Override
    public boolean isKeeping() {
        return this.b != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editorAttaching(@NonNull Editor editor) {
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (!this.isKeeping()) {
            return;
        }
        List<Editor> list = this.d;
        synchronized (list) {
            this.d.add(editor);
            if (this.d.size() == 1) {
                SwingInvoker.runLaterInEDT(() -> {
                    List<Editor> list = this.d;
                    synchronized (list) {
                        this.c.addAll(this.d);
                        this.d.clear();
                    }
                    this.a(this.c);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editorDetaching(@NonNull Editor editor) {
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (!this.isKeeping()) {
            return;
        }
        List<Editor> list = this.e;
        synchronized (list) {
            this.e.add(editor);
            if (this.e.size() == 1) {
                SwingInvoker.runLaterInEDT(() -> {
                    List<Editor> list = this.e;
                    synchronized (list) {
                        this.c.removeAll(this.e);
                        this.e.clear();
                    }
                    int n2 = this.c.size();
                    if (n2 == 0) {
                        this.a();
                    } else if (n2 == 1) {
                        List<Editor> list2 = Collections.singletonList(this.c.get(0));
                        this.a();
                        this.a(list2, true);
                    } else {
                        this.a(this.c);
                    }
                });
            }
        }
    }

    @Override
    public void editorMaximizing(@NonNull Editor editor) {
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (!this.isKeeping()) {
            return;
        }
        ArrayList<Editor> arrayList = Lists.newArrayList(this.c);
        this.a();
        SwingInvoker.runLaterInEDT(() -> {
            arrayList.remove(editor);
            this.a((List<Editor>)arrayList, false);
            this.a(Collections.singletonList(editor), true);
        });
    }

    @Override
    public void realign() {
        if (!this.isKeeping()) {
            return;
        }
        SwingInvoker.runLaterInEDT(() -> this.a(this.c));
    }

    private void a() {
        this.b = null;
        this.c.clear();
    }

    private void a(List<Editor> list) {
        AlignEditorsCommand alignEditorsCommand = this.b();
        if (alignEditorsCommand == null) {
            return;
        }
        alignEditorsCommand.setEditors(list);
        CommandManager.instance().callCommand(alignEditorsCommand);
    }

    private AlignEditorsCommand b() {
        if (this.b != null) {
            switch (this.b) {
                case HORIZONTAL: {
                    return new HorizontalEditorsCommand();
                }
                case VERTICAL: {
                    return new VerticalEditorsCommand();
                }
                case TILE: {
                    return new GridLayoutEditorsCommand();
                }
            }
        }
        return null;
    }

    private void a(List<Editor> list, boolean bl) {
        if (list.isEmpty()) {
            return;
        }
        CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
        int n2 = cDesktopPane.getWidth();
        int n3 = cDesktopPane.getHeight();
        for (Editor editor : list) {
            editor.setMaximum(false);
            editor.getContainer().setBounds(0, 0, n2, n3);
            if (!bl) continue;
            editor.setMaximum(true);
        }
    }
}

