/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.jomt.jcontrol.HyperlinkOpener;
import net.astah.jomt.jview.NamespaceNameFactory;
import net.astah.model.extension.Hyperlink;
import net.astah.model.extension.Hyperlinks;
import net.astah.notation.edit.layout.DiagramElementOperations;
import org.eclipse.emf.ecore.EObject;

public class HyperlinkEditor {
    public static String getDisplayName(Hyperlink hyperlink) {
        if (!hyperlink.getComment().equals("")) {
            return hyperlink.getComment();
        }
        if (hyperlink.getType().equals("model")) {
            return Hyperlinks.getDisplayName(hyperlink);
        }
        if (hyperlink.getType().equals("file")) {
            String string = "";
            if (!HyperlinkOpener.canOpenHyperlink(hyperlink)) {
                string = Hyperlinks.getTitle("ui.hyperlink_information_dialog.unavailableFile.label");
            }
            return hyperlink.getName() + string;
        }
        return hyperlink.getName();
    }

    public static String getDisplayPath(Hyperlink hyperlink) {
        String string = "";
        if (!hyperlink.getType().equals("model")) {
            string = hyperlink.getPath();
        } else {
            EObject eObject = hyperlink.getReference();
            if (eObject instanceof DiagramElement && !(eObject instanceof Diagram)) {
                Diagram diagram = DiagramElementOperations.getDiagram((DiagramElement)eObject);
                string = NamespaceNameFactory.getNamespace(diagram);
                String string2 = diagram.getName();
                string = string.equals("") ? string + string2 : string + "::" + string2;
            } else {
                string = NamespaceNameFactory.getNamespace(eObject);
            }
        }
        return string;
    }
}

