/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.IconResource;
import proguard.annotation.Keep;

@Keep
public class CloseTabButtonPanel
extends JPanel {
    private static final long serialVersionUID = -5884414216246834238L;
    protected final JTabbedPane pane;

    public CloseTabButtonPanel(final JTabbedPane jTabbedPane) {
        super(new FlowLayout(0, 0, 0));
        if (jTabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = jTabbedPane;
        this.setOpaque(false);
        JLabel jLabel = new JLabel(){
            private static final long serialVersionUID = -9019387782751243047L;

            @Override
            public Icon getIcon() {
                int n2 = CloseTabButtonPanel.this.indexOfTabComponent(jTabbedPane);
                if (n2 != -1) {
                    return jTabbedPane.getIconAt(n2);
                }
                return null;
            }
        };
        JLabel jLabel2 = new JLabel(){
            private static final long serialVersionUID = -6743229825848716945L;

            @Override
            public String getText() {
                int n2 = CloseTabButtonPanel.this.indexOfTabComponent(jTabbedPane);
                if (n2 != -1) {
                    return jTabbedPane.getTitleAt(n2);
                }
                return null;
            }
        };
        this.add(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(jLabel2);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JButton jButton = this.createCloseTabButton();
        this.add(jButton);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    protected JButton createCloseTabButton() {
        return new CloseTabButton();
    }

    protected int indexOfTabComponent(JTabbedPane jTabbedPane) {
        return jTabbedPane.indexOfTabComponent(this);
    }

    protected class CloseTabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -5859246500809172337L;

        public CloseTabButton() {
            Icon icon = IconResource.getCloseButtonIcon();
            this.setIcon(icon);
            this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
            this.setToolTipText(this.a("managementview.tabbed_panel.close_button.tooltip"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.setRolloverIcon(IconResource.getCloseButtonRolloverIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = CloseTabButtonPanel.this.indexOfTabComponent(CloseTabButtonPanel.this.pane);
            Editor editor = JomtGlobal.viewManager.getManagementView().getEditor(n2);
            JomtGlobal.viewManager.removeEditor(editor);
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.getModel().isPressed()) {
                Icon icon = this.getRolloverIcon();
                icon.paintIcon(this, graphics, 2, 2);
            } else if (this.getModel().isRollover()) {
                Icon icon = this.getRolloverIcon();
                icon.paintIcon(this, graphics, 1, 1);
            } else {
                Icon icon = this.getIcon();
                icon.paintIcon(this, graphics, 1, 1);
            }
        }

        private String a(String string) {
            String string2 = PropertyManager.getManagementWindowResourceBundle().getString(string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
    }
}

