/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichTextSelection
implements ClipboardOwner,
Transferable {
    private static final Logger logger = LoggerFactory.getLogger(RichTextSelection.class);
    protected static DataFlavor richTextFlavor;
    protected DataFlavor[] flavors = new DataFlavor[]{richTextFlavor};
    protected String richText;

    public RichTextSelection(String string) {
        this.richText = string;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Arrays.asList(this.flavors).contains(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(richTextFlavor)) {
            byte[] byArray = this.richText.getBytes();
            return new ByteArrayInputStream(byArray);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static {
        try {
            richTextFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("error has occurred", classNotFoundException);
        }
    }
}

