/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.commontable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.swing.AdjustFontSizeTextArea;

public class CommonTableTextAreaRenderer
extends AdjustFontSizeTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 707243046387950419L;
    private Color unselectedForeground;
    private Color unselectedBackground;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CommonTableTextAreaRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n2, n3)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setText((String)object);
        this.a(jTable, n2);
        return this;
    }

    private void a(JTable jTable, int n2) {
        int n3 = jTable.getColumnModel().getColumn(0).getWidth() - 10;
        int n4 = this.getPreferredHeight(n3);
        if (n4 > 20 && n4 != jTable.getRowHeight(n2)) {
            jTable.setRowHeight(n2, n4);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public int getPreferredHeight(int n2) {
        this.setSize(n2, this.getHeight());
        int n3 = (int)this.getPreferredSize().getHeight();
        if (n3 > 40 && this.a(this.getText(), n2)) {
            return 19;
        }
        return n3;
    }

    private boolean a(String string, int n2) {
        if (string.indexOf("\n") >= 0) {
            return false;
        }
        return !(GolfUtilities.computeStringWidth(this.getFont(), string) > (double)n2);
    }
}

