/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.judebiz.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import net.astah.golf.util.GolfProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizProperty
extends GolfProperties {
    private static final Logger a = LoggerFactory.getLogger(BizProperty.class);
    private static final long serialVersionUID = 2054788752284980428L;
    public static final String SUFFIX_TAG = ".tag";
    public static final String SUFFIX_KEY = ".key";
    public static final String SUFFIX_LABEL = ".label";
    public static final String SUFFIX_NAME = ".name";
    public static final String SUFFIX_UI_TYPE = ".ui_type";
    public static final String SUFFIX_DATA_TYPE = ".data_type";
    public static final String SUFFIX_EDITABLE = ".editable";
    public static final String SUFFIX_ITEMS = ".items";
    public static final String SUFFIX_DESCRIPTION = ".description";
    public static final String SUFFIX_WIDTH = ".width";
    public static final String SUFFIX_IS_SHOW_VERTICAL = ".is_show_vertical_name";
    public static final String SUFFIX_ELEMENT_INDEX = ".element_index";
    public static final String SUFFIX_COLUMN_HEADER_NAME = ".column_header_name";
    public static final String SUFFIX_GROUP = ".group";
    public static final String SUFFIX_VISIBLE = ".visible";
    public static final String SUFFIX_LINE_NUMBER_ENABLE = ".line_number_enable";
    public static final String SUFFIX_LINE_NUMBER_LABEL = ".line_number_label";
    public static final String SUFFIX_LINE_NUMBER_WIDTH = ".line_number_width";
    public static final String SUFFIX_TYPE = ".type";
    public static final String SUFFIX_CHOICE_ITEMS = ".choice_items";
    public static final String DATA_TYPE_STRING = "string";
    public static final String DATA_TYPE_TEXT = "text";
    public static final String DATA_TYPE_MULTI_LINE_TEXT = "multiline";
    public static final String DATA_TYPE_CHOICE = "choice";
    public static final String DATA_TYPE_BOOLEAN = "boolean";
    public static final String DATA_TYPE_GROUP = "group";
    public static final String UI_TYPE_TEXT_FIELD = "text_field";
    public static final String UI_TYPE_TEXT_AREA = "text_area";
    public static final String UI_TYPE_COMBOBOX = "combobox";
    public static final String UI_TYPE_CHECKBOX = "checkbox";
    public static final String UI_TYPE_CHECK = "check";
    protected ResourceBundle resourceBundle;
    protected String propertyFilePath;
    private boolean hasLoaded = false;

    protected ResourceBundle getResourceBundle(String string) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.resourceBundle;
    }

    public void reload() {
        this.hasLoaded = false;
        this.load(this.propertyFilePath);
    }

    public void restoreDefaultFormat() {
        try {
            new File(this.propertyFilePath).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear();
        this.reload();
    }

    public void load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.load(fileInputStream);
            fileInputStream.close();
            this.hasLoaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void store(String string) {
        string = string != null ? string : this.propertyFilePath;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            a.info("file: {}", (Object)string);
            this.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
        }
    }

    public String getValue(String string) {
        String string2 = null;
        String string3 = this.getString(string);
        string2 = string3 != null ? string3 : this.resourceBundle.getString(string);
        return string2 == null ? "" : string2;
    }

    public String getPropertyFilePath() {
        return this.propertyFilePath;
    }

    public String getKey(String string) {
        return this.getValue(string + SUFFIX_KEY);
    }

    public String getLabel(String string) {
        return this.getValue(string + SUFFIX_LABEL);
    }

    public String getType(String string) {
        return this.getValue(string + SUFFIX_TYPE);
    }

    public String getDescription(String string) {
        return this.getValue(string + SUFFIX_DESCRIPTION);
    }

    public String getUIType(String string) {
        return this.getValue(string + SUFFIX_UI_TYPE);
    }

    public String getWidth(String string) {
        return this.getValue(string + SUFFIX_WIDTH);
    }

    public boolean isVisible(String string) {
        return this.toBoolean(this.getValue(string + SUFFIX_VISIBLE));
    }

    public boolean isEditable(String string) {
        return this.toBoolean(this.getValue(string + SUFFIX_EDITABLE));
    }

    public String getDataType(String string) {
        return this.getValue(string + SUFFIX_DATA_TYPE);
    }

    public static String getDataTypeByType(String string) {
        String string2 = "";
        string2 = string.equals(DATA_TYPE_TEXT) || string.equals(DATA_TYPE_MULTI_LINE_TEXT) ? DATA_TYPE_STRING : string;
        return string2;
    }

    public static String getUITypeByDataType(String string) {
        String string2 = "";
        if (string.equals(DATA_TYPE_TEXT)) {
            string2 = UI_TYPE_TEXT_FIELD;
        } else if (string.equals(DATA_TYPE_MULTI_LINE_TEXT)) {
            string2 = UI_TYPE_TEXT_AREA;
        } else if (string.equals(DATA_TYPE_BOOLEAN)) {
            string2 = UI_TYPE_CHECKBOX;
        } else if (string.equals(DATA_TYPE_CHOICE)) {
            string2 = UI_TYPE_COMBOBOX;
        }
        return string2;
    }
}

