/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.util;

import com.google.common.base.Objects;
import java.util.Locale;
import lombok.NonNull;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.resource.STAMPResources;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.common.util.UML2Util;

public class HCFHintWordSets {
    public static boolean isHCFHintWordSetPresent(@NonNull HCFHintWordSet hintWordSet, @NonNull STPAAnalysis owner) {
        if (hintWordSet == null) {
            throw new NullPointerException("hintWordSet");
        }
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        return owner.getHCFHintWordSets().stream().anyMatch(e -> Objects.equal((Object)hintWordSet.getName(), (Object)e.getName()) && Objects.equal((Object)hintWordSet.getLanguage(), (Object)e.getLanguage()));
    }

    public static HCFHintWordSet getHintWordSetInProject(@NonNull HCFHintWordSet hintWordSet, @NonNull STPAAnalysis owner) {
        if (hintWordSet == null) {
            throw new NullPointerException("hintWordSet");
        }
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        return owner.getHCFHintWordSets().stream().filter(e -> Objects.equal((Object)hintWordSet.getName(), (Object)e.getName()) && Objects.equal((Object)hintWordSet.getLanguage(), (Object)e.getLanguage())).findFirst().orElse(null);
    }

    public static boolean isHCFHintWordSetInApp(@NonNull HCFHintWordSet hintWordSet, @NonNull STPAAnalysis owner) {
        if (hintWordSet == null) {
            throw new NullPointerException("hintWordSet");
        }
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        return hintWordSet.getOwner() != owner;
    }

    public static EList<HCFHintWordSet> getHintWordSets(STPAAnalysis analysis, ResourceSet resourceSet) {
        BasicEList hintWordSets = new BasicEList();
        hintWordSets.addAll(analysis.getHCFHintWordSets());
        EList<HCFHintWordSet> defaultSets = STAMPResources.getLibraryDefaultHCFHintWordSets(resourceSet);
        hintWordSets.addAll(defaultSets);
        return hintWordSets;
    }

    public static EList<HCFHintWordSet> getLanguageHintWordSets(STPAAnalysis analysis, ResourceSet resourceSet) {
        BasicEList hintWordSets = new BasicEList();
        EList<HCFHintWordSet> allHintWordSets = HCFHintWordSets.getHintWordSets(analysis, resourceSet);
        for (HCFHintWordSet hintWordSet : allHintWordSets) {
            if (Objects.equal((Object)hintWordSet.getLanguage(), (Object)Locale.getDefault().getLanguage())) {
                hintWordSets.add((Object)hintWordSet);
                continue;
            }
            if (UML2Util.getNonNavigableInverseReferences((EObject)hintWordSet).isEmpty()) continue;
            hintWordSets.add((Object)hintWordSet);
        }
        HCFHintWordSet defaultHintWordSet = (HCFHintWordSet)allHintWordSets.get(0);
        if (!hintWordSets.contains((Object)defaultHintWordSet)) {
            hintWordSets.add(0, (Object)defaultHintWordSet);
        }
        return hintWordSets;
    }
}

